/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.marker.NormalMarkerEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class RenderMarker
implements class_827<NormalMarkerEntity, RenderMarkerState> {
    private static final double a = 0.5;
    private static final double b = 0.625;
    private static final double c = 0.375;

    public RenderMarker(class_5614.class_5615 context) {
    }

    public RenderMarkerState createRenderState() {
        return new RenderMarkerState();
    }

    public void extractRenderState(NormalMarkerEntity blockEntity, RenderMarkerState renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity);
    }

    public void submit(RenderMarkerState renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("quarryplus");
        profiler.method_15396("RenderMarker");
        NormalMarkerEntity blockEntity = renderState.marker;
        if (blockEntity.getStatus() == NormalMarkerEntity.Status.CONNECTED_MASTER) {
            class_2338 markerPos = blockEntity.method_11016();
            poseStack.method_22903();
            poseStack.method_46416((float)(-markerPos.method_10263()), (float)(-markerPos.method_10264()), (float)(-markerPos.method_10260()));
            nodeCollector.method_73483(poseStack, class_1921.method_23581(), (pose, vertexConsumer) -> blockEntity.getLink().ifPresent(link -> RenderMarker.renderLink(pose, vertexConsumer, link, ColorBox.markerBlueColor)));
            poseStack.method_22909();
        }
        profiler.method_15407();
        profiler.method_15407();
    }

    static void renderLink(class_4587.class_4665 pose, class_4588 buffer, QuarryMarker.Link link, ColorBox color) {
        class_1058 sprite = Sprites.INSTANCE.getWhite();
        for (Box box : RenderMarker.getRenderBox(link.area())) {
            box.render(buffer, pose, sprite, color);
        }
    }

    public static List<Box> getRenderBox(Area area) {
        int flag = 0;
        int xMin = area.minX();
        int yMin = area.minY();
        int zMin = area.minZ();
        int xMax = area.maxX();
        int yMax = area.maxY();
        int zMax = area.maxZ();
        if (xMin != xMax) {
            flag |= 1;
        }
        if (yMin != yMax) {
            flag |= 2;
        }
        if (zMin != zMax) {
            flag |= 4;
        }
        ArrayList<class_238> boxes = new ArrayList<class_238>(12);
        if ((flag & 1) == 1) {
            boxes.add(new class_238((double)xMin + 0.625, (double)yMin + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMin + 0.5));
        }
        if ((flag & 2) == 2) {
            boxes.add(new class_238((double)xMin + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMin + 0.5));
        }
        if ((flag & 4) == 4) {
            boxes.add(new class_238((double)xMin + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMin + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 3) == 3) {
            boxes.add(new class_238((double)xMin + 0.625, (double)yMax + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMin + 0.5));
            boxes.add(new class_238((double)xMax + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMin + 0.5));
        }
        if ((flag & 5) == 5) {
            boxes.add(new class_238((double)xMin + 0.625, (double)yMin + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMax + 0.5));
            boxes.add(new class_238((double)xMax + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMin + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 6) == 6) {
            boxes.add(new class_238((double)xMin + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMax + 0.5));
            boxes.add(new class_238((double)xMin + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMax + 0.5, (double)zMax + 0.375));
        }
        if ((flag & 7) == 7) {
            boxes.add(new class_238((double)xMin + 0.625, (double)yMax + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMax + 0.5));
            boxes.add(new class_238((double)xMax + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMax + 0.5));
            boxes.add(new class_238((double)xMax + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMax + 0.5, (double)zMax + 0.375));
        }
        return boxes.stream().map(range -> Box.apply(range, Math.max(range.method_17939(), 0.126), Math.max(range.method_17940(), 0.126), Math.max(range.method_17941(), 0.126), true, true)).toList();
    }

    public static class RenderMarkerState
    extends class_11954 {
        private NormalMarkerEntity marker;

        void extract(NormalMarkerEntity marker) {
            this.marker = marker;
        }
    }
}

