/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

final class ItemCountList
extends class_4280<ItemCountRow> {
    final DebugStorageEntity storageEntity;

    public ItemCountList(class_310 minecraft, int width, int height, int y, DebugStorageEntity storageEntity) {
        super(minecraft, width, height, y, 22);
        this.storageEntity = storageEntity;
        this.refreshEntries();
    }

    void refreshEntries() {
        this.method_25314(Stream.concat(this.storageEntity.storage.itemKeyCounts().stream().map(x$0 -> new ItemCountRow((MachineStorage.ItemKeyCount)x$0)), this.storageEntity.storage.fluidKeyCounts().stream().map(x$0 -> new ItemCountRow((MachineStorage.FluidKeyCount)x$0))).toList());
    }

    protected void method_57715(class_332 guiGraphics) {
    }

    protected boolean method_73379() {
        return false;
    }

    public int method_25322() {
        return this.method_25368() - 10;
    }

    protected int method_65507() {
        return this.method_55442() - 6;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemCountRow hovered;
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.method_25405(mouseX, mouseY) && (hovered = (ItemCountRow)this.method_37019()) != null) {
            class_1799 stack = hovered.stack;
            class_2561 component = stack.method_63015();
            guiGraphics.method_51435(this.field_22740.field_1772, List.of(class_5684.method_32662((class_5481)component.method_30937())), mouseX, mouseY, class_8001.field_41687, (class_2960)stack.method_58694(class_9334.field_54198));
        }
    }

    class ItemCountRow
    extends class_4280.class_4281<ItemCountRow> {
        final class_1799 stack;
        final class_2561 name;
        final long count;
        final String unit;

        ItemCountRow(MachineStorage.ItemKeyCount item) {
            this.stack = item.key().toStack(1);
            this.count = item.count();
            this.name = this.stack.method_7964();
            this.unit = "";
        }

        ItemCountRow(MachineStorage.FluidKeyCount fluid) {
            this.stack = fluid.key().fluid().method_15774().method_7854();
            this.count = fluid.count() * 1000L / 81000L;
            this.name = PlatformAccess.getAccess().getFluidName(new FluidStackLike(fluid.key().fluid(), fluid.count(), fluid.key().patch()));
            this.unit = " mB";
        }

        public class_2561 method_37006() {
            return this.name;
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.method_51445(this.stack, ItemCountList.this.method_25342(), this.method_46427());
            class_2561 text = this.method_37006();
            int textWidth = ((ItemCountList)ItemCountList.this).field_22740.field_1772.method_27525((class_5348)text);
            int textX = ItemCountList.this.method_25342() + 20;
            int textY = this.method_46427() + 4;
            guiGraphics.method_27535(((ItemCountList)ItemCountList.this).field_22740.field_1772, text, textX, textY, class_9848.method_61334((int)0xFFFFFF));
            guiGraphics.method_51433(((ItemCountList)ItemCountList.this).field_22740.field_1772, this.count + this.unit, textX + textWidth + 8, textY, class_9848.method_61334((int)0xFFFFFF), true);
        }
    }
}

