/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.storage.DebugStorageScreen;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public final class DebugStorageEntity
extends QpEntity
implements ClientSync {
    @NotNull
    MachineStorage storage;
    private final Set<class_3222> players = new HashSet<class_3222>();

    public DebugStorageEntity(class_2338 pos, class_2680 blockState) {
        super(pos, blockState);
        this.storage = MachineStorage.of();
        this.setStorage(this.storage);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.toClientTag(output);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.fromClientTag(input);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71468("storage", MachineStorage.CODEC.codec(), (Object)this.storage);
        return output;
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.setStorage(input.method_71426("storage", MachineStorage.CODEC.codec()).orElseGet(MachineStorage::of));
    }

    void setStorage(MachineStorage storage) {
        this.storage = storage;
        this.storage.onUpdate(this::syncToOpeningPlayers);
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            this.updateScreenList();
        }
    }

    void updateScreenList() {
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof DebugStorageScreen) {
            DebugStorageScreen screen = (DebugStorageScreen)class_4372;
            if (screen.itemCountList != null) {
                screen.itemCountList.refreshEntries();
            }
        }
    }

    void startOpen(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.players.add(serverPlayer);
        }
    }

    void stopOpen(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.players.remove(serverPlayer);
        }
    }

    void syncToOpeningPlayers() {
        ClientSyncMessage message = new ClientSyncMessage(this);
        for (class_3222 player : this.players) {
            PlatformAccess.getAccess().packetHandler().sendToClientPlayer(message, player);
        }
    }
}

