/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.quarry;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.EnchantmentCache;
import com.yogpc.qp.machine.ItemConverter;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PickIterator;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.PowerMap;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.WorkResult;
import com.yogpc.qp.machine.exp.ExpModule;
import com.yogpc.qp.machine.misc.BlockBreakEventResult;
import com.yogpc.qp.machine.misc.DigMinY;
import com.yogpc.qp.machine.misc.QuarryChunkLoader;
import com.yogpc.qp.machine.module.ConverterModule;
import com.yogpc.qp.machine.module.ModuleInventory;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.machine.quarry.QuarryState;
import com.yogpc.qp.packet.ClientSync;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1694;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7871;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class QuarryEntity
extends PowerEntity
implements ClientSync {
    public static final Marker MARKER = MarkerFactory.getMarker((String)"quarry");
    @NotNull
    public class_243 head;
    @NotNull
    public class_243 targetHead;
    @NotNull
    QuarryState currentState;
    @Nullable
    private Area area;
    @Nullable
    private PickIterator<class_2338> targetIterator;
    @NotNull
    private Set<class_2338> skipped = new HashSet<class_2338>();
    @Nullable
    class_2338 targetPos;
    @NotNull
    MachineStorage storage;
    @NotNull
    public DigMinY digMinY = new DigMinY();
    @NotNull
    final EnchantmentCache enchantmentCache = new EnchantmentCache();
    @NotNull
    Set<QuarryModule> modules = Collections.emptySet();
    @NotNull
    final ModuleInventory moduleInventory = new ModuleInventory(5, q -> true, m -> this.modules, this::method_5431);
    @NotNull
    QuarryChunkLoader chunkLoader = QuarryChunkLoader.None.INSTANCE;
    @NotNull
    ItemConverter itemConverter = QuarryEntity.defaultItemConverter();

    protected QuarryEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.setMaxEnergy((long)(QuarryEntity.powerMap().maxEnergy() * 1.0E9));
        this.targetHead = this.head = class_243.method_24955((class_2382)pos);
        this.currentState = QuarryState.FINISHED;
        this.storage = MachineStorage.of();
        this.moduleInventory.method_5489(container -> this.method_5431());
    }

    static PowerMap.Quarry powerMap() {
        return PlatformAccess.config().powerMap().quarry();
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(QuarryEntity.detail(class_124.field_1060, "State", this.currentState.name()), QuarryEntity.detail(class_124.field_1060, "Area", String.valueOf(this.area)), QuarryEntity.detail(class_124.field_1060, "Head", String.valueOf(this.head)), QuarryEntity.detail(class_124.field_1060, "Storage", String.valueOf(this.storage)), QuarryEntity.detail(class_124.field_1060, "DigMinY", String.valueOf(this.digMinY.getMinY((class_4538)this.field_11863))), QuarryEntity.detail(class_124.field_1060, "Modules", String.valueOf(this.modules))));
    }

    static void serverTick(class_1937 level, class_2338 pos, class_2680 state, QuarryEntity quarryEntity) {
        block10: for (int i = 0; i < quarryEntity.repeatCount(); ++i) {
            if (!quarryEntity.hasEnoughEnergy()) {
                return;
            }
            switch (quarryEntity.currentState) {
                case FINISHED: {
                    return;
                }
                case WAITING: {
                    quarryEntity.waiting();
                    return;
                }
                case BREAK_INSIDE_FRAME: {
                    quarryEntity.breakInsideFrame();
                    continue block10;
                }
                case MAKE_FRAME: {
                    quarryEntity.makeFrame();
                    continue block10;
                }
                case MOVE_HEAD: {
                    quarryEntity.moveHead();
                    continue block10;
                }
                case BREAK_BLOCK: {
                    quarryEntity.breakBlock();
                    continue block10;
                }
                case REMOVE_FLUID: {
                    quarryEntity.removeFluid();
                    continue block10;
                }
                case FILLER: {
                    quarryEntity.filler();
                }
            }
        }
    }

    static void clientTick(class_1937 level, class_2338 pos, class_2680 state, QuarryEntity quarryEntity) {
        quarryEntity.head = quarryEntity.targetHead;
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.toClientTag(output);
        if (this.targetIterator != null && this.targetIterator.getLastReturned() != null) {
            output.method_71468("targetPos", class_2338.field_25064, (Object)this.targetIterator.getLastReturned());
        }
        output.method_71468("storage", MachineStorage.CODEC.codec(), (Object)this.storage);
        output.method_71468("skipped", (Codec)Codec.LONG_STREAM, (Object)this.skipped.stream().mapToLong(class_2338::method_10063));
        this.moduleInventory.method_7660(output.method_71467("moduleInventory", class_1799.field_24671));
        output.method_71468("chunkLoader", QuarryChunkLoader.CODEC, (Object)this.chunkLoader);
    }

    @Override
    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.fromClientTag(input);
        input.method_71426("head", class_243.field_38277).ifPresent(v -> {
            this.head = v;
        });
        class_2338 current = input.method_71426("targetPos", class_2338.field_25064).orElse(null);
        this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.area, current);
        this.targetPos = current;
        this.storage = input.method_71426("storage", MachineStorage.CODEC.codec()).orElseGet(MachineStorage::of);
        this.skipped = input.method_71426("skipped", (Codec)Codec.LONG_STREAM).orElse(LongStream.empty()).mapToObj(class_2338::method_10092).collect(Collectors.toCollection(HashSet::new));
        this.moduleInventory.method_7659(input.method_71437("moduleInventory", class_1799.field_24671));
        this.chunkLoader = input.method_71426("chunkLoader", QuarryChunkLoader.CODEC).orElse(QuarryChunkLoader.None.INSTANCE);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71468("head", class_243.field_38277, (Object)this.head);
        output.method_71469("state", this.currentState.name());
        if (this.area != null) {
            output.method_71468("area", Area.CODEC.codec(), (Object)this.area);
        }
        output.method_71468("digMinY", DigMinY.CODEC.codec(), (Object)this.digMinY);
        return output;
    }

    @Override
    public void fromClientTag(class_11368 input) {
        input.method_71426("head", class_243.field_38277).ifPresent(v -> {
            this.targetHead = v;
        });
        this.currentState = input.method_71441("state").map(QuarryState::valueOf).orElse(QuarryState.FINISHED);
        this.area = input.method_71426("area", Area.CODEC.codec()).orElse(null);
        this.digMinY = input.method_71426("digMinY", DigMinY.CODEC.codec()).orElseGet(DigMinY::new);
    }

    public void method_5431() {
        super.method_5431();
        this.updateModules();
    }

    public void method_11012() {
        super.method_11012();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 s = (class_3218)class_19372;
            this.chunkLoader.makeChunkUnLoaded(s);
        }
    }

    public void method_66473(class_2338 pos, class_2680 blockState) {
        if (this.field_11863 != null) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.moduleInventory);
        }
    }

    @Override
    public final void updateMaxEnergyWithEnchantment(class_1937 level) {
        int efficiency = this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)level.method_30349());
        this.setMaxEnergy((long)(QuarryEntity.powerMap().maxEnergy() * 1.0E9 * (double)(1 + efficiency)));
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
        if (area != null) {
            this.head = new class_243((double)area.maxX(), (double)area.minY(), (double)area.maxZ());
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    void setState(QuarryState state, class_2680 blockState) {
        if (this.field_11863 != null && this.currentState != state) {
            if (!this.field_11863.method_8608()) {
                if (!QuarryState.isWorking(this.currentState) && QuarryState.isWorking(state)) {
                    this.chunkLoader = QuarryChunkLoader.of((class_3218)this.field_11863, this.method_11016());
                    this.chunkLoader.makeChunkLoaded((class_3218)this.field_11863);
                } else if (QuarryState.isWorking(this.currentState) && !QuarryState.isWorking(state)) {
                    this.chunkLoader.makeChunkUnLoaded((class_3218)this.field_11863);
                    this.chunkLoader = QuarryChunkLoader.None.INSTANCE;
                }
            }
            this.currentState = state;
            this.syncToClient();
            this.field_11863.method_8652(this.method_11016(), (class_2680)blockState.method_11657((class_2769)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(QuarryState.isWorking(state))), 3);
            if (state == QuarryState.FINISHED) {
                this.energyCounter.logUsageMap();
            }
        }
    }

    void updateModules() {
        this.modules = this.field_11863 == null ? this.moduleInventory.getModules() : Sets.union(this.moduleInventory.getModules(), QuarryModuleProvider.Block.getModulesInWorld(this.field_11863, this.method_11016()));
        this.itemConverter = QuarryEntity.defaultItemConverter().concat(ConverterModule.findConversions(this.modules));
    }

    public String renderMode() {
        return switch (this.currentState) {
            case QuarryState.WAITING, QuarryState.BREAK_INSIDE_FRAME, QuarryState.MAKE_FRAME -> "frame";
            case QuarryState.MOVE_HEAD, QuarryState.BREAK_BLOCK, QuarryState.REMOVE_FLUID -> "drill";
            default -> "none";
        };
    }

    void waiting() {
        if (this.getEnergy() > this.getMaxEnergy() / 200L && this.area != null) {
            this.setState(QuarryState.BREAK_INSIDE_FRAME, this.method_11010());
        }
    }

    void breakInsideFrame() {
        this.setState(QuarryState.MAKE_FRAME, this.method_11010());
    }

    void makeFrame() {
        long requiredEnergy;
        class_2680 state;
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.getArea(), null);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
        }
        if ((state = this.field_11863.method_8320(this.targetPos)).method_27852((class_2248)PlatformAccess.getAccess().registerObjects().frameBlock().get())) {
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
                this.makeFrame();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(QuarryState.MOVE_HEAD, this.method_11010());
            }
            return;
        }
        if (!this.method_11016().equals((Object)this.targetPos) && !state.method_26215()) {
            WorkResult result = this.breakBlock(this.targetPos);
            if (!result.isSuccess()) {
                return;
            }
            if (result != WorkResult.SUCCESS) {
                this.skipped.add(this.targetPos.method_10062());
            }
        }
        if (this.useEnergy(requiredEnergy = (long)(1.0E9 * QuarryEntity.powerMap().makeFrame()), true, false, "makeFrame") == requiredEnergy) {
            this.useEnergy(requiredEnergy, false, false, "makeFrame");
            if (!this.targetPos.equals((Object)this.method_11016())) {
                this.field_11863.method_8652(this.targetPos, PlatformAccess.getAccess().registerObjects().frameBlock().get().method_9564(), 3);
            }
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(QuarryState.MOVE_HEAD, this.method_11010());
            }
        }
    }

    void moveHead() {
        class_243 diff;
        double difLength;
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.getArea(), null);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.getNextValidTarget();
            this.head = new class_243(((double)this.area.minX() + (double)this.area.maxX()) / 2.0, (double)this.area.maxY(), ((double)this.area.minZ() + (double)this.area.maxZ()) / 2.0);
            if (this.targetPos == null) {
                return;
            }
        }
        if ((difLength = (diff = new class_243((double)this.targetPos.method_10263() - this.head.field_1352, (double)this.targetPos.method_10264() - this.head.field_1351, (double)this.targetPos.method_10260() - this.head.field_1350)).method_1033()) > 1.0E-7) {
            long defaultEnergy = (long)(1.0E9 * QuarryEntity.powerMap().moveHeadBase() * this.moveHeadFactor());
            long availableEnergy = this.useEnergy(defaultEnergy, true, false, "moveHead");
            double moveDistance = Math.min(difLength, (double)availableEnergy / 1.0E9);
            this.useEnergy((long)(moveDistance * 1.0E9), false, true, "moveHead");
            this.head = this.head.method_1019(diff.method_1021(moveDistance / difLength));
            this.syncToClient();
        }
        if (this.targetPos.method_40081(this.head.field_1352, this.head.field_1351, this.head.field_1350) <= 1.0E-7) {
            this.setState(QuarryState.BREAK_BLOCK, this.method_11010());
            this.breakBlock();
        }
    }

    double moveHeadFactor() {
        assert (this.field_11863 != null);
        int efficiency = this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)this.field_11863.method_30349());
        if (efficiency >= 4) {
            return efficiency - 3;
        }
        return Math.pow(4.0, (double)efficiency / 4.0 - 1.0);
    }

    void breakBlock() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.getArea(), null);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            throw new IllegalStateException("How to break block with targetPos is null?");
        }
        class_3610 fluid = this.field_11863.method_8316(this.targetPos);
        if (!fluid.method_15769()) {
            if (this.shouldRemoveFluid()) {
                this.setState(QuarryState.REMOVE_FLUID, this.method_11010());
                this.removeFluid();
                return;
            }
            this.targetPos = this.getNextValidTarget();
            if (this.targetPos == null) {
                return;
            }
            this.setState(QuarryState.MOVE_HEAD, this.method_11010());
            return;
        }
        WorkResult result = this.breakBlock(this.targetPos);
        if (result.isSuccess()) {
            if (result != WorkResult.SUCCESS) {
                this.skipped.add(this.targetPos.method_10062());
            }
            this.targetPos = this.getNextValidTarget();
            if (this.targetPos == null) {
                return;
            }
            this.setState(QuarryState.MOVE_HEAD, this.method_11010());
        }
    }

    private boolean setNextDigTargetIterator() {
        class_2338 fluidPos;
        if (this.targetPos == null) {
            QuarryPlus.LOGGER.error("setNextDigTargetIterator: targetPos is null. Area: {}, Iterator: {}", (Object)this.area, this.targetIterator);
            this.setState(QuarryState.FINISHED, this.method_11010());
            return true;
        }
        assert (this.area != null);
        assert (this.field_11863 != null);
        if (this.shouldRemoveFluid() && (fluidPos = (class_2338)class_2338.method_17962((int)(this.area.minX() + 1), (int)this.targetPos.method_10264(), (int)(this.area.minZ() + 1), (int)(this.area.maxX() - 1), (int)this.targetPos.method_10264(), (int)(this.area.maxZ() - 1)).filter(p -> !this.skipped.contains(p)).filter(p -> !this.field_11863.method_8316(p).method_15769()).findAny().map(class_2338::method_10062).orElse(null)) != null) {
            this.targetIterator = new PickIterator.Single<class_2338>(fluidPos);
            this.setState(QuarryState.REMOVE_FLUID, this.method_11010());
            return false;
        }
        class_2338 blockPos = class_2338.method_17962((int)(this.area.minX() + 1), (int)this.targetPos.method_10264(), (int)(this.area.minZ() + 1), (int)(this.area.maxX() - 1), (int)this.targetPos.method_10264(), (int)(this.area.maxZ() - 1)).filter(p -> !this.skipped.contains(p)).filter(p -> this.canBreak(this.field_11863, (class_2338)p, this.field_11863.method_8320(p))).findAny().map(class_2338::method_10062).orElse(null);
        if (blockPos != null) {
            this.targetIterator = new PickIterator.Single<class_2338>(blockPos);
            this.setState(QuarryState.MOVE_HEAD, this.method_11010());
            return false;
        }
        int minY = this.digMinY.getMinY((class_4538)this.field_11863);
        if (minY < this.targetPos.method_10264()) {
            this.skipped.removeIf(p -> p.method_10264() > this.targetPos.method_10264());
            this.targetIterator = this.area.quarryDigPosIterator(this.targetPos.method_10264() - 1);
            return false;
        }
        this.setState(QuarryState.FINISHED, this.method_11010());
        return true;
    }

    void removeFluid() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null || this.targetPos == null) {
            throw new IllegalStateException("Target is null");
        }
        class_3610 fluidState = this.field_11863.method_8316(this.targetPos);
        if (fluidState.method_15769()) {
            this.setState(QuarryState.BREAK_BLOCK, this.method_11010());
            return;
        }
        Set<class_2338> poses = this.area.getChainBlocks(this.targetPos, p -> !this.field_11863.method_8316(p).method_15769(), this.field_11863.method_31600());
        this.useEnergy((long)(QuarryEntity.powerMap().breakBlockFluid() * (double)poses.size() * 1.0E9), false, true, "removeFluid");
        class_3222 player = this.getQuarryFakePlayer((class_3218)this.field_11863, this.targetPos);
        for (class_2338 fluidPos : poses) {
            this.removeFluidAt(this.field_11863, fluidPos, player, class_2246.field_10124.method_9564());
            for (class_2338 edge : this.area.getEdgeForPos(fluidPos)) {
                if (this.field_11863.method_8316(edge).method_15769()) continue;
                this.useEnergy((long)(QuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
                this.removeFluidAt(this.field_11863, edge, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
            }
        }
        this.setState(QuarryState.BREAK_BLOCK, this.method_11010());
    }

    void filler() {
        this.setState(QuarryState.FINISHED, this.method_11010());
    }

    @Nullable
    static PickIterator<class_2338> createTargetIterator(QuarryState state, @Nullable Area area, @Nullable class_2338 lastReturned) {
        PickIterator<class_2338> itr;
        if (area == null) {
            return null;
        }
        switch (state) {
            case MAKE_FRAME: {
                PickIterator<class_2338> pickIterator = area.quarryFramePosIterator();
                break;
            }
            case MOVE_HEAD: 
            case BREAK_BLOCK: {
                PickIterator<class_2338> pickIterator = area.quarryDigPosIterator(lastReturned != null ? lastReturned.method_10264() : area.minY() - 1);
                break;
            }
            default: {
                PickIterator<class_2338> pickIterator = itr = null;
            }
        }
        if (itr != null && lastReturned != null) {
            itr.setLastReturned(lastReturned);
        }
        return itr;
    }

    @NotNull
    WorkResult breakBlock(class_2338 target) {
        class_2680 state;
        assert (this.field_11863 != null);
        class_3218 serverLevel = (class_3218)this.field_11863;
        if (target.method_10263() % 3 == 0 && target.method_10260() % 3 == 0) {
            serverLevel.method_8390(class_1542.class, new class_238(target).method_1014(5.0), Predicate.not(i -> i.method_6983().method_7960())).forEach(i -> {
                this.itemConverter.convert(i.method_6983()).forEach(this.storage::addItem);
                i.method_5768(serverLevel);
            });
            if (this.shouldCollectExp()) {
                List orbs = serverLevel.method_8390(class_1303.class, new class_238(target).method_1014(5.0), class_1301.field_6154);
                int amount = orbs.stream().mapToInt(class_1303::method_5919).sum();
                if (amount != 0) {
                    this.getExpModule().ifPresent(e -> e.addExp(amount));
                }
                orbs.forEach(e -> e.method_5768(serverLevel));
            }
            if (this.shouldRemoveMinecarts()) {
                List minecarts = serverLevel.method_8390(class_1694.class, new class_238(target).method_1014(5.0), class_1301.field_6154);
                minecarts.stream().flatMap(c -> IntStream.range(0, c.method_5439()).mapToObj(arg_0 -> ((class_1694)c).method_5438(arg_0))).flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                minecarts.forEach(c -> {
                    c.method_5448();
                    c.method_5768(serverLevel);
                });
            }
        }
        if ((state = serverLevel.method_8320(target)).method_26215() || state.equals((Object)this.stateAfterBreak((class_1937)serverLevel, target, state))) {
            return WorkResult.SUCCESS;
        }
        class_5455 lookup = serverLevel.method_30349();
        class_2586 blockEntity = serverLevel.method_8321(target);
        class_3222 player = this.getQuarryFakePlayer(serverLevel, target);
        class_1799 pickaxe = class_1802.field_22024.method_7854();
        class_1890.method_57530((class_1799)pickaxe, (class_9304)this.enchantmentCache.getEnchantmentsForPickaxe(this.getEnchantments(), (class_7871.class_7872)lookup));
        player.method_6122(class_1268.field_5808, pickaxe);
        float hardness = state.method_26214((class_1922)serverLevel, target);
        BlockBreakEventResult eventResult = this.checkBreakEvent((class_1937)serverLevel, player, state, target, blockEntity);
        if (eventResult.canceled()) {
            return WorkResult.FAIL_EVENT;
        }
        WorkResult moduleResult = this.breakBlockModuleOverride(serverLevel, state, target, hardness);
        if (moduleResult != WorkResult.SKIPPED) {
            return moduleResult;
        }
        if (hardness < 0.0f) {
            return WorkResult.SKIPPED;
        }
        long requiredEnergy = QuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9119, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9130, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9099, (class_7871.class_7872)lookup) > 0);
        if (this.useEnergy(requiredEnergy, true, this.getMaxEnergy() < requiredEnergy, "breakBlock") == requiredEnergy) {
            this.useEnergy(requiredEnergy, false, this.getMaxEnergy() < requiredEnergy, "breakBlock");
            try {
                BlockBreakEventResult afterBreakEventResult = this.afterBreak((class_1937)serverLevel, player, state, target, blockEntity, class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)target, (class_2586)blockEntity, (class_1297)player, (class_1799)pickaxe), pickaxe, this.stateAfterBreak((class_1937)serverLevel, target, state));
                if (!afterBreakEventResult.canceled()) {
                    afterBreakEventResult.drops().stream().flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                    int amount = eventResult.exp().orElse(afterBreakEventResult.exp().orElse(0));
                    if (amount != 0) {
                        this.getExpModule().ifPresent(e -> e.addExp(amount));
                    }
                }
            }
            catch (Exception e2) {
                QuarryPlus.LOGGER.warn(MARKER, "Error occurred while processing block {} at ({})", new Object[]{state.method_26204(), target.method_23854(), e2});
            }
            if (this.shouldRemoveFluid()) {
                assert (this.area != null);
                for (class_2338 edge : this.area.getEdgeForPos(target)) {
                    if (this.field_11863.method_8316(edge).method_15769()) continue;
                    this.useEnergy((long)(QuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
                    this.removeFluidAt(this.field_11863, edge, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
                }
            }
            return WorkResult.SUCCESS;
        }
        return WorkResult.NOT_ENOUGH_ENERGY;
    }

    protected final BlockBreakEventResult checkBreakEvent(class_1937 level, class_3222 fakePlayer, class_2680 state, class_2338 target, @Nullable class_2586 blockEntity) {
        return PlatformAccess.getAccess().mining().checkBreakEvent(this, level, fakePlayer, state, target, blockEntity);
    }

    protected final BlockBreakEventResult afterBreak(class_1937 level, class_3222 fakePlayer, class_2680 state, class_2338 target, @Nullable class_2586 blockEntity, List<class_1799> drops, class_1799 pickaxe, class_2680 newState) {
        return PlatformAccess.getAccess().mining().afterBreak(this, level, fakePlayer, state, target, blockEntity, drops, pickaxe, newState);
    }

    WorkResult breakBlockModuleOverride(class_3218 level, class_2680 state, class_2338 target, float hardness) {
        if (hardness < 0.0f && state.method_27852(class_2246.field_9987) && this.shouldRemoveBedrock()) {
            int worldBottom = level.method_31607();
            int targetY = target.method_10264();
            if (level.method_27983().equals(class_1937.field_25180)) {
                int top;
                int n = top = PlatformAccess.config().removeBedrockOnNetherTop() ? level.method_31600() + 1 : 127;
                if (!(worldBottom < targetY && targetY < worldBottom + 5 || 122 < targetY && targetY < top)) {
                    return WorkResult.SKIPPED;
                }
            } else if (worldBottom >= targetY || targetY >= worldBottom + 5) {
                return WorkResult.SKIPPED;
            }
            class_5455 lookup = level.method_30349();
            long requiredEnergy = QuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)lookup), 0, 0, true);
            this.useEnergy(requiredEnergy, false, true, "breakBlock");
            level.method_8652(target, this.stateAfterBreak((class_1937)level, target, state), 3);
            return WorkResult.SUCCESS;
        }
        return WorkResult.SKIPPED;
    }

    protected final class_3222 getQuarryFakePlayer(class_3218 level, class_2338 target) {
        return PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, level, target);
    }

    protected boolean shouldRemoveFluid() {
        return this.modules.contains(QuarryModule.Constant.PUMP);
    }

    protected class_2680 stateAfterBreak(class_1937 level, class_2338 pos, class_2680 before) {
        return class_2246.field_10124.method_9564();
    }

    protected boolean shouldRemoveBedrock() {
        return this.modules.contains(QuarryModule.Constant.BEDROCK);
    }

    protected boolean shouldCollectExp() {
        return this.modules.stream().anyMatch(ExpModule.class::isInstance);
    }

    @NotNull
    protected Optional<ExpModule> getExpModule() {
        return ExpModule.getModule(this.modules);
    }

    protected int repeatCount() {
        RepeatTickModuleItem.RepeatTickModule repeatTickModule = RepeatTickModuleItem.getModule(this.modules).orElse(RepeatTickModuleItem.ZERO);
        return repeatTickModule.stackSize() + 1;
    }

    protected boolean shouldRemoveMinecarts() {
        return PlatformAccess.config().removeMinecartWithChest();
    }

    void removeFluidAt(@NotNull class_1937 level, class_2338 pos, class_3222 player, class_2680 newState) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof class_2404) {
            class_3610 f = level.method_8316(pos);
            if (!f.method_15769() && f.method_15771()) {
                this.storage.addFluid(f.method_15772(), 81000L);
            }
            level.method_8652(pos, newState, 2);
        } else {
            class_2248 f = state.method_26204();
            if (f instanceof class_2263) {
                class_2263 bucketPickup = (class_2263)f;
                class_1799 picked = bucketPickup.method_9700((class_1309)player, (class_1936)level, pos, state);
                this.storage.addBucketFluid(picked);
            } else {
                level.method_8652(pos, newState, 2);
            }
        }
    }

    @Nullable
    class_2338 getNextValidTarget() {
        assert (this.targetIterator != null);
        assert (this.field_11863 != null);
        assert (this.area != null);
        int recursiveCount = 0;
        while (recursiveCount++ < 350) {
            while (this.targetIterator.hasNext()) {
                class_2680 state;
                class_2338 pos = this.targetIterator.next();
                if (!this.canBreak(this.field_11863, pos, state = this.field_11863.method_8320(pos))) continue;
                return pos;
            }
            this.targetPos = this.targetIterator.getLastReturned();
            if (!this.setNextDigTargetIterator()) continue;
            return null;
        }
        QuarryPlus.LOGGER.error("Quarry at {} can't find next target. Itr: {}, Pos: {}", new Object[]{this.method_11016().method_23854(), this.targetIterator, this.targetPos});
        return this.targetIterator.getLastReturned();
    }

    boolean canBreak(class_1937 level, class_2338 pos, class_2680 state) {
        class_3610 fluid = level.method_8316(pos);
        if (fluid.method_15769()) {
            return !state.method_26215() && !state.equals((Object)this.stateAfterBreak(level, pos, state));
        }
        return this.shouldRemoveFluid();
    }

    @Nullable
    public class_238 getRenderAabb() {
        Area area = this.getArea();
        if (area == null) {
            return null;
        }
        int minY = this.method_10997() == null ? 0 : this.method_10997().method_31607();
        String string = this.renderMode();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"drill"}, (Object)string, n)) {
            case 0 -> new class_238((double)area.minX(), (double)minY, (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
            default -> null;
        };
    }

    @VisibleForTesting
    @NotNull
    public class_9304 getEnchantments() {
        return (class_9304)this.method_58693().method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
    }

    @VisibleForTesting
    public void setEnchantments(@NotNull class_9304 enchantments) {
        this.method_58684(class_9323.method_57827().method_57839(this.method_58693()).method_57840(class_9334.field_49633, (Object)enchantments).method_57838());
    }

    static ItemConverter defaultItemConverter() {
        return ItemConverter.defaultInstance();
    }
}

