/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.CombinedBlockEntityTicker;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockItem;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.machine.quarry.QuarryEntity;
import com.yogpc.qp.machine.quarry.QuarryItem;
import com.yogpc.qp.machine.quarry.QuarryState;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class QuarryBlock
extends QpEntityBlock {
    public static final String NAME = "quarry";

    protected QuarryBlock(Function<QpBlock, ? extends QuarryItem> itemGenerator) {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_50012(class_3619.field_15972).method_9629(1.5f, 10.0f).method_9626(class_2498.field_11544), NAME, (Function<? super QpBlock, ? extends QpBlockItem>)itemGenerator);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{QpBlockProperty.WORKING, class_2741.field_12525});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8036() == null ? class_2350.field_11043 : ctx.method_8036().method_5735().method_10153();
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)facing);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        if (level.method_8608()) {
            return QuarryBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, QuarryEntity::clientTick));
        }
        return QuarryBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, PowerEntity.logTicker(), QuarryEntity::serverTick, MachineStorage.pushItemTicker(), MachineStorage.pushFluidTicker()));
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        QuarryEntity entity = this.getBlockEntityType().map(t -> (QuarryEntity)t.method_24182((class_1922)level, pos)).orElse(null);
        if (entity != null) {
            if (!level.method_8608()) {
                if (entity.enabled) {
                    this.openGui((class_3222)player, level, pos, entity);
                } else {
                    player.method_7353((class_2561)class_2561.method_43469((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.method_9518()}), true);
                }
            }
            return class_1269.field_52422;
        }
        return super.method_55766(state, level, pos, player, hitResult);
    }

    protected abstract void openGui(class_3222 var1, class_1937 var2, class_2338 var3, QuarryEntity var4);

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862;
        super.method_9567(level, pos, state, placer, stack);
        if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof QuarryEntity) {
            QuarryEntity quarry = (QuarryEntity)class_25862;
            quarry.updateMaxEnergyWithEnchantment(level);
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            QuarryMarker.Link markerLink = Stream.of(facing.method_10153(), facing.method_10160(), facing.method_10170()).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1937)level).method_8321(arg_0)).filter(QuarryMarker.class::isInstance).map(QuarryMarker.class::cast).flatMap(m -> m.getLink().stream()).findAny().orElseGet(() -> {
                class_2338 base = pos.method_10093(facing.method_10153());
                class_2338 corner1 = base.method_10079(facing.method_10170(), 5).method_10086(4);
                class_2338 corner2 = base.method_10079(facing.method_10160(), 5).method_10079(facing.method_10153(), 10);
                Area area = new Area((class_2382)corner1, (class_2382)corner2, facing.method_10153());
                return new QuarryMarker.StaticLink(area);
            });
            Area area = Area.assumeY(markerLink.area());
            if (!area.quarryDigPosIterator(pos.method_10264()).hasNext()) {
                QuarryPlus.LOGGER.warn(QuarryEntity.MARKER, "The area for quarry({}) doesn't have enough space for work. Area: {}", (Object)pos.method_23854(), (Object)area);
                if (placer instanceof class_1657) {
                    class_1657 p = (class_1657)placer;
                    String text = "This Quarry doesn't have enough space for work";
                    p.method_7353((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1061), false);
                }
                return;
            }
            quarry.setArea(area);
            markerLink.drops().forEach(quarry.storage::addItem);
            markerLink.remove(level);
            quarry.setState(QuarryState.WAITING, state);
        }
    }

    protected void method_66388(class_2680 state, class_3218 level, class_2338 pos, boolean isMoving) {
        super.method_66388(state, level, pos, isMoving);
        if (level.method_8321(pos) instanceof QuarryEntity) {
            level.method_8455(pos, state.method_26204());
        }
    }

    @Override
    public void appendHoverText(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        class_11580 tag = (class_11580)stack.method_58694(class_9334.field_49611);
        if (tag != null && tag.method_72536("storage")) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"DON'T PLACE THIS INTO WORLD.").method_27692(class_124.field_1061));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"This block might cause crash.").method_27692(class_124.field_1061));
        }
    }

    @Override
    public Stream<class_1799> creativeTabItem(class_1761.class_8128 parameters) {
        Stream.Builder<class_1799> builder = Stream.builder();
        class_1799 stack = new class_1799((class_1935)this);
        builder.add(stack);
        class_7225.class_7226 lookup = parameters.comp_1253().method_46762(class_7924.field_41265);
        class_6880.class_6883 efficiency = lookup.method_46747(class_1893.field_9131);
        class_6880.class_6883 unbreaking = lookup.method_46747(class_1893.field_9119);
        class_6880.class_6883 fortune = lookup.method_46747(class_1893.field_9130);
        class_6880.class_6883 silkTouch = lookup.method_46747(class_1893.field_9099);
        class_1799 e = stack.method_7972();
        e.method_7978((class_6880)efficiency, 5);
        builder.add(e);
        e = stack.method_7972();
        e.method_7978((class_6880)efficiency, 5);
        e.method_7978((class_6880)unbreaking, 3);
        e.method_7978((class_6880)fortune, 3);
        builder.add(e);
        e = stack.method_7972();
        e.method_7978((class_6880)efficiency, 5);
        e.method_7978((class_6880)unbreaking, 3);
        e.method_7978((class_6880)silkTouch, 1);
        builder.add(e);
        return builder.build();
    }

    @Override
    protected boolean shouldCloneItemHasData() {
        return true;
    }
}

