/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.packet.ClientSync;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlacerTile
extends QpEntity
implements ClientSync,
class_1263 {
    public static final Map<class_2350, class_243> DIRECTION_VEC3D_MAP;
    private final class_1277 container = new PlacerContainer(this, this.method_5439());
    private int lastPlacedIndex = 0;
    @NotNull
    public RedStoneMode redstoneMode = RedStoneMode.PULSE;

    protected AbstractPlacerTile(class_2338 pos, class_2680 blockState) {
        super(pos, blockState);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.toClientTag(output);
        this.container.method_7660(output.method_71467("container", class_1799.field_24671));
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.fromClientTag(input);
        this.container.method_7659(input.method_71437("container", class_1799.field_24671));
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.lastPlacedIndex = input.method_71424("lastPlacedIndex", 0);
        this.redstoneMode = input.method_71441("mode").map(RedStoneMode::valueOf).orElse(RedStoneMode.PULSE);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71465("lastPlacedIndex", this.lastPlacedIndex);
        output.method_71469("mode", this.redstoneMode.name());
        return output;
    }

    protected abstract class_2338 getTargetPos();

    protected abstract class_2350 getMachineFacing();

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(AbstractPlacerTile.detail(class_124.field_1060, "redstoneMode", this.redstoneMode.toString()), AbstractPlacerTile.detail(class_124.field_1060, "Target", this.getTargetPos().method_23854()), AbstractPlacerTile.detail(class_124.field_1060, "Facing", String.valueOf(this.getMachineFacing())), AbstractPlacerTile.detail(class_124.field_1060, "isPowered", String.valueOf(this.isPowered())), AbstractPlacerTile.detail(class_124.field_1060, "lastPlacedIndex in inv", String.valueOf(this.getLastPlacedIndex()))));
    }

    protected boolean isPowered() {
        assert (this.field_11863 != null);
        return Arrays.stream(class_2350.values()).filter(Predicate.isEqual(this.getMachineFacing()).negate()).anyMatch(f -> this.field_11863.method_49807(this.method_11016().method_10093(f), f)) || this.field_11863.method_49803(this.method_11016().method_10084());
    }

    void breakBlock() {
        if (this.field_11863 == null || !this.redstoneMode.canBreak()) {
            return;
        }
        class_2338 pos = this.getTargetPos();
        if (pos.equals((Object)this.method_11016())) {
            return;
        }
        class_2680 state = this.field_11863.method_8320(pos);
        if (state.method_26214((class_1922)this.field_11863, pos) < 0.0f) {
            return;
        }
        class_3222 fake = PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, (class_3218)this.field_11863, pos);
        class_1799 pickaxe = this.getSilkPickaxe();
        fake.method_6122(class_1268.field_5808, pickaxe);
        List drops = class_2248.method_9609((class_2680)state, (class_3218)((class_3218)this.field_11863), (class_2338)pos, (class_2586)this.field_11863.method_8321(pos), (class_1297)fake, (class_1799)pickaxe);
        this.field_11863.method_8650(pos, false);
        drops.stream().map(arg_0 -> ((class_1277)this.container).method_5491(arg_0)).filter(Predicate.not(class_1799::method_7960)).forEach(s -> class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_1799)s));
    }

    boolean placeBlock() {
        if (this.method_5442() || !this.redstoneMode.canPlace()) {
            return false;
        }
        class_2350 facing = this.getMachineFacing();
        class_2338 pos = this.getTargetPos();
        if (pos.equals((Object)this.method_11016())) {
            return false;
        }
        class_243 hitPos = DIRECTION_VEC3D_MAP.get(facing.method_10153()).method_1031((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        class_3965 rayTrace = new class_3965(hitPos, facing.method_10153(), pos, false);
        class_3222 fake = PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, (class_3218)this.field_11863, pos);
        AtomicBoolean result = new AtomicBoolean(false);
        AbstractPlacerTile.findEntry(this.container.method_54454(), arg_0 -> AbstractPlacerTile.lambda$placeBlock$2((class_1657)fake, rayTrace, arg_0), this.lastPlacedIndex).ifPresent(i -> {
            this.lastPlacedIndex = !this.method_5438(i).method_7960() ? i : AbstractPlacerTile.findEntry(this.container.method_54454(), s -> !s.method_7960() && s.method_7909() instanceof class_1747, i).orElse(0);
            this.method_5431();
            this.syncToClient();
            result.set(true);
        });
        fake.method_6122(class_1268.field_5808, class_1799.field_8037);
        return result.get();
    }

    public static <T> OptionalInt findEntry(List<T> check, Predicate<T> filter, int startIndex) {
        int listSize = check.size();
        if (startIndex >= listSize) {
            return OptionalInt.empty();
        }
        return AbstractPlacerTile.findEntryInternal(check, filter, startIndex, startIndex, listSize);
    }

    private static <T> OptionalInt findEntryInternal(List<T> check, Predicate<T> filter, int startIndex, int index, int listSize) {
        T value = check.get(index);
        if (filter.test(value)) {
            return OptionalInt.of(index);
        }
        if (index == startIndex - 1 || startIndex == 0 && index == listSize - 1) {
            return OptionalInt.empty();
        }
        int next = index + 1 == listSize ? 0 : index + 1;
        return AbstractPlacerTile.findEntryInternal(check, filter, startIndex, next, listSize);
    }

    static boolean tryPlaceItem(class_1799 stack, class_1657 fake, class_3965 rayTrace) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            fake.method_6122(class_1268.field_5808, stack);
            class_1750 context = new class_1750(new class_1838(fake, class_1268.field_5808, rayTrace));
            return blockItem.method_7712(context).method_23665();
        }
        return false;
    }

    public int getLastPlacedIndex() {
        return this.lastPlacedIndex;
    }

    protected class_1799 getSilkPickaxe() {
        assert (this.field_11863 != null);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8377);
        stack.method_7978((class_6880)this.field_11863.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9099), 1);
        return stack;
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        return this.container.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.container.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.container.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.container.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.container.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.method_11016().method_19769((class_2374)player.method_73189(), 8.0);
    }

    public void method_5448() {
        this.container.method_5448();
    }

    public void cycleRedStoneMode() {
        this.redstoneMode = RedStoneMode.cycle(this.redstoneMode);
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.syncToClient();
        }
    }

    private static /* synthetic */ boolean lambda$placeBlock$2(class_1657 fake, class_3965 rayTrace, class_1799 i) {
        return AbstractPlacerTile.tryPlaceItem(i, fake, rayTrace);
    }

    static {
        EnumMap<class_2350, class_243> map = new EnumMap<class_2350, class_243>(class_2350.class);
        map.put(class_2350.field_11033, new class_243(0.5, 0.0, 0.5));
        map.put(class_2350.field_11036, new class_243(0.5, 1.0, 0.5));
        map.put(class_2350.field_11043, new class_243(0.5, 0.5, 0.0));
        map.put(class_2350.field_11035, new class_243(0.5, 0.5, 1.0));
        map.put(class_2350.field_11034, new class_243(1.0, 0.5, 0.5));
        map.put(class_2350.field_11039, new class_243(0.0, 0.5, 0.5));
        DIRECTION_VEC3D_MAP = Collections.unmodifiableMap(map);
    }

    private static final class PlacerContainer
    extends class_1277 {
        private final QpEntity parent;

        public PlacerContainer(QpEntity parent, int size) {
            super(size);
            this.parent = parent;
        }

        public void method_5431() {
            super.method_5431();
            this.parent.method_5431();
        }
    }

    public static enum RedStoneMode {
        PULSE(true, true),
        PULSE_PLACE_ONLY(true, false),
        PULSE_BREAK_ONLY(false, true);

        private final boolean placeEnabled;
        private final boolean breakEnabled;

        private RedStoneMode(boolean placeEnabled, boolean breakEnabled) {
            this.placeEnabled = placeEnabled;
            this.breakEnabled = breakEnabled;
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }

        public boolean canPlace() {
            return this.placeEnabled;
        }

        public boolean canBreak() {
            return this.breakEnabled;
        }

        public static RedStoneMode cycle(RedStoneMode now) {
            RedStoneMode[] modes = RedStoneMode.values();
            for (int i = 0; i < modes.length; ++i) {
                RedStoneMode mode = modes[i];
                if (mode != now) continue;
                if (i + 1 == modes.length) {
                    return modes[0];
                }
                return modes[i + 1];
            }
            return modes[0];
        }
    }
}

