/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.mover;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.packet.ClientSync;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9886;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MoverEntity
extends QpEntity
implements ClientSync {
    final class_1277 inventory = new Inventory(2);
    List<class_6880<class_1887>> movableEnchantments = List.of();

    public MoverEntity(class_2338 pos, class_2680 blockState) {
        super(PlatformAccess.getAccess().registerObjects().getBlockEntityType((QpBlock)blockState.method_26204()).orElseThrow(), pos, blockState);
        this.inventory.method_5489(container -> this.method_5431());
    }

    protected void method_11014(class_11368 input) {
        this.inventory.method_7659(input.method_71437("inventory", class_1799.field_24671));
        super.method_11014(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.inventory.method_7660(output.method_71467("inventory", class_1799.field_24671));
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.movableEnchantments = input.method_71437("enchantments", class_1887.field_51644).method_71456().toList();
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        class_11372.class_11373 enchantmentList = output.method_71467("enchantments", class_1887.field_51644);
        this.movableEnchantments.forEach(arg_0 -> ((class_11372.class_11373)enchantmentList).method_71484(arg_0));
        return output;
    }

    public void method_66473(class_2338 pos, class_2680 blockState) {
        if (this.field_11863 != null) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.inventory);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.updateMovableEnchantments();
    }

    void updateMovableEnchantments() {
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.enabled) {
            List<class_6880<class_1887>> pre = this.movableEnchantments;
            this.movableEnchantments = MoverEntity.getMovable(this.inventory.method_5438(0), this.inventory.method_5438(1), e -> true);
            if (!pre.equals(this.movableEnchantments)) {
                this.syncToClient();
            }
        }
    }

    @VisibleForTesting
    static List<class_6880<class_1887>> getMovable(class_1799 from, class_1799 to, Predicate<class_6880<class_1887>> predicate) {
        if (from.method_7960() || to.method_7960()) {
            return List.of();
        }
        class_9304 given = class_1890.method_57532((class_1799)to);
        return class_1890.method_57532((class_1799)from).method_57534().stream().filter(e -> MoverEntity.canMoveEnchantment(predicate, given, (class_6880<class_1887>)e)).sorted(Comparator.comparing(class_6880::method_55840)).toList();
    }

    @VisibleForTesting
    static boolean canMoveEnchantment(@Nullable Predicate<class_6880<class_1887>> predicate, class_9304 given, class_6880<class_1887> toMove) {
        return (predicate == null || predicate.test(toMove)) && given.method_57536(toMove) < ((class_1887)toMove.comp_349()).method_8183() && given.method_57534().stream().filter(Predicate.isEqual(toMove).negate()).allMatch(e -> class_1887.method_60033((class_6880)e, (class_6880)toMove));
    }

    void moveEnchant(class_6880<class_1887> enchantment) {
        Pair<class_1799, class_1799> moved = MoverEntity.moveEnchantment(enchantment, this.inventory.method_5438(0), this.inventory.method_5438(1), this::updateMovableEnchantments);
        this.inventory.method_5447(0, (class_1799)moved.getLeft());
        this.inventory.method_5447(1, (class_1799)moved.getRight());
    }

    static Pair<class_1799, class_1799> moveEnchantment(@Nullable class_6880<class_1887> enchantment, class_1799 from, class_1799 to, Runnable after) {
        return MoverEntity.moveEnchantment(enchantment, from, to, null, after);
    }

    @VisibleForTesting
    static Pair<class_1799, class_1799> moveEnchantment(@Nullable class_6880<class_1887> enchantment, class_1799 from, class_1799 to, @Nullable Predicate<class_6880<class_1887>> predicate, Runnable after) {
        if (enchantment == null || from.method_7960() || to.method_7960()) {
            return Pair.of((Object)from, (Object)to);
        }
        if (MoverEntity.canMoveEnchantment(predicate, class_1890.method_57532((class_1799)to), enchantment)) {
            class_1799 right = MoverEntity.upLevel(enchantment, to);
            class_1799 left = MoverEntity.downLevel(enchantment, from);
            after.run();
            return Pair.of((Object)left, (Object)right);
        }
        return Pair.of((Object)from, (Object)to);
    }

    @VisibleForTesting
    static class_1799 downLevel(class_6880<class_1887> enchantment, class_1799 stack) {
        class_1890.method_57531((class_1799)stack, mutable -> mutable.method_57547(enchantment, mutable.method_57546(enchantment) - 1));
        if (stack.method_31574(class_1802.field_8598) && class_1890.method_57532((class_1799)stack).method_57543()) {
            return class_1799.field_8037;
        }
        return stack;
    }

    @VisibleForTesting
    static class_1799 upLevel(class_6880<class_1887> enchantment, class_1799 stack) {
        class_1890.method_57531((class_1799)stack, mutable -> mutable.method_57547(enchantment, mutable.method_57546(enchantment) + 1));
        return stack;
    }

    private static class Inventory
    extends class_1277 {
        public Inventory(int size) {
            super(size);
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.method_31574(class_1802.field_8598)) {
                        yield true;
                    }
                    if (!stack.method_7942()) {
                        yield false;
                    }
                    if (stack.method_7909() instanceof class_1753) {
                        yield true;
                    }
                    if (stack.method_57826(class_9334.field_50077) && stack.method_7936() >= class_9886.field_52588.comp_2931()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (stack.method_31574((class_1792)PlatformAccess.getAccess().registerObjects().quarryBlock().get().blockItem) || stack.method_31574((class_1792)PlatformAccess.getAccess().registerObjects().advQuarryBlock().get().blockItem)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public int method_5444() {
            return 1;
        }
    }
}

