/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.module;

import com.yogpc.qp.machine.QpItem;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.VisibleForTesting;

public final class ModuleInventory
extends class_1277 {
    static final Set<class_2960> allowMultiModule = Set.of(class_2960.method_60655((String)"quarryplus", (String)"void_module"));
    private final Predicate<QuarryModule> staticFilter;
    private final Function<ModuleInventory, Set<QuarryModule>> holdings;
    private final Runnable onChanged;

    public ModuleInventory(int size, Predicate<QuarryModule> staticFilter, Function<ModuleInventory, Set<QuarryModule>> holdings, Runnable onChanged) {
        super(size);
        this.staticFilter = staticFilter;
        this.holdings = holdings;
        this.onChanged = onChanged;
    }

    @VisibleForTesting
    ModuleInventory(int size) {
        this(size, q -> true, m -> Set.copyOf(m.getModules()), () -> {});
    }

    public boolean method_5437(int index, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof QuarryModuleProvider.Item) {
            QuarryModuleProvider.Item provider = (QuarryModuleProvider.Item)class_17922;
            if (class_1799.method_7984((class_1799)this.method_5438(index), (class_1799)stack)) {
                return true;
            }
            QuarryModule toAdd = provider.getModule(stack);
            if (!this.staticFilter.test(toAdd)) {
                return false;
            }
            return this.holdings.apply(this).stream().map(QuarryModule::moduleId).filter(Predicate.not(allowMultiModule::contains)).filter(Predicate.isEqual(toAdd.moduleId())).findAny().isEmpty();
        }
        return false;
    }

    public void method_5431() {
        super.method_5431();
        this.onChanged.run();
    }

    public Set<QuarryModule> getModules() {
        return ModuleInventory.getModules(this.method_54454().stream());
    }

    @VisibleForTesting
    static Set<QuarryModule> getModules(Stream<class_1799> stream) {
        return stream.filter(s -> s.method_7909() instanceof QuarryModuleProvider.Item).mapMulti(ModuleInventory::itemValidation).map(s -> ((QuarryModuleProvider.Item)s.method_7909()).getModule((class_1799)s)).collect(Collectors.toUnmodifiableSet());
    }

    static void itemValidation(class_1799 stack, Consumer<class_1799> consumer) {
        QpItem item;
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof QpItem) || (item = (QpItem)class_17922).isEnabled()) {
            consumer.accept(stack);
        }
    }
}

