/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.misc;

import com.mojang.serialization.MapCodec;
import com.yogpc.qp.InCreativeTabs;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.misc.Direction26;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.minecraft.class_3738;
import net.minecraft.class_4970;
import net.minecraft.class_8923;
import net.minecraft.server.MinecraftServer;

public final class SoftBlock
extends class_8923
implements InCreativeTabs {
    public static final String NAME = "soft_block";
    private static final int CHAIN_MAX = 16383;
    public final class_2960 location = class_2960.method_60655((String)"quarryplus", (String)"soft_block");
    public final class_1747 blockItem = new class_1747((class_2248)this, new class_1792.class_1793().method_63686(QuarryPlus.itemKey("soft_block")).method_63685());
    private static final MapCodec<SoftBlock> CODEC = SoftBlock.method_54094(p -> new SoftBlock());
    private boolean breaking = false;

    public SoftBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16008).method_22488().method_42327().method_26235((state, world, pos, type) -> false).method_26243((state, world, pos) -> false).method_26236((state, world, pos) -> false).method_26245((state, world, pos) -> false).method_63500(QuarryPlus.blockKey(NAME)));
    }

    protected MapCodec<SoftBlock> method_53969() {
        return CODEC;
    }

    protected void method_66388(class_2680 state, class_3218 level, class_2338 pos, boolean isMoving) {
        super.method_66388(state, level, pos, isMoving);
        if (!this.breaking) {
            this.breaking = true;
            this.breakChain((class_1937)level, pos);
            this.breaking = false;
        }
    }

    private void breakChain(class_1937 world, class_2338 first) {
        if (!world.method_8608()) {
            ArrayList<class_2338> nextCheck = new ArrayList<class_2338>();
            for (Direction26 dir : Direction26.DIRECTIONS) {
                class_2338 nPos = first.method_10081(dir.vec());
                class_2680 nBlock = world.method_8320(nPos);
                if (nBlock.method_26204() != this) continue;
                nextCheck.add(nPos);
            }
            if (!nextCheck.isEmpty()) {
                MinecraftServer server = Objects.requireNonNull(world.method_8503());
                int tickOffset = world.method_8409().method_39332(8, 30);
                server.method_63588((Runnable)new class_3738(server.method_3780() + tickOffset, (Runnable)new ChainBreakTask(world, nextCheck, 1, b -> {
                    this.breaking = b;
                }, new HashSet<class_2338>(), Predicate.isEqual(this))));
            }
        }
    }

    private record ChainBreakTask(class_1937 level, Collection<class_2338> targets, int totalRemoved, BooleanConsumer consumer, HashSet<class_2338> checked, Predicate<class_2248> continueChain) implements Runnable
    {
        @Override
        public void run() {
            HashSet<class_2338> removed = new HashSet<class_2338>();
            ArrayList<class_2338> nextCheck = new ArrayList<class_2338>(this.targets);
            while (!nextCheck.isEmpty() && removed.size() < 16383) {
                class_2338[] copied = nextCheck.toArray(new class_2338[0]);
                nextCheck.clear();
                for (class_2338 pos : copied) {
                    class_2680 nBlock;
                    for (Direction26 dir : Direction26.DIRECTIONS) {
                        class_2680 nBlock2;
                        class_2338 nPos = pos.method_10081(dir.vec());
                        if (!this.checked.add(nPos) || !this.continueChain.test((nBlock2 = this.level.method_8320(nPos)).method_26204()) || !removed.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                    if (!this.checked.add(pos) || !this.continueChain.test((nBlock = this.level.method_8320(pos)).method_26204())) continue;
                    removed.add(pos);
                }
            }
            this.consumer.accept(true);
            removed.forEach(p -> this.level.method_8650(p, false));
            this.consumer.accept(false);
            if (!nextCheck.isEmpty()) {
                MinecraftServer server = Objects.requireNonNull(this.level.method_8503());
                int tickOffset = this.level.method_8409().method_39332(8, 30);
                server.method_63588((Runnable)new class_3738(server.method_3780() + tickOffset, (Runnable)new ChainBreakTask(this.level, nextCheck, this.totalRemoved + removed.size(), this.consumer, this.checked, this.continueChain)));
            }
        }
    }
}

