/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public sealed interface QuarryChunkLoader {
    public static final Marker MARKER = MarkerFactory.getMarker((String)QuarryChunkLoader.class.getSimpleName());
    public static final Codec<QuarryChunkLoader> CODEC = Codec.STRING.dispatch(QuarryChunkLoader::type, QuarryChunkLoader::codec);

    public static boolean isChunkLoaded(class_3218 level, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        boolean result = level.method_17984().contains(chunkPos.method_8324());
        QuarryPlus.LOGGER.info(MARKER, "Check state of chunk loading x={}, z={}, loaded={}", new Object[]{chunkPos.field_9181, chunkPos.field_9180, result});
        return result;
    }

    public static QuarryChunkLoader of(class_3218 level, class_2338 pos) {
        if (!PlatformAccess.config().enableChunkLoader()) {
            return None.INSTANCE;
        }
        if (QuarryChunkLoader.isChunkLoaded(level, pos)) {
            return None.INSTANCE;
        }
        return new Load(pos);
    }

    public void makeChunkLoaded(class_3218 var1);

    public void makeChunkUnLoaded(class_3218 var1);

    public String type();

    public static MapCodec<? extends QuarryChunkLoader> codec(String type) {
        String string = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"None", "Load"}, (Object)string, n)) {
            case 0 -> None.CODEC;
            case 1 -> Load.CODEC;
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }

    public static enum None implements QuarryChunkLoader
    {
        INSTANCE;

        private static final MapCodec<None> CODEC;

        @Override
        public void makeChunkLoaded(class_3218 level) {
        }

        @Override
        public void makeChunkUnLoaded(class_3218 level) {
        }

        @Override
        public String type() {
            return this.getDeclaringClass().getSimpleName();
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record Load(class_2338 pos) implements QuarryChunkLoader
    {
        private static final MapCodec<Load> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.of(Load::pos, (String)"pos", (Codec)class_2338.field_25064)).apply((Applicative)instance, Load::new));

        @Override
        public void makeChunkLoaded(class_3218 level) {
            class_1923 chunkPos = new class_1923(this.pos);
            level.method_17988(chunkPos.field_9181, chunkPos.field_9180, true);
            QuarryPlus.LOGGER.info(MARKER, "Force chunk load at x={}, z={}", (Object)chunkPos.field_9181, (Object)chunkPos.field_9180);
        }

        @Override
        public void makeChunkUnLoaded(class_3218 level) {
            class_1923 chunkPos = new class_1923(this.pos);
            level.method_17988(chunkPos.field_9181, chunkPos.field_9180, false);
            QuarryPlus.LOGGER.info(MARKER, "Remove chunk loading at x={}, z={}", (Object)chunkPos.field_9181, (Object)chunkPos.field_9180);
        }

        @Override
        public String type() {
            return this.getClass().getSimpleName();
        }
    }
}

