/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NormalMarkerEntity
extends QpEntity
implements QuarryMarker,
ClientSync {
    @NotNull
    private Status status = Status.NOT_CONNECTED;
    @Nullable
    private Link link;

    public NormalMarkerEntity(class_2338 pos, class_2680 blockState) {
        super(PlatformAccess.getAccess().registerObjects().getBlockEntityType((QpBlock)blockState.method_26204()).orElseThrow(), pos, blockState);
    }

    int maxSearch() {
        return PlatformAccess.config().markerPlusRange();
    }

    void tryConnect(Consumer<class_2561> messageSender) {
        if (!this.enabled) {
            messageSender.accept((class_2561)class_2561.method_43469((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.method_11010().method_26204().method_9518()}));
            return;
        }
        if (this.status.isConnected()) {
            messageSender.accept((class_2561)class_2561.method_43470((String)"This marker already has connection"));
            return;
        }
        assert (this.field_11863 != null);
        Optional<NormalMarkerEntity> xMarker = this.getMarker(this.field_11863, this.method_11016(), this.method_11017(), class_2350.class_2351.field_11048);
        Optional<NormalMarkerEntity> zMarker = this.getMarker(this.field_11863, this.method_11016(), this.method_11017(), class_2350.class_2351.field_11051);
        Optional xzMarker = xMarker.flatMap(e -> this.getMarker(this.field_11863, e.method_11016(), e.method_11017(), class_2350.class_2351.field_11051));
        Optional zxMarker = zMarker.flatMap(e -> this.getMarker(this.field_11863, e.method_11016(), e.method_11017(), class_2350.class_2351.field_11048));
        Optional<NormalMarkerEntity> yMarker = IntStream.range(1, this.maxSearch()).flatMap(i -> IntStream.of(i, -i)).filter(y -> !this.field_11863.method_31601(y)).boxed().flatMap(d -> Stream.concat(Stream.of(this.method_11016()), Stream.of(xMarker.stream(), zMarker.stream()).flatMap(Function.identity()).map(class_2586::method_11016)).map(p -> p.method_30513(class_2350.class_2351.field_11052, d.intValue())).flatMap(p -> this.field_11863.method_35230(p, this.method_11017()).stream())).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).filter(e -> !e.status.isConnected()).findAny();
        BiFunction<class_2586, class_2586, Link> f = (x, z) -> new Link(Stream.concat(Stream.of(this.method_11016(), x.method_11016(), z.method_11016()), yMarker.map(class_2586::method_11016).stream()).toList());
        Optional maybeLink = xMarker.flatMap(x -> zMarker.map(z -> (Link)f.apply((class_2586)x, (class_2586)z))).or(() -> xMarker.flatMap(x -> xzMarker.map(z -> (Link)f.apply((class_2586)x, (class_2586)z)))).or(() -> zMarker.flatMap(z -> zxMarker.map(x -> (Link)f.apply((class_2586)x, (class_2586)z))));
        maybeLink.ifPresentOrElse(link -> {
            this.setLink((Link)link, true);
            link.markerPos.stream().filter(Predicate.isEqual(this.method_11016()).negate()).map(arg_0 -> ((class_1937)this.field_11863).method_8321(arg_0)).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).forEach(e -> e.setLink((Link)link, false));
            messageSender.accept((class_2561)class_2561.method_43470((String)"Marker successfully established connection"));
        }, () -> messageSender.accept((class_2561)class_2561.method_43470((String)"Marker tried to establish connection, but failed")));
    }

    Optional<NormalMarkerEntity> getMarker(class_1937 level, class_2338 pos, class_2591<?> type, class_2350.class_2351 axis) {
        return IntStream.range(1, this.maxSearch()).flatMap(i -> IntStream.of(i, -i)).mapToObj(d -> pos.method_30513(axis, d)).flatMap(p -> level.method_35230(p, type).stream()).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).filter(e -> !e.status.isConnected()).findFirst();
    }

    @Override
    public Optional<QuarryMarker.Link> getLink() {
        return Optional.ofNullable(this.link);
    }

    void setLink(@Nullable Link link, boolean isMaster) {
        this.link = link;
        this.status = link != null ? (isMaster ? Status.CONNECTED_MASTER : Status.CONNECTED_SLAVE) : Status.NOT_CONNECTED;
        this.syncToClient();
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    protected void method_11007(class_11372 output) {
        output.method_71469("status", this.status.name());
        super.method_11007(output);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        Status status = input.method_71441("status").map(Status::valueOf).orElse(Status.NOT_CONNECTED);
        this.status = status == Status.RS_POWERED ? status : Status.NOT_CONNECTED;
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.status = input.method_71441("status").map(Status::valueOf).orElse(Status.NOT_CONNECTED);
        this.link = input.method_71426("link", Link.CODEC.codec()).orElse(null);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71469("status", this.status.name());
        if (this.link != null) {
            output.method_71468("link", Link.CODEC.codec(), (Object)this.link);
        }
        return output;
    }

    public void method_11012() {
        super.method_11012();
        if (this.link != null && this.field_11863 != null && !this.field_11863.method_8608()) {
            this.link.markerPos.stream().map(arg_0 -> ((class_1937)this.field_11863).method_8321(arg_0)).filter(NormalMarkerEntity.class::isInstance).map(NormalMarkerEntity.class::cast).forEach(m -> m.setLink(null, false));
        }
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(NormalMarkerEntity.detail(class_124.field_1060, "Status", String.valueOf((Object)this.status)), NormalMarkerEntity.detail(class_124.field_1060, "Link", String.valueOf(this.link))));
    }

    @Nullable
    public class_238 getRenderAabb() {
        if (this.link == null) {
            return null;
        }
        Area area = this.link.area();
        return new class_238((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
    }

    public static enum Status {
        NOT_CONNECTED,
        RS_POWERED,
        CONNECTED_MASTER,
        CONNECTED_SLAVE;


        boolean isConnected() {
            return this == CONNECTED_MASTER || this == CONNECTED_SLAVE;
        }
    }

    protected record Link(List<class_2338> markerPos) implements QuarryMarker.Link
    {
        static final MapCodec<Link> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(Link::markerPos, (String)"markerPos", (Codec)class_2338.field_25064.listOf())).apply((Applicative)i, Link::new));

        @Override
        public Area area() {
            int minX = this.markerPos.stream().mapToInt(class_2382::method_10263).min().orElseThrow();
            int minY = this.markerPos.stream().mapToInt(class_2382::method_10264).min().orElseThrow();
            int minZ = this.markerPos.stream().mapToInt(class_2382::method_10260).min().orElseThrow();
            int maxX = this.markerPos.stream().mapToInt(class_2382::method_10263).max().orElseThrow();
            int maxY = this.markerPos.stream().mapToInt(class_2382::method_10264).max().orElseThrow();
            int maxZ = this.markerPos.stream().mapToInt(class_2382::method_10260).max().orElseThrow();
            return new Area(minX, minY, minZ, maxX, maxY, maxZ, class_2350.field_11036);
        }

        @Override
        public void remove(class_1937 level) {
            for (class_2338 pos : this.markerPos) {
                level.method_8650(pos, false);
            }
        }

        @Override
        public List<class_1799> drops() {
            class_1799 stack = new class_1799((class_1935)PlatformAccess.getAccess().registerObjects().markerBlock().get(), this.markerPos.size());
            return List.of(stack);
        }
    }
}

