/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.mojang.serialization.Codec;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class FlexibleMarkerEntity
extends QpEntity
implements QuarryMarker,
ClientSync {
    @NotNull
    class_2338 min;
    @NotNull
    class_2338 max;
    class_2350 direction = class_2350.field_11043;

    public FlexibleMarkerEntity(@NotNull class_2338 pos, class_2680 blockState) {
        super(pos, blockState);
        this.min = pos;
        this.max = pos;
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.toClientTag(output);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.fromClientTag(input);
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.min = (class_2338)input.method_71426("min", class_2338.field_25064).orElseThrow();
        this.max = (class_2338)input.method_71426("max", class_2338.field_25064).orElseThrow();
        this.direction = (class_2350)input.method_71426("direction", (Codec)class_2350.field_29502).orElseThrow();
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71468("min", class_2338.field_25064, (Object)this.min);
        output.method_71468("max", class_2338.field_25064, (Object)this.max);
        output.method_71468("direction", (Codec)class_2350.field_29502, (Object)this.direction);
        return output;
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(FlexibleMarkerEntity.detail(class_124.field_1060, "min", String.valueOf(this.min)), FlexibleMarkerEntity.detail(class_124.field_1060, "max", String.valueOf(this.max))));
    }

    public void init(class_2350 facing) {
        this.direction = facing;
        this.min = this.method_11016();
        this.max = this.method_11016();
        this.move(Movable.LEFT, 5);
        this.move(Movable.RIGHT, 5);
        this.move(Movable.FORWARD, 10);
        this.syncToClient();
    }

    void move(Movable movable, int amount) {
        assert (this.field_11863 != null);
        class_2350 facing = movable.getActualFacing(this.direction);
        class_2338 offset = this.method_11016();
        if (facing.method_10171() == class_2350.class_2352.field_11056) {
            this.max = this.max.method_10079(facing, amount);
            int d = FlexibleMarkerEntity.getDistance(this.max, offset, facing.method_10166());
            if (d > this.getMaxRange()) {
                this.max = FlexibleMarkerEntity.getLimited(this.max, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.max = FlexibleMarkerEntity.getLimited(this.max, offset, facing, 0);
            }
            if (facing == class_2350.field_11036 && this.max.method_10264() >= this.field_11863.method_31600()) {
                this.max = new class_2338(this.max.method_10263(), this.field_11863.method_31600() - 1, this.max.method_10260());
            }
        } else {
            this.min = this.min.method_10079(facing, amount);
            int d = FlexibleMarkerEntity.getDistance(offset, this.min, facing.method_10166());
            if (d > this.getMaxRange()) {
                this.min = FlexibleMarkerEntity.getLimited(this.min, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.min = FlexibleMarkerEntity.getLimited(this.min, offset, facing, 0);
            }
            if (facing == class_2350.field_11033 && this.min.method_10264() < this.field_11863.method_31607()) {
                this.min = new class_2338(this.min.method_10263(), this.field_11863.method_31607(), this.min.method_10260());
            }
        }
    }

    int getMaxRange() {
        return PlatformAccess.config().flexibleMarkerRange();
    }

    public static int getDistance(class_2338 to, class_2338 from, class_2350.class_2351 axis) {
        return to.method_30558(axis) - from.method_30558(axis);
    }

    public static class_2338 getLimited(class_2338 to, class_2338 from, class_2350 facing, int limit) {
        return switch (facing.method_10166()) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> new class_2338(from.method_10263(), to.method_10264(), to.method_10260()).method_10079(facing, limit);
            case class_2350.class_2351.field_11052 -> new class_2338(to.method_10263(), from.method_10264(), to.method_10260()).method_10079(facing, limit);
            case class_2350.class_2351.field_11051 -> new class_2338(to.method_10263(), to.method_10264(), from.method_10260()).method_10079(facing, limit);
        };
    }

    @Override
    public Optional<QuarryMarker.Link> getLink() {
        return Optional.of(this.createLink());
    }

    FlexibleMarkerLink createLink() {
        class_1799 stack = new class_1799((class_1935)this.method_11010().method_26204());
        return new FlexibleMarkerLink(this.method_11016(), this.min, this.max, this.direction, stack);
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public class_238 getRenderAabb() {
        FlexibleMarkerLink link = this.createLink();
        Area area = link.area();
        return new class_238((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
    }

    public static enum Movable {
        UP(facing -> class_2350.field_11036),
        LEFT(class_2350::method_10160),
        FORWARD(UnaryOperator.identity()),
        RIGHT(class_2350::method_10170),
        DOWN(facing -> class_2350.field_11033);

        private final UnaryOperator<class_2350> operator;
        public final String transName;

        private Movable(UnaryOperator<class_2350> operator) {
            this.operator = operator;
            this.transName = "gui." + this.name().toLowerCase(Locale.US);
        }

        public class_2350 getActualFacing(class_2350 facing) {
            return (class_2350)this.operator.apply(facing);
        }

        public static Movable valueOf(int i) {
            return Movable.values()[i];
        }

        public int distanceFromOrigin(class_2338 origin, class_2338 areaMin, class_2338 areaMax, class_2350 facing) {
            class_2350 actualFacing = this.getActualFacing(facing);
            class_2338 relative = actualFacing.method_10171() == class_2350.class_2352.field_11056 ? areaMax : areaMin;
            return Math.abs(FlexibleMarkerEntity.getDistance(origin, relative, actualFacing.method_10166()));
        }
    }

    record FlexibleMarkerLink(class_2338 markerPos, class_2338 min, class_2338 max, class_2350 direction, class_1799 stack) implements QuarryMarker.Link
    {
        @Override
        public Area area() {
            return new Area((class_2382)this.min, (class_2382)this.max, this.direction);
        }

        @Override
        public void remove(class_1937 level) {
            level.method_8650(this.markerPos, false);
        }

        @Override
        public List<class_1799> drops() {
            return List.of(this.stack);
        }
    }
}

