/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ChunkMarkerEntity
extends QpEntity
implements QuarryMarker,
ClientSync {
    @NotNull
    private class_2350.class_2352 xDirection = class_2350.class_2352.field_11056;
    @NotNull
    private class_2350.class_2352 zDirection = class_2350.class_2352.field_11056;
    int size = 16;
    int minY;
    int maxY;

    public ChunkMarkerEntity(class_2338 pos, class_2680 blockState) {
        super(pos, blockState);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.fromClientTag(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.toClientTag(output);
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.xDirection = input.method_71441("xDirection").map(class_2350.class_2352::valueOf).orElse(this.xDirection);
        this.zDirection = input.method_71441("zDirection").map(class_2350.class_2352::valueOf).orElse(this.zDirection);
        this.size = input.method_71424("size", this.size);
        this.minY = input.method_71424("minY", this.minY);
        this.maxY = input.method_71424("maxY", this.maxY);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71469("xDirection", this.xDirection.name());
        output.method_71469("zDirection", this.zDirection.name());
        output.method_71465("size", this.size);
        output.method_71465("minY", this.minY);
        output.method_71465("maxY", this.maxY);
        return output;
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(ChunkMarkerEntity.detail(class_124.field_1060, "xDirection", String.valueOf(this.xDirection)), ChunkMarkerEntity.detail(class_124.field_1060, "zDirection", String.valueOf(this.zDirection)), ChunkMarkerEntity.detail(class_124.field_1060, "size", String.valueOf(this.size)), ChunkMarkerEntity.detail(class_124.field_1060, "minY", String.valueOf(this.minY)), ChunkMarkerEntity.detail(class_124.field_1060, "maxY", String.valueOf(this.maxY))));
    }

    @Override
    public Optional<QuarryMarker.Link> getLink() {
        return Optional.of(this.createLink());
    }

    Link createLink() {
        class_1799 stack = new class_1799((class_1935)this.method_11010().method_26204());
        return new Link(this.method_11016(), this.xDirection.method_10181() * (this.size + 1), this.zDirection.method_10181() * (this.size + 1), this.minY, this.maxY, stack);
    }

    public void init(class_2350.class_2352 xDirection, class_2350.class_2352 zDirection) {
        this.xDirection = Objects.requireNonNull(xDirection);
        this.zDirection = Objects.requireNonNull(zDirection);
        this.changeSize(this.size);
    }

    public void changeSize(int size) {
        int y = this.method_11016().method_10264();
        this.changeSize(size, y, y);
    }

    public void changeSize(int size, int minY, int maxY) {
        this.size = size;
        this.minY = minY;
        this.maxY = maxY;
    }

    public class_238 getRenderAabb() {
        Link link = this.createLink();
        Area area = link.area();
        return new class_238((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
    }

    record Link(class_2338 basePos, int xOffset, int zOffset, int minY, int maxY, class_1799 drop) implements QuarryMarker.Link
    {
        @Override
        public Area area() {
            int x2 = this.basePos.method_10263() + this.xOffset;
            int z2 = this.basePos.method_10260() + this.zOffset;
            return new Area(Math.min(this.basePos.method_10263(), x2), this.minY, Math.min(this.basePos.method_10260(), z2), Math.max(this.basePos.method_10263(), x2), this.maxY, Math.max(this.basePos.method_10260(), z2), class_2350.field_11036);
        }

        @Override
        public void remove(class_1937 level) {
            level.method_8650(this.basePos, false);
        }

        @Override
        public List<class_1799> drops() {
            return List.of(this.drop);
        }
    }
}

