/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.advquarry.AdvActionActionMessage;
import com.yogpc.qp.machine.advquarry.AdvActionSyncMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.advquarry.WorkConfig;
import com.yogpc.qp.machine.misc.IndexedButton;
import com.yogpc.qp.machine.misc.SmallCheckBox;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1923;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_9848;

public class AdvQuarryScreen
extends class_465<AdvQuarryContainer> {
    private static final class_2960 LOCATION = class_2960.method_60655((String)"quarryplus", (String)"textures/gui/adv_quarry.png");
    private SmallCheckBox areaFrameCheckBox;
    private SmallCheckBox chunkByChunkCheckBox;
    private SmallCheckBox startCheckBox;
    private final List<MovablePosition> movablePositions = new ArrayList<MovablePosition>();

    public AdvQuarryScreen(AdvQuarryContainer c, class_1661 inventory, class_2561 component) {
        super((class_1703)c, inventory, component);
        this.field_2792 = c.imageWidth;
        this.field_2779 = c.imageHeight;
        this.field_25270 = this.field_2779 - 96 + 2;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        int pX = this.field_2776;
        int pY = this.field_2800;
        graphics.method_25290(class_10799.field_56883, LOCATION, pX, pY, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        Area range = ((AdvQuarryContainer)this.method_17577()).quarry.getArea();
        if (range != null) {
            class_1923 chunkPos = new class_1923(((AdvQuarryContainer)this.method_17577()).quarry.method_11016());
            for (MovablePosition movablePosition : this.movablePositions) {
                graphics.method_51433(this.field_22793, String.valueOf(movablePosition.distance(chunkPos, range) / 16.0), movablePosition.baseX, movablePosition.baseY, class_9848.method_61334((int)0x404040), false);
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.movablePositions.add(new MovablePosition(class_2350.field_11043, 77, 18));
        this.movablePositions.add(new MovablePosition(class_2350.field_11035, 77, 62));
        this.movablePositions.add(new MovablePosition(class_2350.field_11039, 24, 40));
        this.movablePositions.add(new MovablePosition(class_2350.field_11034, 131, 40));
        for (MovablePosition movablePosition : this.movablePositions) {
            for (DiffPosition diffPosition : DiffPosition.values()) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)diffPosition.text, (class_4185.class_4241)this.areaChange(movablePosition, diffPosition)).method_46433(this.field_2776 + movablePosition.buttonX(diffPosition), this.field_2800 + movablePosition.buttonY()).method_46437(12, 8).method_46431());
            }
        }
        this.method_37063((class_364)new IndexedButton(8, this.field_2776 + 118, this.field_2800 + 58, 50, 12, (class_2561)class_2561.method_43470((String)"Start"), this::startQuarryOnPress));
        if (!PlatformAccess.getAccess().platformName().equalsIgnoreCase("fabric")) {
            this.method_37063((class_364)new IndexedButton(9, this.field_2776 + 8, this.field_2800 + 58, 50, 12, (class_2561)class_2561.method_43470((String)"Modules"), this::openModuleOnPress));
        }
        this.areaFrameCheckBox = new SmallCheckBox(this.field_2776 + 8, this.field_2800 + 72, 100, 10, 10, 10, (class_2561)class_2561.method_43470((String)"Area Frame"), ((AdvQuarryContainer)this.method_17577()).quarry.workConfig.placeAreaFrame(), this::checkBoxOnPress);
        this.method_37063((class_364)this.areaFrameCheckBox);
        this.chunkByChunkCheckBox = new SmallCheckBox(this.field_2776 + 8, this.field_2800 + 83, 100, 10, 10, 10, (class_2561)class_2561.method_43470((String)"Chunk by Chunk"), ((AdvQuarryContainer)this.method_17577()).quarry.workConfig.chunkByChunk(), this::checkBoxOnPress);
        this.method_37063((class_364)this.chunkByChunkCheckBox);
        this.startCheckBox = new SmallCheckBox(this.field_2776 + 8, this.field_2800 + 94, 100, 10, 10, 10, (class_2561)class_2561.method_43470((String)"Ready to Start"), ((AdvQuarryContainer)this.method_17577()).quarry.workConfig.startImmediately(), this::checkBoxOnPress);
        this.method_37063((class_364)this.startCheckBox);
    }

    private void startQuarryOnPress(class_4185 b) {
        AdvQuarryEntity quarry = ((AdvQuarryContainer)this.method_17577()).quarry;
        if (quarry.currentState == AdvQuarryState.WAITING) {
            quarry.workConfig = quarry.workConfig.startSoonConfig();
            this.startCheckBox.setSelected(quarry.workConfig.startImmediately());
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionActionMessage(quarry, AdvActionActionMessage.Action.QUICK_START));
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, false));
        }
    }

    private void openModuleOnPress(class_4185 b) {
        AdvQuarryEntity quarry = ((AdvQuarryContainer)this.method_17577()).quarry;
        PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionActionMessage(quarry, AdvActionActionMessage.Action.MODULE_INV));
    }

    private void checkBoxOnPress(class_4185 b) {
        AdvQuarryEntity quarry = ((AdvQuarryContainer)this.method_17577()).quarry;
        if (quarry.currentState == AdvQuarryState.WAITING) {
            boolean placeAreaFrame = this.areaFrameCheckBox.isSelected();
            boolean chunkByChunk = this.chunkByChunkCheckBox.isSelected();
            boolean startImmediately = this.startCheckBox.isSelected();
            quarry.workConfig = new WorkConfig(startImmediately, placeAreaFrame, chunkByChunk);
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, false));
        }
    }

    private class_4185.class_4241 areaChange(MovablePosition movablePosition, DiffPosition diffPosition) {
        return b -> {
            AdvQuarryEntity quarry = ((AdvQuarryContainer)this.method_17577()).quarry;
            if (quarry.currentState != AdvQuarryState.WAITING) {
                return;
            }
            class_2350 direction = movablePosition.direction;
            int increase = diffPosition.sign;
            boolean shift = class_310.method_1551().method_74187();
            boolean ctrl = class_310.method_1551().method_74188();
            int t = shift && ctrl ? 1024 * increase : (shift ? 256 * increase : (ctrl ? 64 * increase : 16 * increase));
            Area range = quarry.getArea();
            if (range == null) {
                return;
            }
            Area newRange = switch (direction.method_10166()) {
                case class_2350.class_2351.field_11048 -> {
                    int e;
                    switch (direction.method_10171()) {
                        case field_11056: {
                            e = range.maxX();
                            if (range.minX() < e + t) {
                                yield new Area(range.minX(), range.minY(), range.minZ(), e + t, range.maxY(), range.maxZ(), range.direction());
                            }
                            yield range;
                        }
                        case field_11060: {
                            e = range.minX();
                            if (range.maxX() > e - t) {
                                yield new Area(e - t, range.minY(), range.minZ(), range.maxX(), range.maxY(), range.maxZ(), range.direction());
                            }
                            yield range;
                        }
                    }
                    yield range;
                }
                case class_2350.class_2351.field_11051 -> {
                    int e;
                    switch (direction.method_10171()) {
                        case field_11056: {
                            e = range.maxZ();
                            if (range.minZ() < e + t) {
                                yield new Area(range.minX(), range.minY(), range.minZ(), range.maxX(), range.maxY(), e + t, range.direction());
                            }
                            yield range;
                        }
                        case field_11060: {
                            e = range.minZ();
                            if (range.maxZ() > e - t) {
                                yield new Area(range.minX(), range.minY(), e - t, range.maxX(), range.maxY(), range.maxZ(), range.direction());
                            }
                            yield range;
                        }
                    }
                    yield range;
                }
                default -> range;
            };
            quarry.setArea(newRange);
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, true));
        };
    }

    private record MovablePosition(class_2350 direction, int baseX, int baseY) {
        int buttonX(DiffPosition diffPosition) {
            return switch (diffPosition.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.plusButtonX();
                case 1 -> this.minusButtonX();
            };
        }

        int minusButtonX() {
            return this.baseX - 13;
        }

        int plusButtonX() {
            return this.baseX + 22;
        }

        int buttonY() {
            return this.baseY - 1;
        }

        double distance(class_1923 quarryChunk, Area area) {
            class_2350 class_23502 = this.direction;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "SOUTH", "WEST", "EAST"}, (class_2350)class_23502, n)) {
                case 0 -> quarryChunk.method_8328() - area.minZ() - 1;
                case 1 -> area.maxZ() - quarryChunk.method_8329() - 1;
                case 2 -> quarryChunk.method_8326() - area.minX() - 1;
                case 3 -> area.maxX() - quarryChunk.method_8327() - 1;
                default -> 0.0;
            };
        }
    }

    private static enum DiffPosition {
        PLUS((class_2561)class_2561.method_43470((String)"+"), 1),
        MINUS((class_2561)class_2561.method_43470((String)"-"), -1);

        private final class_2561 text;
        private final int sign;

        private DiffPosition(class_2561 text, int sign) {
            this.text = text;
            this.sign = sign;
        }
    }
}

