/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.google.common.collect.Sets;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.EnchantmentCache;
import com.yogpc.qp.machine.ItemConverter;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PickIterator;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.PowerMap;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.WorkResult;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.advquarry.AdvQuarryTarget;
import com.yogpc.qp.machine.advquarry.WorkConfig;
import com.yogpc.qp.machine.exp.ExpModule;
import com.yogpc.qp.machine.misc.BlockBreakEventResult;
import com.yogpc.qp.machine.misc.DigMinY;
import com.yogpc.qp.machine.misc.QuarryChunkLoader;
import com.yogpc.qp.machine.module.ConverterModule;
import com.yogpc.qp.machine.module.ModuleInventory;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.packet.ClientSync;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1694;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7871;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AdvQuarryEntity
extends PowerEntity
implements ClientSync {
    public static final Marker MARKER = MarkerFactory.getMarker((String)"advQuarry");
    @NotNull
    AdvQuarryState currentState = AdvQuarryState.FINISHED;
    @Nullable
    private Area area;
    @Nullable
    private PickIterator<class_2338> targetIterator;
    @Nullable
    class_2338 targetPos;
    @NotNull
    MachineStorage storage = MachineStorage.of();
    @NotNull
    WorkConfig workConfig = WorkConfig.DEFAULT;
    @NotNull
    public DigMinY digMinY = new DigMinY();
    @NotNull
    final EnchantmentCache enchantmentCache = new EnchantmentCache();
    @NotNull
    Set<QuarryModule> modules = Collections.emptySet();
    @NotNull
    final ModuleInventory moduleInventory = new ModuleInventory(5, AdvQuarryEntity::moduleFilter, m -> this.modules, this::method_5431);
    boolean searchEnergyConsumed = false;
    @NotNull
    QuarryChunkLoader chunkLoader = QuarryChunkLoader.None.INSTANCE;
    @NotNull
    ItemConverter itemConverter = AdvQuarryEntity.defaultItemConverter();

    protected AdvQuarryEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.setMaxEnergy((long)(AdvQuarryEntity.powerMap().maxEnergy() * 1.0E9));
    }

    static PowerMap.AdvQuarry powerMap() {
        return PlatformAccess.config().powerMap().advQuarry();
    }

    static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AdvQuarryEntity quarry) {
        block7: for (int i = 0; i < quarry.repeatCount(); ++i) {
            if (!quarry.hasEnoughEnergy()) {
                return;
            }
            AdvQuarryState advQuarryState = quarry.currentState;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FINISHED", "WAITING", "MAKE_FRAME", "BREAK_BLOCK", "CLEAN_UP"}, (AdvQuarryState)advQuarryState, n)) {
                case 0: {
                    return;
                }
                case 1: {
                    quarry.waiting();
                    return;
                }
                case 2: {
                    quarry.makeFrame();
                    continue block7;
                }
                case 3: {
                    quarry.breakBlock();
                    continue block7;
                }
                case 4: {
                    quarry.cleanUp();
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)quarry.currentState));
                }
            }
        }
    }

    @Override
    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.fromClientTag(input);
        class_2338 current = input.method_71426("targetPos", class_2338.field_25064).orElse(null);
        this.workConfig = input.method_71426("workConfig", WorkConfig.CODEC.codec()).orElse(WorkConfig.DEFAULT);
        this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.area, current, this.workConfig);
        this.targetPos = current;
        this.storage = input.method_71426("storage", MachineStorage.CODEC.codec()).orElseGet(MachineStorage::of);
        this.moduleInventory.method_7659(input.method_71437("moduleInventory", class_1799.field_24671));
        this.chunkLoader = input.method_71426("chunkLoader", QuarryChunkLoader.CODEC).orElse(QuarryChunkLoader.None.INSTANCE);
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.toClientTag(output);
        output.method_71468("workConfig", WorkConfig.CODEC.codec(), (Object)this.workConfig);
        if (this.targetIterator != null) {
            output.method_71468("targetPos", class_2338.field_25064, (Object)this.targetIterator.getLastReturned());
        }
        output.method_71468("storage", MachineStorage.CODEC.codec(), (Object)this.storage);
        this.moduleInventory.method_7660(output.method_71467("moduleInventory", class_1799.field_24671));
        output.method_71468("chunkLoader", QuarryChunkLoader.CODEC, (Object)this.chunkLoader);
    }

    @Override
    public void fromClientTag(class_11368 input) {
        this.currentState = input.method_71441("state").map(AdvQuarryState::valueOf).orElse(AdvQuarryState.FINISHED);
        this.area = input.method_71426("area", Area.CODEC.codec()).orElse(null);
        this.digMinY = input.method_71426("digMinY", DigMinY.CODEC.codec()).orElseGet(DigMinY::new);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71469("state", this.currentState.name());
        if (this.area != null) {
            output.method_71468("area", Area.CODEC.codec(), (Object)this.area);
        }
        output.method_71468("digMinY", DigMinY.CODEC.codec(), (Object)this.digMinY);
        return output;
    }

    public void method_5431() {
        super.method_5431();
        this.updateModules();
    }

    public void method_11012() {
        super.method_11012();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 s = (class_3218)class_19372;
            this.chunkLoader.makeChunkUnLoaded(s);
        }
    }

    public void method_66473(class_2338 pos, class_2680 blockState) {
        if (this.field_11863 != null) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.moduleInventory);
        }
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(AdvQuarryEntity.detail(class_124.field_1060, "State", this.currentState.name()), AdvQuarryEntity.detail(class_124.field_1060, "Area", String.valueOf(this.area)), AdvQuarryEntity.detail(class_124.field_1060, "Target", String.valueOf(this.targetPos)), AdvQuarryEntity.detail(class_124.field_1060, "TargetIterator", this.targetIterator != null ? this.targetIterator.getClass().getSimpleName() : "null"), AdvQuarryEntity.detail(class_124.field_1060, "Storage", String.valueOf(this.storage)), AdvQuarryEntity.detail(class_124.field_1060, "DigMinY", String.valueOf(this.digMinY.getMinY((class_4538)this.field_11863))), AdvQuarryEntity.detail(class_124.field_1060, "Modules", String.valueOf(this.modules)), AdvQuarryEntity.detail(class_124.field_1060, "Enchantment", String.valueOf(this.enchantmentCache))));
    }

    @Override
    public final void updateMaxEnergyWithEnchantment(class_1937 level) {
        int efficiency = this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)level.method_30349());
        this.setMaxEnergy((long)(AdvQuarryEntity.powerMap().maxEnergy() * 1.0E9 * (double)(1 + efficiency)));
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    void setState(AdvQuarryState state, class_2680 blockState) {
        if (this.field_11863 != null && this.currentState != state) {
            if (!this.field_11863.method_8608()) {
                if (!AdvQuarryState.isWorking(this.currentState) && AdvQuarryState.isWorking(state)) {
                    this.chunkLoader = QuarryChunkLoader.of((class_3218)this.field_11863, this.method_11016());
                    this.chunkLoader.makeChunkLoaded((class_3218)this.field_11863);
                } else if (AdvQuarryState.isWorking(this.currentState) && !AdvQuarryState.isWorking(state)) {
                    this.chunkLoader.makeChunkUnLoaded((class_3218)this.field_11863);
                    this.chunkLoader = QuarryChunkLoader.None.INSTANCE;
                }
            }
            this.currentState = state;
            this.syncToClient();
            this.field_11863.method_8652(this.method_11016(), (class_2680)blockState.method_11657((class_2769)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(AdvQuarryState.isWorking(state))), 3);
            if (state == AdvQuarryState.FINISHED) {
                this.energyCounter.logUsageMap();
            }
        }
    }

    public String renderMode() {
        return switch (this.currentState) {
            case AdvQuarryState.WAITING, AdvQuarryState.MAKE_FRAME -> "frame";
            default -> "none";
        };
    }

    void updateModules() {
        this.modules = this.field_11863 == null ? this.moduleInventory.getModules() : Sets.union(this.moduleInventory.getModules(), QuarryModuleProvider.Block.getModulesInWorld(this.field_11863, this.method_11016()));
        this.itemConverter = AdvQuarryEntity.defaultItemConverter().concat(ConverterModule.findConversions(this.modules));
    }

    protected int repeatCount() {
        RepeatTickModuleItem.RepeatTickModule repeatTickModule = RepeatTickModuleItem.getModule(this.modules).orElse(RepeatTickModuleItem.ZERO);
        return repeatTickModule.stackSize() + 1;
    }

    protected boolean shouldRemoveBedrock() {
        return this.modules.contains(QuarryModule.Constant.BEDROCK);
    }

    @NotNull
    protected Optional<ExpModule> getExpModule() {
        return ExpModule.getModule(this.modules);
    }

    @Nullable
    static PickIterator<class_2338> createTargetIterator(@NotNull AdvQuarryState currentState, @Nullable Area area, class_2338 current, WorkConfig config) {
        if (area == null) {
            return null;
        }
        if (currentState == AdvQuarryState.MAKE_FRAME) {
            PickIterator<class_2338> iterator = area.quarryFramePosIterator();
            iterator.setLastReturned(current);
            return iterator;
        }
        if (currentState == AdvQuarryState.BREAK_BLOCK || currentState == AdvQuarryState.CLEAN_UP) {
            AdvQuarryTarget iterator = config.chunkByChunk() ? new AdvQuarryTarget.ChunkByChunk(area) : new AdvQuarryTarget.North(area);
            ((PickIterator)iterator).setLastReturned(current);
            return iterator;
        }
        return null;
    }

    void waiting() {
        if (!this.workConfig.startImmediately()) {
            return;
        }
        if (this.getEnergy() > this.getMaxEnergy() / 200L && this.area != null) {
            this.startQuarryWork();
        }
    }

    void startQuarryWork() {
        AdvQuarryState next = this.workConfig.placeAreaFrame() ? AdvQuarryState.MAKE_FRAME : AdvQuarryState.BREAK_BLOCK;
        this.setState(next, this.method_11010());
    }

    void makeFrame() {
        WorkResult result;
        class_2680 state;
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.getArea(), null, this.workConfig);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
        }
        if ((state = this.field_11863.method_8320(this.targetPos)).method_27852((class_2248)PlatformAccess.getAccess().registerObjects().frameBlock().get())) {
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
                this.makeFrame();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(AdvQuarryState.BREAK_BLOCK, this.method_11010());
            }
            return;
        }
        if (!(this.method_11016().equals((Object)this.targetPos) || state.method_26215() || (result = this.breakOneBlock(this.targetPos)).isSuccess())) {
            return;
        }
        long requiredEnergy = (long)(1.0E9 * AdvQuarryEntity.powerMap().makeFrame());
        if (this.useEnergy(requiredEnergy, true, false, "makeFrame") == requiredEnergy) {
            this.useEnergy(requiredEnergy, false, false, "makeFrame");
            if (!this.targetPos.equals((Object)this.method_11016())) {
                this.field_11863.method_8652(this.targetPos, PlatformAccess.getAccess().registerObjects().frameBlock().get().method_9564(), 3);
            }
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(AdvQuarryState.BREAK_BLOCK, this.method_11010());
            }
        }
    }

    void breakBlock() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.getArea(), null, this.workConfig);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
            assert (this.targetPos != null);
        }
        WorkResult result = null;
        while (result == null || result == WorkResult.SKIPPED) {
            if (this.targetPos == null) {
                return;
            }
            if (!this.searchEnergyConsumed) {
                long used;
                long energy = (long)AdvQuarryEntity.powerMap().searchBase() * 1000000000L * (long)this.targetPos.method_10264();
                if (energy != (used = this.useEnergy(energy, false, false, "searchEnergy"))) {
                    return;
                }
                this.searchEnergyConsumed = true;
            }
            if ((result = this.breakBlocks(this.targetPos.method_10263(), this.targetPos.method_10260())).isSuccess()) {
                this.searchEnergyConsumed = false;
                if (this.targetIterator.hasNext()) {
                    this.targetPos = this.targetIterator.next();
                    continue;
                }
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(AdvQuarryState.CLEAN_UP, this.method_11010());
                return;
            }
            if (result != WorkResult.NOT_ENOUGH_ENERGY) continue;
            return;
        }
    }

    void cleanUp() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.getArea(), null, this.workConfig);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
            assert (this.targetPos != null);
        }
        int count = 0;
        while (count < 32 && this.currentState == AdvQuarryState.CLEAN_UP) {
            if (this.targetPos == null) {
                return;
            }
            WorkResult result = this.cleanUpFluid(this.targetPos.method_10263(), this.targetPos.method_10260());
            if (result.isSuccess()) {
                ++count;
            }
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
                continue;
            }
            this.targetIterator = null;
            this.targetPos = null;
            this.setState(AdvQuarryState.FINISHED, this.method_11010());
            return;
        }
    }

    @NotNull
    WorkResult breakOneBlock(class_2338 target) {
        assert (this.field_11863 != null);
        class_3218 serverLevel = (class_3218)this.field_11863;
        class_2680 state = serverLevel.method_8320(target);
        if (state.method_26215() || state.equals((Object)this.stateAfterBreak((class_1937)serverLevel, target, state))) {
            return WorkResult.SUCCESS;
        }
        class_5455 lookup = serverLevel.method_30349();
        class_2586 blockEntity = serverLevel.method_8321(target);
        class_3222 player = this.getQuarryFakePlayer(serverLevel, target);
        class_1799 pickaxe = class_1802.field_22024.method_7854();
        class_1890.method_57530((class_1799)pickaxe, (class_9304)this.enchantmentCache.getEnchantmentsForPickaxe(this.getEnchantments(), (class_7871.class_7872)lookup));
        player.method_6122(class_1268.field_5808, pickaxe);
        float hardness = state.method_26214((class_1922)serverLevel, target);
        BlockBreakEventResult eventResult = this.checkBreakEvent((class_1937)serverLevel, player, state, target, blockEntity);
        if (eventResult.canceled()) {
            return WorkResult.FAIL_EVENT;
        }
        WorkResult moduleResult = this.breakBlockModuleOverride(serverLevel, state, target, hardness);
        if (moduleResult != WorkResult.SKIPPED) {
            return moduleResult;
        }
        if (hardness < 0.0f) {
            return WorkResult.SKIPPED;
        }
        long requiredEnergy = AdvQuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9119, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9130, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9099, (class_7871.class_7872)lookup) > 0);
        this.useEnergy(requiredEnergy, false, true, "breakBlock");
        BlockBreakEventResult afterBreakEventResult = this.afterBreak((class_1937)serverLevel, player, state, target, blockEntity, class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)target, (class_2586)blockEntity, (class_1297)player, (class_1799)pickaxe), pickaxe, this.stateAfterBreak((class_1937)serverLevel, target, state));
        if (!afterBreakEventResult.canceled()) {
            afterBreakEventResult.drops().stream().flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
            int amount = eventResult.exp().orElse(afterBreakEventResult.exp().orElse(0));
            if (amount != 0) {
                this.getExpModule().ifPresent(e -> e.addExp(amount));
            }
        }
        assert (this.area != null);
        for (class_2338 edge : this.area.getEdgeForPos(target)) {
            if (this.field_11863.method_8316(edge).method_15769()) continue;
            this.useEnergy((long)(AdvQuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
            this.removeFluidAt(this.field_11863, edge, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
        }
        return WorkResult.SUCCESS;
    }

    @NotNull
    WorkResult breakBlocks(int x, int z) {
        class_2680 state;
        assert (this.field_11863 != null);
        class_3218 serverLevel = (class_3218)this.field_11863;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, this.method_11016().method_10264() - 1, z);
        class_5455 lookup = serverLevel.method_30349();
        class_3222 player = this.getQuarryFakePlayer(serverLevel, (class_2338)mutableBlockPos);
        class_1799 pickaxe = class_1802.field_22024.method_7854();
        class_1890.method_57530((class_1799)pickaxe, (class_9304)this.enchantmentCache.getEnchantmentsForPickaxe(this.getEnchantments(), (class_7871.class_7872)lookup));
        player.method_6122(class_1268.field_5808, pickaxe);
        class_238 aabb = new class_238((double)(x - 5), (double)(this.digMinY.getMinY((class_4538)serverLevel) - 5), (double)(z - 5), (double)(x + 5), (double)(this.method_11016().method_10264() - 1), (double)(z + 5));
        serverLevel.method_8390(class_1542.class, aabb, Predicate.not(i -> i.method_6983().method_7960())).forEach(i -> {
            this.itemConverter.convert(i.method_6983()).forEach(this.storage::addItem);
            i.method_5768(serverLevel);
        });
        serverLevel.method_18467(class_1540.class, aabb).forEach(i -> {
            this.itemConverter.convert(new class_1799((class_1935)i.method_6962().method_26204())).forEach(this.storage::addItem);
            i.method_31472();
        });
        this.getExpModule().ifPresent(e -> serverLevel.method_8390(class_1303.class, aabb, class_1301.field_6154).forEach(orb -> {
            e.addExp(orb.method_5919());
            orb.method_5768(serverLevel);
        }));
        if (this.shouldRemoveMinecarts()) {
            serverLevel.method_18467(class_1694.class, aabb).forEach(chest -> {
                IntStream.range(0, chest.method_5439()).mapToObj(arg_0 -> ((class_1694)chest).method_5438(arg_0)).flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                chest.method_5448();
                chest.method_5768(serverLevel);
            });
        }
        this.removeEdgeFluid(x, z, serverLevel, player);
        long requiredEnergy = 0L;
        AtomicInteger exp = new AtomicInteger(0);
        ArrayList<Pair> toBreak = new ArrayList<Pair>();
        ArrayList<Pair> toDrain = new ArrayList<Pair>();
        HashSet<class_2338.class_2339> handled = new HashSet<class_2338.class_2339>();
        HashMap<class_2338, BlockBreakEventResult> resultMap = new HashMap<class_2338, BlockBreakEventResult>();
        for (int y = this.method_11016().method_10264() - 1; y >= this.digMinY.getMinY((class_4538)serverLevel); --y) {
            mutableBlockPos.method_33098(y);
            class_2680 state2 = serverLevel.method_8320((class_2338)mutableBlockPos);
            class_3610 fluidState = serverLevel.method_8316((class_2338)mutableBlockPos);
            if (fluidState.method_15769()) {
                if (state2.method_26215()) continue;
                class_2586 blockEntity = serverLevel.method_8321((class_2338)mutableBlockPos);
                float hardness = state2.method_26214((class_1922)serverLevel, (class_2338)mutableBlockPos);
                BlockBreakEventResult eventResult = this.checkBreakEvent((class_1937)serverLevel, player, state2, (class_2338)mutableBlockPos, blockEntity);
                if (eventResult.canceled()) continue;
                WorkResult moduleResult = this.breakBlockModuleOverride(serverLevel, state2, (class_2338)mutableBlockPos, hardness);
                if (moduleResult != WorkResult.SKIPPED) {
                    handled.add(mutableBlockPos);
                    continue;
                }
                if (hardness < 0.0f) continue;
                long energy = AdvQuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9119, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9130, (class_7871.class_7872)lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9099, (class_7871.class_7872)lookup) > 0);
                requiredEnergy += energy;
                toBreak.add(Pair.of((Object)mutableBlockPos.method_10062(), (Object)state2));
                resultMap.put(mutableBlockPos.method_10062(), eventResult);
                continue;
            }
            long energy = (long)AdvQuarryEntity.powerMap().breakBlockFluid() * 1000000000L;
            requiredEnergy += energy;
            toDrain.add(Pair.of((Object)mutableBlockPos.method_10062(), (Object)state2));
        }
        if (toBreak.isEmpty() && toDrain.isEmpty()) {
            if (handled.isEmpty()) {
                return WorkResult.SKIPPED;
            }
            return WorkResult.SUCCESS;
        }
        this.useEnergy(requiredEnergy, false, true, "breakBlock");
        for (Pair pair : toDrain) {
            class_2248 energy = ((class_2680)pair.getRight()).method_26204();
            if (energy instanceof class_2263) {
                class_2263 fluidBlock = (class_2263)energy;
                class_1799 bucketItem = fluidBlock.method_9700((class_1309)player, (class_1936)serverLevel, (class_2338)pair.getLeft(), (class_2680)pair.getRight());
                this.storage.addBucketFluid(bucketItem);
            }
            if (!(state = serverLevel.method_8320((class_2338)pair.getLeft())).method_26215()) {
                this.breakOneBlock((class_2338)pair.getLeft());
            }
            serverLevel.method_8652((class_2338)pair.getLeft(), PlatformAccess.getAccess().registerObjects().softBlock().get().method_9564(), 18);
        }
        for (Pair statePair : toBreak) {
            state = (class_2680)statePair.getValue();
            class_2338 target = (class_2338)statePair.getKey();
            class_2586 blockEntity = serverLevel.method_8321(target);
            try {
                BlockBreakEventResult afterBreakEventResult = this.afterBreak((class_1937)serverLevel, player, state, target, blockEntity, class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)target, (class_2586)blockEntity, (class_1297)player, (class_1799)pickaxe), pickaxe, this.stateAfterBreak((class_1937)serverLevel, target, state));
                if (afterBreakEventResult.canceled()) continue;
                afterBreakEventResult.drops().stream().flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                int amount = resultMap.getOrDefault(target, BlockBreakEventResult.EMPTY).exp().orElse(afterBreakEventResult.exp().orElse(0));
                exp.addAndGet(amount);
            }
            catch (Exception e2) {
                QuarryPlus.LOGGER.warn(MARKER, "Error occurred while processing block {} at ({})", new Object[]{state.method_26204(), target.method_23854(), e2});
            }
        }
        for (Pair p : toBreak) {
            serverLevel.method_8652((class_2338)p.getKey(), this.stateAfterBreak((class_1937)serverLevel, (class_2338)p.getKey(), (class_2680)p.getRight()), 18);
        }
        if (exp.get() > 0) {
            this.getExpModule().ifPresent(e -> {
                this.useEnergy((long)AdvQuarryEntity.powerMap().expCollect() * 1000000000L, false, true, "expCollect");
                e.addExp(exp.get());
            });
        }
        this.method_5431();
        return WorkResult.SUCCESS;
    }

    @NotNull
    WorkResult cleanUpFluid(int x, int z) {
        assert (this.field_11863 != null);
        class_3218 serverLevel = (class_3218)this.field_11863;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        boolean flagRemoved = false;
        for (int y = this.method_11016().method_10264() - 1; y >= this.digMinY.getMinY((class_4538)serverLevel); --y) {
            boolean blockIsReplaced;
            mutableBlockPos.method_10103(x, y, z);
            class_2680 state = serverLevel.method_8320((class_2338)mutableBlockPos);
            class_3610 fluid = serverLevel.method_8316((class_2338)mutableBlockPos);
            boolean blockCondition = state.method_27852((class_2248)PlatformAccess.getAccess().registerObjects().softBlock().get()) || state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_10445) || !fluid.method_15769() && !fluid.method_15771();
            boolean bl = blockIsReplaced = this.stateAfterBreak((class_1937)serverLevel, (class_2338)mutableBlockPos, state) == state;
            if (!blockCondition || blockIsReplaced) continue;
            serverLevel.method_8652((class_2338)mutableBlockPos, class_2246.field_10124.method_9564(), 3);
            flagRemoved = true;
        }
        return flagRemoved ? WorkResult.SUCCESS : WorkResult.SKIPPED;
    }

    protected final class_3222 getQuarryFakePlayer(class_3218 level, class_2338 target) {
        return PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, level, target);
    }

    protected class_2680 stateAfterBreak(class_1937 level, class_2338 pos, class_2680 before) {
        return class_2246.field_10124.method_9564();
    }

    void removeFluidAt(@NotNull class_1937 level, class_2338 pos, class_3222 player, class_2680 newState) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof class_2404) {
            class_3610 f = level.method_8316(pos);
            if (!f.method_15769() && f.method_15771()) {
                this.storage.addFluid(f.method_15772(), 81000L);
            }
            level.method_8652(pos, newState, 3);
        } else {
            class_2248 f = state.method_26204();
            if (f instanceof class_2263) {
                class_2263 bucketPickup = (class_2263)f;
                class_1799 picked = bucketPickup.method_9700((class_1309)player, (class_1936)level, pos, state);
                this.storage.addBucketFluid(picked);
            } else {
                level.method_8652(pos, newState, 3);
            }
        }
    }

    void removeEdgeFluid(int x, int z, class_3218 targetWorld, class_3222 player) {
        boolean flagMaxZ;
        assert (this.area != null);
        boolean flagMinX = x - 1 == this.area.minX();
        boolean flagMaxX = x + 1 == this.area.maxX();
        boolean flagMinZ = z - 1 == this.area.minZ();
        boolean bl = flagMaxZ = z + 1 == this.area.maxZ();
        if (flagMinX) {
            this.removeFluidAtXZ(this.area.minX(), z, targetWorld, player);
        }
        if (flagMaxX) {
            this.removeFluidAtXZ(this.area.maxX(), z, targetWorld, player);
        }
        if (flagMinZ) {
            this.removeFluidAtXZ(x, this.area.minZ(), targetWorld, player);
        }
        if (flagMaxZ) {
            this.removeFluidAtXZ(x, this.area.maxZ(), targetWorld, player);
        }
        if (flagMinX && flagMinZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.minZ(), targetWorld, player);
        }
        if (flagMinX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.maxZ(), targetWorld, player);
        }
        if (flagMaxX && flagMinZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.minZ(), targetWorld, player);
        }
        if (flagMaxX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.maxZ(), targetWorld, player);
        }
    }

    void removeFluidAtXZ(int x, int z, class_3218 world, class_3222 player) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, 0, z);
        for (int y = this.method_11016().method_10264() - 1; y > this.digMinY.getMinY((class_4538)world); --y) {
            pos.method_33098(y);
            class_3610 fluidState = world.method_8316((class_2338)pos);
            if (fluidState.method_15769()) continue;
            this.useEnergy((long)(AdvQuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
            this.removeFluidAt((class_1937)world, (class_2338)pos, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
        }
    }

    protected final BlockBreakEventResult checkBreakEvent(class_1937 level, class_3222 fakePlayer, class_2680 state, class_2338 target, @Nullable class_2586 blockEntity) {
        return PlatformAccess.getAccess().mining().checkBreakEvent(this, level, fakePlayer, state, target, blockEntity);
    }

    protected final BlockBreakEventResult afterBreak(class_1937 level, class_3222 fakePlayer, class_2680 state, class_2338 target, @Nullable class_2586 blockEntity, List<class_1799> drops, class_1799 pickaxe, class_2680 newState) {
        return PlatformAccess.getAccess().mining().afterBreak(this, level, fakePlayer, state, target, blockEntity, drops, pickaxe, newState);
    }

    WorkResult breakBlockModuleOverride(class_3218 level, class_2680 state, class_2338 target, float hardness) {
        if (hardness < 0.0f && state.method_27852(class_2246.field_9987) && this.shouldRemoveBedrock()) {
            int worldBottom = level.method_31607();
            int targetY = target.method_10264();
            if (level.method_27983().equals(class_1937.field_25180)) {
                int top;
                int n = top = PlatformAccess.config().removeBedrockOnNetherTop() ? level.method_31600() + 1 : 127;
                if (!(worldBottom < targetY && targetY < worldBottom + 5 || 122 < targetY && targetY < top)) {
                    return WorkResult.SKIPPED;
                }
            } else if (worldBottom >= targetY || targetY >= worldBottom + 5) {
                return WorkResult.SKIPPED;
            }
            class_5455 lookup = level.method_30349();
            long requiredEnergy = AdvQuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (class_5321<class_1887>)class_1893.field_9131, (class_7871.class_7872)lookup), 0, 0, true);
            this.useEnergy(requiredEnergy, false, true, "breakBlock");
            level.method_8652(target, this.stateAfterBreak((class_1937)level, target, state), 3);
            return WorkResult.SUCCESS;
        }
        if (state.method_27852(class_2246.field_10316)) {
            level.method_8650(target, false);
            return WorkResult.SUCCESS;
        }
        return WorkResult.SKIPPED;
    }

    @VisibleForTesting
    @NotNull
    public class_9304 getEnchantments() {
        return (class_9304)this.method_58693().method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
    }

    @VisibleForTesting
    public void setEnchantments(@NotNull class_9304 enchantments) {
        this.method_58684(class_9323.method_57827().method_57839(this.method_58693()).method_57840(class_9334.field_49633, (Object)enchantments).method_57838());
    }

    static boolean moduleFilter(QuarryModule module) {
        return module != QuarryModule.Constant.PUMP;
    }

    static ItemConverter defaultItemConverter() {
        if (PlatformAccess.config().removeCommonMaterialsByChunkDestroyer()) {
            return ItemConverter.defaultInstance().concat(List.of(new ItemConverter.ChunkDestroyerConversion()));
        }
        return ItemConverter.defaultInstance();
    }

    protected boolean shouldRemoveMinecarts() {
        return PlatformAccess.config().removeMinecartWithChest();
    }
}

