/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.CombinedBlockEntityTicker;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockItem;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.AdvQuarryInitialAskMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryItem;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.machine.module.ModuleContainer;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AdvQuarryBlock
extends QpEntityBlock {
    public static final String NAME = "adv_quarry";

    public AdvQuarryBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_50012(class_3619.field_15972).method_9629(1.5f, 10.0f).method_9626(class_2498.field_11544), NAME, (Function<? super QpBlock, ? extends QpBlockItem>)((Function<QpBlock, QpBlockItem>)AdvQuarryItem::new));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043));
    }

    @Override
    protected QpBlock createBlock(class_4970.class_2251 properties) {
        return new AdvQuarryBlock();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{QpBlockProperty.WORKING, class_2741.field_12525});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8036() == null ? class_2350.field_11043 : ctx.method_8036().method_5735().method_10153();
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)facing);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        if (level.method_8608()) {
            return null;
        }
        return AdvQuarryBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, PowerEntity.logTicker(), AdvQuarryEntity::serverTick, MachineStorage.pushItemTicker(), MachineStorage.pushFluidTicker()));
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        AdvQuarryEntity entity = this.getBlockEntityType().map(t -> (AdvQuarryEntity)t.method_24182((class_1922)level, pos)).orElse(null);
        if (entity != null) {
            if (!level.method_8608()) {
                if (entity.enabled) {
                    if (player.method_6047().method_7909() instanceof QuarryModuleProvider.Item && !PlatformAccess.getAccess().platformName().equalsIgnoreCase("fabric")) {
                        PlatformAccess.getAccess().openGui((class_3222)player, new GeneralScreenHandler<ModuleContainer>(entity, ModuleContainer::new));
                    } else {
                        PlatformAccess.getAccess().openGui((class_3222)player, new GeneralScreenHandler<AdvQuarryContainer>(entity, AdvQuarryContainer::new));
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43469((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.method_9518()}), true);
                }
            }
            return class_1269.field_52422;
        }
        return super.method_55766(state, level, pos, player, hitResult);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof AdvQuarryEntity) {
            AdvQuarryEntity quarry = (AdvQuarryEntity)class_25862;
            if (!level.method_8608()) {
                quarry.updateMaxEnergyWithEnchantment(level);
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
                QuarryMarker.Link markerLink = Stream.of(facing.method_10153(), facing.method_10160(), facing.method_10170()).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1937)level).method_8321(arg_0)).filter(QuarryMarker.class::isInstance).map(QuarryMarker.class::cast).flatMap(m -> m.getLink().stream()).findAny().orElseGet(() -> new QuarryMarker.StaticLink(AdvQuarryBlock.createDefaultArea(pos, facing, 0)));
                Area area = Area.assumeY(markerLink.area());
                if (!area.quarryDigPosIterator(pos.method_10264()).hasNext()) {
                    QuarryPlus.LOGGER.warn("The area for machine({}) doesn't have enough space for work. Area: {}", (Object)pos.method_23854(), (Object)area);
                    if (placer instanceof class_1657) {
                        class_1657 p = (class_1657)placer;
                        String text = "This machine doesn't have enough space for work";
                        p.method_7353((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1061), false);
                    }
                    return;
                }
                quarry.setArea(area);
                markerLink.drops().forEach(quarry.storage::addItem);
                markerLink.remove(level);
                if (placer instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)placer;
                    quarry.workConfig = quarry.workConfig.noAutoStartConfig();
                    PlatformAccess.getAccess().packetHandler().sendToClientPlayer(new AdvQuarryInitialAskMessage(quarry), serverPlayer);
                }
                quarry.setState(AdvQuarryState.WAITING, state);
            }
        }
    }

    protected void method_66388(class_2680 state, class_3218 level, class_2338 pos, boolean isMoving) {
        super.method_66388(state, level, pos, isMoving);
        if (level.method_8321(pos) instanceof AdvQuarryEntity) {
            level.method_8455(pos, state.method_26204());
        }
    }

    @Override
    public void appendHoverText(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Experimental"));
    }

    @NotNull
    @VisibleForTesting
    static Area createDefaultArea(class_2338 pos, class_2350 quarryBehind, int limit) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        class_1923 chunkPos = new class_1923(pos);
        if (0 < limit && limit < 16) {
            if (pos.method_10263() - limit / 2 < chunkPos.method_8326()) {
                minX = chunkPos.method_8326();
                maxX = minX + limit - 1;
            } else if (pos.method_10263() + limit / 2 > chunkPos.method_8327()) {
                maxX = chunkPos.method_8327();
                minX = maxX - limit + 1;
            } else {
                minX = pos.method_10263() - limit / 2;
                maxX = minX + limit - 1;
            }
            if (pos.method_10260() - limit / 2 < chunkPos.method_8328()) {
                minZ = chunkPos.method_8328();
                maxZ = minZ + limit - 1;
            } else if (pos.method_10260() + limit / 2 > chunkPos.method_8329()) {
                maxZ = chunkPos.method_8329();
                minZ = maxZ - limit + 1;
            } else {
                minZ = pos.method_10260() - limit / 2;
                maxZ = minZ + limit - 1;
            }
        } else {
            minX = chunkPos.method_8326();
            maxX = chunkPos.method_8327();
            minZ = chunkPos.method_8328();
            maxZ = chunkPos.method_8329();
        }
        return new Area(minX - 1, pos.method_10264(), minZ - 1, maxX + 1, pos.method_10264() + 4, maxZ + 1, quarryBehind);
    }

    @Override
    protected boolean shouldCloneItemHasData() {
        return true;
    }
}

