/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record PowerMap(Quarry quarry, AdvQuarry advQuarry) {
    private static long getBreakEnergy(float hardness, int efficiency, int unbreaking, int fortune, boolean silktouch, double breakBlockBase, double breakFortuneCoefficient, double breakEfficiencyCoefficient, double breakSilktouchCoefficient) {
        if (Float.isNaN(hardness) || hardness == 0.0f) {
            return 0L;
        }
        if (hardness < 0.0f || Float.isInfinite(hardness)) {
            return (long)(200.0 * breakBlockBase * (double)(efficiency + 1) * 1.0E9);
        }
        double base = breakBlockBase * Math.pow(breakFortuneCoefficient, fortune) * Math.pow(breakSilktouchCoefficient, silktouch ? 1.0 : 0.0);
        double coefficient = (double)hardness * Math.pow(breakEfficiencyCoefficient, efficiency) / (double)(1 + Math.max(0, unbreaking));
        return (long)(coefficient * base * 1.0E9);
    }

    public record Quarry(double maxEnergy, double makeFrame, double breakBlockBase, double breakBlockFluid, double moveHeadBase, double expCollect, double efficiencyCoefficient, double breakEfficiencyCoefficient, double breakFortuneCoefficient, double breakSilktouchCoefficient) {
        public static final MapCodec<Quarry> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.DOUBLE.fieldOf("maxEnergy").forGetter(Quarry::maxEnergy), (App)Codec.DOUBLE.fieldOf("makeFrame").forGetter(Quarry::makeFrame), (App)Codec.DOUBLE.fieldOf("breakBlockBase").forGetter(Quarry::breakBlockBase), (App)Codec.DOUBLE.fieldOf("breakBlockFluid").forGetter(Quarry::breakBlockFluid), (App)Codec.DOUBLE.fieldOf("moveHeadBase").forGetter(Quarry::moveHeadBase), (App)Codec.DOUBLE.fieldOf("expCollect").forGetter(Quarry::expCollect), (App)Codec.DOUBLE.fieldOf("efficiencyCoefficient").forGetter(Quarry::efficiencyCoefficient), (App)Codec.DOUBLE.fieldOf("breakEfficiencyCoefficient").forGetter(Quarry::breakEfficiencyCoefficient), (App)Codec.DOUBLE.fieldOf("breakFortuneCoefficient").forGetter(Quarry::breakFortuneCoefficient), (App)Codec.DOUBLE.fieldOf("breakSilktouchCoefficient").forGetter(Quarry::breakSilktouchCoefficient)).apply((Applicative)i, Quarry::new));

        public long getBreakEnergy(float hardness, int efficiency, int unbreaking, int fortune, boolean silktouch) {
            return PowerMap.getBreakEnergy(hardness, efficiency, unbreaking, fortune, silktouch, this.breakBlockBase, this.breakFortuneCoefficient, this.breakEfficiencyCoefficient, this.breakSilktouchCoefficient);
        }
    }

    public record AdvQuarry(double maxEnergy, double makeFrame, double breakBlockBase, double breakBlockFluid, double searchBase, double expCollect, double breakEfficiencyCoefficient, double breakFortuneCoefficient, double breakSilktouchCoefficient) {
        public static final MapCodec<AdvQuarry> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.DOUBLE.fieldOf("maxEnergy").forGetter(AdvQuarry::maxEnergy), (App)Codec.DOUBLE.fieldOf("makeFrame").forGetter(AdvQuarry::makeFrame), (App)Codec.DOUBLE.fieldOf("breakBlockBase").forGetter(AdvQuarry::breakBlockBase), (App)Codec.DOUBLE.fieldOf("breakBlockFluid").forGetter(AdvQuarry::breakBlockFluid), (App)Codec.DOUBLE.fieldOf("searchBase").forGetter(AdvQuarry::searchBase), (App)Codec.DOUBLE.fieldOf("expCollect").forGetter(AdvQuarry::expCollect), (App)Codec.DOUBLE.fieldOf("breakEfficiencyCoefficient").forGetter(AdvQuarry::breakEfficiencyCoefficient), (App)Codec.DOUBLE.fieldOf("breakFortuneCoefficient").forGetter(AdvQuarry::breakFortuneCoefficient), (App)Codec.DOUBLE.fieldOf("breakSilktouchCoefficient").forGetter(AdvQuarry::breakSilktouchCoefficient)).apply((Applicative)i, AdvQuarry::new));

        public long getBreakEnergy(float hardness, int efficiency, int unbreaking, int fortune, boolean silktouch) {
            return PowerMap.getBreakEnergy(hardness, efficiency, unbreaking, fortune, silktouch, this.breakBlockBase, this.breakFortuneCoefficient, this.breakEfficiencyCoefficient, this.breakSilktouchCoefficient);
        }
    }

    public static interface Default {
        public static final Quarry QUARRY = new Quarry(10000.0, 15.0, 25.0, 125.0, 1.0, 2.5, 1.5848931924611136, 1.379729661461215, 1.5874010519681996, 4.0);
        public static final AdvQuarry ADV_QUARRY = new AdvQuarry(50000.0, 15.0, 30.0, 125.0, 1.25, 2.5, 1.379729661461215, 1.5874010519681996, 4.0);
    }
}

