/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.EnergyCounter;
import com.yogpc.qp.machine.QpEntity;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PowerEntity
extends QpEntity {
    public static final long ONE_FE = 1000000000L;
    protected final EnergyCounter energyCounter;
    private LongSupplier timeProvider;
    private long energy;
    private long maxEnergy;
    private final boolean noEnergy;

    protected PowerEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.energyCounter = EnergyCounter.createInstance(PlatformAccess.config().debug(), "%s(%d, %d, %d)".formatted(((Object)((Object)this)).getClass().getSimpleName(), pos.method_10263(), pos.method_10264(), pos.method_10260()));
        this.setTimeProvider(() -> Objects.requireNonNull(this.field_11863, "Level in block entity is null. Are you in test?\nMake sure to run `setTimeProvider` to replace the default time provider.").method_8510());
        this.noEnergy = PlatformAccess.config().noEnergy();
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71466("energy", this.energy);
        output.method_71466("maxEnergy", this.maxEnergy);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.energy = input.method_71425("energy", 0L);
        this.setMaxEnergy(input.method_71425("maxEnergy", 0L));
    }

    public final long getEnergy() {
        if (this.noEnergy) {
            return this.maxEnergy;
        }
        return this.energy;
    }

    public final long getMaxEnergy() {
        return this.maxEnergy;
    }

    protected final boolean hasEnoughEnergy() {
        return this.enabled && this.getEnergy() > 0L;
    }

    protected long getMaxReceive() {
        return this.maxEnergy;
    }

    protected final void setMaxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public abstract void updateMaxEnergyWithEnchantment(class_1937 var1);

    @VisibleForTesting
    public void setTimeProvider(LongSupplier timeProvider) {
        this.timeProvider = timeProvider;
    }

    public final long addEnergy(long amount, boolean simulate) {
        if (this.noEnergy) {
            return 0L;
        }
        long accepted = Math.min(Math.min(this.maxEnergy - this.energy, amount), this.getMaxReceive());
        if (!simulate && accepted >= 0L) {
            this.energy += accepted;
            this.energyCounter.getEnergy(this.timeProvider, accepted);
            this.method_5431();
        }
        return accepted;
    }

    public final long useEnergy(long amount, boolean simulate, boolean force, String reason) {
        long used;
        if (this.noEnergy) {
            this.energyCounter.useEnergy(this.timeProvider, amount, reason);
            return amount;
        }
        long l = used = force ? amount : Math.min(amount, this.energy);
        if (!simulate && used >= 0L) {
            this.energy -= used;
            this.energyCounter.useEnergy(this.timeProvider, used, reason);
            this.method_5431();
        }
        return used;
    }

    public final void setEnergy(long energy, boolean log) {
        if (this.noEnergy) {
            return;
        }
        if (this.energy > energy) {
            this.energyCounter.useEnergy(log ? this.timeProvider : () -> 1L, this.energy - energy, "FORCE_SET");
        } else {
            this.energyCounter.getEnergy(log ? this.timeProvider : () -> 1L, energy - this.energy);
        }
        this.method_5431();
        this.energy = energy;
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(PowerEntity.detail(class_124.field_1075, "Energy", "%d / %d".formatted(this.getEnergy() / 1000000000L, this.getMaxEnergy() / 1000000000L))));
    }

    public static class_5558<PowerEntity> logTicker() {
        return (w, p, s, blockEntity) -> blockEntity.energyCounter.logOutput(blockEntity.timeProvider.getAsLong());
    }
}

