/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorageFactory;
import com.yogpc.qp.machine.MachineStorageHolder;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public class MachineStorage {
    public static final int ONE_BUCKET = 81000;
    protected final Object2LongLinkedOpenHashMap<ItemKey> items = new Object2LongLinkedOpenHashMap();
    protected final Object2LongLinkedOpenHashMap<FluidKey> fluids = new Object2LongLinkedOpenHashMap();
    List<Runnable> onUpdate = new ArrayList<Runnable>();
    public static final MapCodec<ItemKey> ITEM_KEY_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(ItemKey::item, (String)"item", (Codec)class_7923.field_41178.method_39673()), (App)class_9326.field_49589.optionalFieldOf("patch", (Object)class_9326.field_49588).forGetter(ItemKey::patch)).apply((Applicative)i, ItemKey::new));
    static final MapCodec<ItemKeyCount> ITEM_KEY_COUNT_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(ItemKeyCount::key, ITEM_KEY_MAP_CODEC), (App)RecordCodecBuilder.of(ItemKeyCount::count, (String)"count", (Codec)Codec.LONG)).apply((Applicative)i, ItemKeyCount::new));
    static final MapCodec<FluidKeyCount> FLUID_KEY_COUNT_MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(c -> c.key.fluid, (String)"fluid", (Codec)class_7923.field_41173.method_39673()), (App)class_9326.field_49589.optionalFieldOf("patch", (Object)class_9326.field_49588).forGetter(c -> c.key.patch), (App)RecordCodecBuilder.of(FluidKeyCount::count, (String)"count", (Codec)Codec.LONG)).apply((Applicative)i, (a, b, c) -> new FluidKeyCount(new FluidKey((class_3611)a, (class_9326)b), (long)c)));
    public static final MapCodec<MachineStorage> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(MachineStorage::itemKeyCounts, (String)"items", (Codec)ITEM_KEY_COUNT_MAP_CODEC.codec().listOf()), (App)RecordCodecBuilder.of(MachineStorage::fluidKeyCounts, (String)"fluids", (Codec)FLUID_KEY_COUNT_MAP_CODEC.codec().listOf())).apply((Applicative)i, (itemKeyCounts, fluidKeyCounts) -> MachineStorage.of(ItemKeyCount.list2Map(itemKeyCounts), FluidKeyCount.list2Map(fluidKeyCounts))));
    private static final int MAX_TRANSFER = 4;

    public static MachineStorage of() {
        MachineStorageFactory factory = ServiceLoader.load(MachineStorageFactory.class, MachineStorageFactory.class.getClassLoader()).findFirst().orElseThrow(() -> new IllegalStateException("Could not find Machine Storage implementation"));
        return factory.createMachineStorage();
    }

    static MachineStorage of(Map<ItemKey, Long> items, Map<FluidKey, Long> fluids) {
        MachineStorage storage = MachineStorage.of();
        storage.items.putAll(items);
        storage.fluids.putAll(fluids);
        return storage;
    }

    protected MachineStorage() {
        this.items.defaultReturnValue(0L);
        this.fluids.defaultReturnValue(0L);
    }

    public void onUpdate(Runnable runnable) {
        this.onUpdate.add(runnable);
    }

    protected void notifyUpdate() {
        this.onUpdate.forEach(Runnable::run);
    }

    public void addItem(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        ItemKey key = ItemKey.of(stack);
        this.items.addTo((Object)key, (long)stack.method_7947());
        this.notifyUpdate();
    }

    public void addFluid(class_3611 fluid, long amount) {
        if (fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidKey key = new FluidKey(fluid, class_9326.field_49588);
        this.fluids.addTo((Object)key, amount);
        this.notifyUpdate();
    }

    public void addBucketFluid(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        FluidStackLike content = PlatformAccess.getAccess().getFluidInItem(stack);
        if (content.fluid().method_15780(class_3612.field_15906)) {
            return;
        }
        FluidKey key = new FluidKey(content.fluid(), content.patch());
        this.fluids.addTo((Object)key, content.amount());
        this.notifyUpdate();
    }

    long getItemCount(ItemKey key) {
        return this.items.getLong((Object)key);
    }

    public long getItemCount(class_1792 item, class_9326 patch) {
        return this.getItemCount(new ItemKey(item, patch));
    }

    long getFluidCount(FluidKey key) {
        return this.fluids.getLong((Object)key);
    }

    public long getFluidCount(class_3611 fluid) {
        return this.getFluidCount(new FluidKey(fluid, class_9326.field_49588));
    }

    public String toString() {
        long itemSize = this.items.values().longStream().filter(t -> t != 0L).count();
        long fluidSize = this.fluids.values().longStream().filter(t -> t != 0L).count();
        return "MachineStorage{items=" + itemSize + ", fluids=" + fluidSize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineStorage that = (MachineStorage)o;
        return Objects.equals(this.items, that.items) && Objects.equals(this.fluids, that.fluids);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.fluids);
    }

    public List<ItemKeyCount> itemKeyCounts() {
        return this.items.object2LongEntrySet().stream().map(e -> new ItemKeyCount((ItemKey)e.getKey(), e.getLongValue())).toList();
    }

    public List<FluidKeyCount> fluidKeyCounts() {
        return this.fluids.object2LongEntrySet().stream().map(e -> new FluidKeyCount((FluidKey)e.getKey(), e.getLongValue())).toList();
    }

    public void passItems(class_1937 level, class_2338 storagePos) {
        class_2350[] directions;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int count = 0;
        block0: for (class_2350 direction : directions = new class_2350[]{class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036}) {
            class_2338.class_2339 pos = mutablePos.method_25505((class_2382)storagePos, direction);
            class_2680 state = level.method_8320((class_2338)pos);
            if (MachineStorage.cantBeStorage(state)) continue;
            ObjectBidirectionalIterator itr = this.items.object2LongEntrySet().fastIterator();
            while (itr.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)itr.next();
                class_1799 stack = ((ItemKey)entry.getKey()).toStack(Math.clamp(entry.getLongValue(), 0, Integer.MAX_VALUE));
                class_1799 rest = PlatformAccess.getAccess().transfer().transferItem(level, (class_2338)pos, stack, direction.method_10153(), false);
                if (rest.method_7947() == stack.method_7947()) continue;
                if (rest.method_7960() && (long)stack.method_7947() == entry.getLongValue()) {
                    itr.remove();
                } else {
                    entry.setValue(entry.getLongValue() - (long)stack.method_7947() + (long)rest.method_7947());
                }
                if (count++ <= 4) continue;
                break block0;
            }
        }
        if (count > 0) {
            this.notifyUpdate();
        }
    }

    public void passFluids(class_1937 level, class_2338 storagePos) {
        class_2350[] directions;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int count = 0;
        block0: for (class_2350 direction : directions = new class_2350[]{class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036}) {
            class_2338.class_2339 pos = mutablePos.method_25505((class_2382)storagePos, direction);
            class_2680 state = level.method_8320((class_2338)pos);
            if (MachineStorage.cantBeStorage(state)) continue;
            ObjectBidirectionalIterator itr = this.fluids.object2LongEntrySet().fastIterator();
            while (itr.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)itr.next();
                FluidStackLike stack = ((FluidKey)entry.getKey()).toStack(Math.clamp(entry.getLongValue(), 0, Integer.MAX_VALUE));
                FluidStackLike rest = PlatformAccess.getAccess().transfer().transferFluid(level, (class_2338)pos, stack, direction.method_10153(), false);
                if (rest.amount() == stack.amount()) continue;
                if (rest.isEmpty() && stack.amount() == entry.getLongValue()) {
                    itr.remove();
                } else {
                    entry.setValue(entry.getLongValue() - stack.amount() + rest.amount());
                }
                if (count++ <= 4) continue;
                break block0;
            }
        }
        if (count > 0) {
            this.notifyUpdate();
        }
    }

    private static boolean cantBeStorage(class_2680 state) {
        return state.method_26215() || state.method_27852((class_2248)PlatformAccess.getAccess().registerObjects().frameBlock().get()) || state.method_27852((class_2248)PlatformAccess.getAccess().registerObjects().generatorBlock().get());
    }

    public int fluidTanks() {
        return this.fluids.size();
    }

    public FluidStackLike getFluidByIndex(int i) {
        if (i < 0 || i >= this.fluids.size()) {
            return FluidStackLike.EMPTY;
        }
        Object2LongMap.Entry e = (Object2LongMap.Entry)Iterators.get((Iterator)this.fluids.object2LongEntrySet().iterator(), (int)i);
        return new FluidStackLike(((FluidKey)e.getKey()).fluid(), e.getLongValue(), ((FluidKey)e.getKey()).patch());
    }

    public FluidStackLike drainFluid(FluidStackLike toDrain, boolean execute) {
        FluidKey key = new FluidKey(toDrain.fluid(), toDrain.patch());
        long amount = this.fluids.getLong((Object)key);
        long toDrainAmount = Math.min(amount, toDrain.amount());
        if (execute) {
            if (amount - toDrainAmount > 0L) {
                this.fluids.put((Object)key, amount - toDrainAmount);
            } else {
                this.fluids.removeLong((Object)key);
            }
            this.notifyUpdate();
        }
        return toDrain.withAmount(toDrainAmount);
    }

    public FluidStackLike drainFluidByIndex(int index, long amount, boolean execute) {
        FluidStackLike fluid = this.getFluidByIndex(index);
        if (fluid.isEmpty()) {
            return FluidStackLike.EMPTY;
        }
        return this.drainFluid(fluid.withAmount(amount), execute);
    }

    public int itemSlots() {
        return this.items.size();
    }

    public class_1799 getItemByIndex(int i) {
        if (i < 0 || i >= this.items.size()) {
            return class_1799.field_8037;
        }
        Object2LongMap.Entry e = (Object2LongMap.Entry)Iterators.get((Iterator)this.items.object2LongEntrySet().iterator(), (int)i);
        return ((ItemKey)e.getKey()).toStack(Math.clamp(e.getLongValue(), 0, Integer.MAX_VALUE));
    }

    public class_1799 extractItemByIndex(int i, int amount, boolean execute) {
        if (i < 0 || i >= this.items.size()) {
            return class_1799.field_8037;
        }
        Object2LongMap.Entry e = (Object2LongMap.Entry)Iterators.get((Iterator)this.items.object2LongEntrySet().iterator(), (int)i);
        long toExtractAmount = Math.min((long)amount, e.getLongValue());
        if (execute) {
            if ((long)amount - toExtractAmount > 0L) {
                this.items.put((Object)((ItemKey)e.getKey()), (long)amount - toExtractAmount);
            } else {
                this.items.removeLong(e.getKey());
            }
            this.notifyUpdate();
        }
        return ((ItemKey)e.getKey()).toStack(Math.clamp(toExtractAmount, 0, Integer.MAX_VALUE));
    }

    public static <T extends class_2586> class_5558<T> pushItemTicker() {
        return (level, blockPos, blockState, blockEntity) -> MachineStorageHolder.getHolder(blockEntity).ifPresent(h -> h.getMachineStorage(blockEntity).passItems(level, blockPos));
    }

    public static <T extends class_2586> class_5558<T> pushFluidTicker() {
        return (level, blockPos, blockState, blockEntity) -> MachineStorageHolder.getHolder(blockEntity).ifPresent(h -> h.getMachineStorage(blockEntity).passFluids(level, blockPos));
    }

    public record ItemKey(class_1792 item, class_9326 patch) {
        public static ItemKey of(class_1799 stack) {
            return new ItemKey(stack.method_7909(), stack.method_57380());
        }

        public class_1799 toStack(int count) {
            return new class_1799(class_6880.method_40223((Object)this.item), count, this.patch);
        }
    }

    public record FluidKey(class_3611 fluid, class_9326 patch) {
        public FluidStackLike toStack(int amount) {
            return new FluidStackLike(this.fluid, amount, this.patch);
        }
    }

    public record ItemKeyCount(ItemKey key, long count) {
        static Map<ItemKey, Long> list2Map(List<ItemKeyCount> list) {
            return list.stream().collect(Collectors.toMap(ItemKeyCount::key, ItemKeyCount::count));
        }
    }

    public record FluidKeyCount(FluidKey key, long count) {
        static Map<FluidKey, Long> list2Map(List<FluidKeyCount> list) {
            return list.stream().collect(Collectors.toMap(FluidKeyCount::key, FluidKeyCount::count));
        }
    }
}

