/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record ItemConverter(List<Conversion> conversions) {
    public static ItemConverter defaultInstance() {
        List<Conversion> conversions = PlatformAccess.config().convertDeepslateOres() ? List.of(new DeepslateOreConversion()) : List.of();
        return new ItemConverter(conversions);
    }

    public Stream<class_1799> convert(class_1799 stack) {
        return this.conversions.stream().filter(conversion -> conversion.shouldApply(stack)).findAny().map(f -> f.convert(stack)).orElseGet(() -> Stream.of(stack));
    }

    public ItemConverter concat(List<Conversion> others) {
        ArrayList<Conversion> list = new ArrayList<Conversion>(this.conversions);
        list.addAll(others);
        return new ItemConverter(list);
    }

    public static class DeepslateOreConversion
    implements Conversion {
        @Override
        public Stream<class_1799> convert(class_1799 stack) {
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            class_2960 newId = id.method_45134(s -> s.replace("deepslate_", "").replace("_deepslate", ""));
            return class_7923.field_41178.method_10223(newId).map(h -> new class_1799((class_6880)h, stack.method_7947(), stack.method_57380())).map(Stream::of).orElseGet(() -> Stream.of(stack));
        }

        @Override
        public boolean shouldApply(class_1799 stack) {
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            return id.method_12832().contains("deepslate") && id.method_12832().contains("ore");
        }
    }

    public static interface Conversion {
        public Stream<class_1799> convert(class_1799 var1);

        public boolean shouldApply(class_1799 var1);
    }

    public record ToEmptyConverter(Collection<MachineStorage.ItemKey> itemKeys) implements Conversion
    {
        @Override
        public Stream<class_1799> convert(class_1799 stack) {
            return Stream.empty();
        }

        @Override
        public boolean shouldApply(class_1799 stack) {
            MachineStorage.ItemKey key = MachineStorage.ItemKey.of(stack);
            return this.itemKeys.contains(key);
        }
    }

    public static class ChunkDestroyerConversion
    implements Conversion {
        @Override
        public Stream<class_1799> convert(class_1799 stack) {
            return Stream.empty();
        }

        @Override
        public boolean shouldApply(class_1799 stack) {
            if (stack.method_31573(class_3489.field_36269) || stack.method_31574(class_1802.field_20412) || stack.method_31574(class_1802.field_20384) || stack.method_31574(class_1802.field_20408)) {
                return true;
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2680 state = blockItem.method_7711().method_9564();
                return state.method_26164(class_3481.field_25806) || state.method_26164(class_3481.field_25807);
            }
            return false;
        }
    }
}

