/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.machine.PickIterator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public record Area(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2350 direction) {
    public static final MapCodec<Area> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.fieldOf("minX").forGetter(Area::minX), (App)Codec.INT.fieldOf("minY").forGetter(Area::minY), (App)Codec.INT.fieldOf("minZ").forGetter(Area::minZ), (App)Codec.INT.fieldOf("maxX").forGetter(Area::maxX), (App)Codec.INT.fieldOf("maxY").forGetter(Area::maxY), (App)Codec.INT.fieldOf("maxZ").forGetter(Area::maxZ), (App)class_2350.field_29502.fieldOf("direction").forGetter(Area::direction)).apply((Applicative)i, Area::new));

    public Area {
        if (minX > maxX) {
            throw new IllegalArgumentException("MinX(%d) must be less than or equal to MaxX(%d)".formatted(minX, maxX));
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("MinY(%d) must be less than or equal to MaxY(%d)".formatted(minY, maxY));
        }
        if (minZ > maxZ) {
            throw new IllegalArgumentException("MinZ(%d) must be less than or equal to MaxZ(%d)".formatted(minZ, maxZ));
        }
    }

    public Area(class_2382 pos1, class_2382 pos2, class_2350 direction) {
        this(Math.min(pos1.method_10263(), pos2.method_10263()), Math.min(pos1.method_10264(), pos2.method_10264()), Math.min(pos1.method_10260(), pos2.method_10260()), Math.max(pos1.method_10263(), pos2.method_10263()), Math.max(pos1.method_10264(), pos2.method_10264()), Math.max(pos1.method_10260(), pos2.method_10260()), direction);
    }

    public static Area assumeY(Area area) {
        int distanceY = area.maxY() - area.minY();
        if (distanceY >= 4) {
            return area;
        }
        return new Area(area.minX(), area.minY(), area.minZ(), area.maxX(), area.minY() + 4, area.maxZ(), area.direction());
    }

    public boolean inAreaX(int x) {
        return this.minX < x && x < this.maxX;
    }

    public boolean inAreaZ(int z) {
        return this.minZ < z && z < this.maxZ;
    }

    public boolean inAreaXZ(class_2382 pos) {
        return this.inAreaX(pos.method_10263()) && this.inAreaZ(pos.method_10260());
    }

    public boolean isEdge(class_2382 pos) {
        boolean zCondition;
        boolean xCondition = pos.method_10263() == this.minX || pos.method_10263() == this.maxX;
        boolean bl = zCondition = pos.method_10260() == this.minZ || pos.method_10260() == this.maxZ;
        if (xCondition && zCondition) {
            return true;
        }
        return xCondition && this.inAreaZ(pos.method_10260()) || zCondition && this.inAreaX(pos.method_10263());
    }

    @VisibleForTesting
    public Area shrink(int x, int y, int z) {
        int x1 = this.minX + x;
        int x2 = this.maxX - x;
        int y1 = this.minY + y;
        int y2 = this.maxY - y;
        int z1 = this.minZ + z;
        int z2 = this.maxZ - z;
        return new Area(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2), this.direction);
    }

    public Set<class_2338> getChainBlocks(class_2338 start, Predicate<class_2338> filter, int maxY) {
        HashSet<class_2338> counted = new HashSet<class_2338>((this.maxX - this.minX) * (this.maxZ - this.minZ));
        EnumSet<class_2350> directions = EnumSet.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036);
        Set<class_2338> search = Set.of(start);
        HashSet<class_2338> checked = new HashSet<class_2338>((this.maxX - this.minX) * (this.maxZ - this.minZ));
        while (!search.isEmpty()) {
            HashSet<class_2338> nextSearch = new HashSet<class_2338>();
            for (class_2338 pos : search) {
                checked.add(pos);
                if (!filter.test(pos) || !counted.add(pos)) continue;
                directions.stream().map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).filter(this::inAreaXZ).filter(p -> p.method_10264() <= maxY).filter(Predicate.not(checked::contains)).forEach(nextSearch::add);
            }
            search = nextSearch;
        }
        return counted;
    }

    public Set<class_2338> getEdgeForPos(class_2338 pos) {
        boolean zCondition;
        boolean xCondition = pos.method_10263() == this.minX + 1 || pos.method_10263() == this.maxX - 1;
        boolean bl = zCondition = pos.method_10260() == this.minZ + 1 || pos.method_10260() == this.maxZ - 1;
        if (!xCondition && !zCondition) {
            return Set.of();
        }
        return Stream.of(pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, 1), pos.method_10069(-1, 0, 1), pos.method_10069(-1, 0, -1), pos.method_10069(1, 0, -1)).filter(this::isEdge).collect(Collectors.toSet());
    }

    public PickIterator<class_2338> quarryFramePosIterator() {
        return new QuarryFramePosIterator(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public PickIterator<class_2338> quarryDigPosIterator(int y) {
        if (this.maxX - this.minX < 2 || this.maxZ - this.minZ < 2) {
            return PickIterator.empty();
        }
        return new QuarryDigPosIterator(this, y);
    }

    static class QuarryFramePosIterator
    extends PickIterator<class_2338> {
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int maxX;
        private final int maxY;
        private final int maxZ;

        public QuarryFramePosIterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        @Override
        @NotNull
        protected class_2338 update() {
            if (this.lastReturned == null) {
                return new class_2338(this.minX, this.minY, this.minZ);
            }
            if (((class_2338)this.lastReturned).method_10264() == this.minY || ((class_2338)this.lastReturned).method_10264() == this.maxY) {
                if (((class_2338)this.lastReturned).method_10260() == this.minZ && ((class_2338)this.lastReturned).method_10263() < this.maxX) {
                    return ((class_2338)this.lastReturned).method_10069(1, 0, 0);
                }
                if (((class_2338)this.lastReturned).method_10263() == this.maxX && ((class_2338)this.lastReturned).method_10260() < this.maxZ) {
                    return ((class_2338)this.lastReturned).method_10069(0, 0, 1);
                }
                if (((class_2338)this.lastReturned).method_10260() == this.maxZ && ((class_2338)this.lastReturned).method_10263() > this.minX && ((class_2338)this.lastReturned).method_10260() != this.minZ) {
                    return ((class_2338)this.lastReturned).method_10069(-1, 0, 0);
                }
                if (((class_2338)this.lastReturned).method_10263() == this.minX && ((class_2338)this.lastReturned).method_10260() > this.minZ + 1 && ((class_2338)this.lastReturned).method_10263() != this.maxX) {
                    return ((class_2338)this.lastReturned).method_10069(0, 0, -1);
                }
                if (((class_2338)this.lastReturned).method_10264() == this.minY) {
                    return new class_2338(this.minX, this.minY + 1, this.minZ);
                }
                if (((class_2338)this.lastReturned).method_10264() == this.maxY) {
                    throw new NoSuchElementException("Iterator end: " + String.valueOf(this.lastReturned));
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf(this.lastReturned));
            }
            if (this.minY < ((class_2338)this.lastReturned).method_10264() && ((class_2338)this.lastReturned).method_10264() < this.maxY) {
                if (this.minX == this.maxX && this.minZ == this.maxZ) {
                    return new class_2338(this.minX, ((class_2338)this.lastReturned).method_10264() + 1, this.maxZ);
                }
                if (this.minX == this.maxX) {
                    if (((class_2338)this.lastReturned).method_10260() == this.minZ) {
                        return new class_2338(this.minX, ((class_2338)this.lastReturned).method_10264(), this.maxZ);
                    }
                    return new class_2338(this.minX, ((class_2338)this.lastReturned).method_10264() + 1, this.minZ);
                }
                if (this.minZ == this.maxZ) {
                    if (((class_2338)this.lastReturned).method_10263() == this.minX) {
                        return new class_2338(this.maxX, ((class_2338)this.lastReturned).method_10264(), this.minZ);
                    }
                    return new class_2338(this.minX, ((class_2338)this.lastReturned).method_10264() + 1, this.minZ);
                }
                if (((class_2338)this.lastReturned).method_10263() == this.minX && ((class_2338)this.lastReturned).method_10260() == this.minZ) {
                    return new class_2338(this.maxX, ((class_2338)this.lastReturned).method_10264(), this.minZ);
                }
                if (((class_2338)this.lastReturned).method_10263() == this.maxX && ((class_2338)this.lastReturned).method_10260() == this.minZ) {
                    return new class_2338(this.maxX, ((class_2338)this.lastReturned).method_10264(), this.maxZ);
                }
                if (((class_2338)this.lastReturned).method_10263() == this.maxX && ((class_2338)this.lastReturned).method_10260() == this.maxZ) {
                    return new class_2338(this.minX, ((class_2338)this.lastReturned).method_10264(), this.maxZ);
                }
                if (((class_2338)this.lastReturned).method_10263() == this.minX && ((class_2338)this.lastReturned).method_10260() == this.maxZ) {
                    return new class_2338(this.minX, ((class_2338)this.lastReturned).method_10264() + 1, this.minZ);
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf(this.lastReturned));
        }

        @Override
        public boolean hasNext() {
            if (this.lastReturned == null) {
                return true;
            }
            if (this.minX == this.maxX) {
                return ((class_2338)this.lastReturned).method_10260() != this.maxZ || ((class_2338)this.lastReturned).method_10264() != this.maxY;
            }
            if (this.minZ == this.maxZ) {
                return ((class_2338)this.lastReturned).method_10263() != this.maxX || ((class_2338)this.lastReturned).method_10264() != this.maxY;
            }
            return ((class_2338)this.lastReturned).method_10263() != this.minX || ((class_2338)this.lastReturned).method_10264() != this.maxY || ((class_2338)this.lastReturned).method_10260() != this.minZ + 1;
        }
    }

    static class QuarryDigPosIterator
    extends PickIterator<class_2338> {
        private final Area area;
        private final int y;

        QuarryDigPosIterator(Area area, int y) {
            this.area = area;
            this.y = y;
        }

        @Override
        protected class_2338 update() {
            int nextX;
            int nextZ;
            if (this.lastReturned == null) {
                int x = this.y % 2 == 0 ? this.area.minX() + 1 : this.area.maxX() - 1;
                int z = QuarryDigPosIterator.initZ(x, this.y, this.area.minZ, this.area.maxZ);
                return new class_2338(x, this.y, z);
            }
            int n = nextZ = ((class_2338)this.lastReturned).method_10263() % 2 == 0 ^ this.y % 2 == 0 ? ((class_2338)this.lastReturned).method_10260() + 1 : ((class_2338)this.lastReturned).method_10260() - 1;
            if (this.area.inAreaZ(nextZ)) {
                return new class_2338(((class_2338)this.lastReturned).method_10263(), this.y, nextZ);
            }
            int n2 = nextX = this.y % 2 == 0 ? ((class_2338)this.lastReturned).method_10263() + 1 : ((class_2338)this.lastReturned).method_10263() - 1;
            if (this.area.inAreaX(nextX)) {
                return new class_2338(nextX, this.y, QuarryDigPosIterator.initZ(nextX, this.y, this.area.minZ, this.area.maxZ));
            }
            throw new NoSuchElementException("Iterator end: " + String.valueOf(this.lastReturned));
        }

        @Override
        public boolean hasNext() {
            if (this.lastReturned == null) {
                return true;
            }
            int endX = this.y % 2 == 0 ? this.area.maxX() - 1 : this.area.minX() + 1;
            int endZ = ((class_2338)this.lastReturned).method_10263() % 2 == 0 ^ this.y % 2 == 0 ? this.area.maxZ() - 1 : this.area.minZ() + 1;
            return ((class_2338)this.lastReturned).method_10263() != endX || ((class_2338)this.lastReturned).method_10260() != endZ;
        }

        static int initZ(int x, int y, int minZ, int maxZ) {
            return x % 2 == 0 ^ y % 2 == 0 ? minZ + 1 : maxZ - 1;
        }
    }
}

