/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.fabric.machine.quarry;

import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.fabric.PlatformAccessFabric;
import com.yogpc.qp.machine.exp.ExpModule;
import com.yogpc.qp.machine.quarry.QuarryEntity;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public final class QuarryEntityFabric
extends QuarryEntity
implements ExpModule {
    boolean shouldRemoveFluid = true;
    boolean shouldRemoveBedrock = false;
    int collectedExp = 0;

    public QuarryEntityFabric(class_2338 pos, class_2680 blockState) {
        super(PlatformAccessFabric.RegisterObjectsFabric.QUARRY_ENTITY_TYPE, pos, blockState);
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71465("collectedExp", this.collectedExp);
    }

    @Override
    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.collectedExp = input.method_71424("collectedExp", this.collectedExp);
    }

    @Override
    public class_11372 toClientTag(class_11372 output) {
        output.method_71472("shouldRemoveFluid", this.shouldRemoveFluid);
        output.method_71472("shouldRemoveBedrock", this.shouldRemoveBedrock);
        return super.toClientTag(output);
    }

    @Override
    public void fromClientTag(class_11368 input) {
        super.fromClientTag(input);
        this.shouldRemoveFluid = input.method_71433("shouldRemoveFluid", this.shouldRemoveFluid);
        this.shouldRemoveBedrock = input.method_71433("shouldRemoveBedrock", this.shouldRemoveBedrock);
    }

    protected void method_57568(class_9473 dataComponentGetter) {
        super.method_57568(dataComponentGetter);
        this.shouldRemoveBedrock = (Boolean)dataComponentGetter.method_58695(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)Boolean.FALSE);
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        if (this.shouldRemoveBedrock) {
            components.method_57840(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)true);
        }
    }

    @Override
    protected boolean shouldRemoveFluid() {
        return this.shouldRemoveFluid;
    }

    @Override
    protected boolean shouldRemoveBedrock() {
        return this.shouldRemoveBedrock;
    }

    @Override
    protected boolean shouldCollectExp() {
        return true;
    }

    @Override
    @NotNull
    protected Optional<ExpModule> getExpModule() {
        return Optional.of(this);
    }

    @Override
    protected class_2680 stateAfterBreak(class_1937 level, class_2338 pos, class_2680 before) {
        return class_2246.field_10124.method_9564();
    }

    @Override
    public void addExp(int amount) {
        this.collectedExp += amount;
    }

    @Override
    public int getExp() {
        return this.collectedExp;
    }

    @Override
    public Stream<class_5250> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(QuarryEntityFabric.detail(class_124.field_1060, "ShouldRemoveFluid", String.valueOf(this.shouldRemoveFluid())), QuarryEntityFabric.detail(class_124.field_1060, "ShouldRemoveBedrock", String.valueOf(this.shouldRemoveBedrock()))));
    }
}

