/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.fabric.machine;

import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.MachineStorageFactory;
import com.yogpc.qp.machine.MachineStorageHolder;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;

public final class MachineStorageFabric
extends MachineStorage {
    static MachineStorage.ItemKey fromItemVariant(ItemVariant variant) {
        return new MachineStorage.ItemKey(variant.getItem(), variant.getComponents());
    }

    static MachineStorage.FluidKey fromFluidVariant(FluidVariant variant) {
        return new MachineStorage.FluidKey(variant.getFluid(), variant.getComponents());
    }

    public static final class FluidStorageImpl<T>
    extends SnapshotParticipant<Object2LongLinkedOpenHashMap<MachineStorage.FluidKey>>
    implements Storage<FluidVariant> {
        private final MachineStorageHolder<T> holder;
        private final T instance;

        public FluidStorageImpl(MachineStorageHolder<T> holder, T instance) {
            this.holder = holder;
            this.instance = instance;
        }

        private MachineStorageFabric storage() {
            return (MachineStorageFabric)this.holder.getMachineStorage(this.instance);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.isBlank() || maxAmount <= 0L) {
                return 0L;
            }
            this.updateSnapshots(transaction);
            this.storage().fluids.addTo((Object)MachineStorageFabric.fromFluidVariant(resource), maxAmount);
            return maxAmount;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.isBlank() || maxAmount <= 0L) {
                return 0L;
            }
            MachineStorage.FluidKey key = MachineStorageFabric.fromFluidVariant(resource);
            long contains = this.storage().fluids.getLong((Object)key);
            long toExtract = Math.min(maxAmount, contains);
            if (toExtract <= 0L) {
                return 0L;
            }
            this.updateSnapshots(transaction);
            if (contains <= toExtract) {
                this.storage().fluids.removeLong((Object)key);
            } else {
                this.storage().fluids.put((Object)key, contains - toExtract);
            }
            return toExtract;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return Collections.emptyIterator();
        }

        protected Object2LongLinkedOpenHashMap<MachineStorage.FluidKey> createSnapshot() {
            return this.storage().fluids.clone();
        }

        protected void readSnapshot(Object2LongLinkedOpenHashMap<MachineStorage.FluidKey> snapshot) {
            this.storage().fluids.clear();
            this.storage().fluids.putAll(snapshot);
        }
    }

    public static final class ItemStorageImpl<T>
    extends SnapshotParticipant<Object2LongLinkedOpenHashMap<MachineStorage.ItemKey>>
    implements Storage<ItemVariant> {
        private final MachineStorageHolder<T> holder;
        private final T instance;

        public ItemStorageImpl(MachineStorageHolder<T> holder, T instance) {
            this.holder = holder;
            this.instance = instance;
        }

        private MachineStorageFabric storage() {
            return (MachineStorageFabric)this.holder.getMachineStorage(this.instance);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.isBlank() || maxAmount <= 0L) {
                return 0L;
            }
            this.updateSnapshots(transaction);
            this.storage().items.addTo((Object)MachineStorageFabric.fromItemVariant(resource), maxAmount);
            return maxAmount;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.isBlank() || maxAmount <= 0L) {
                return 0L;
            }
            MachineStorage.ItemKey key = MachineStorageFabric.fromItemVariant(resource);
            long contains = this.storage().items.getLong((Object)key);
            long toExtract = Math.min(maxAmount, contains);
            if (toExtract <= 0L) {
                return 0L;
            }
            this.updateSnapshots(transaction);
            if (contains <= toExtract) {
                this.storage().items.removeLong((Object)key);
            } else {
                this.storage().items.put((Object)key, contains - toExtract);
            }
            return toExtract;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            return Collections.emptyIterator();
        }

        protected Object2LongLinkedOpenHashMap<MachineStorage.ItemKey> createSnapshot() {
            return this.storage().items.clone();
        }

        protected void readSnapshot(Object2LongLinkedOpenHashMap<MachineStorage.ItemKey> snapshot) {
            this.storage().items.clear();
            this.storage().items.putAll(snapshot);
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            this.storage().notifyUpdate();
        }
    }

    public static class Factory
    implements MachineStorageFactory {
        @Override
        public MachineStorage createMachineStorage() {
            return new MachineStorageFabric();
        }
    }
}

