/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.fabric.integration;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.config.QuarryConfig;
import com.yogpc.qp.machine.PowerEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

final class RebornEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public final long conversionRate;
    private final PowerEntity powerEntity;

    @Nullable
    static EnergyStorage provider(Object blockEntity, class_2350 ignored) {
        if (blockEntity instanceof PowerEntity) {
            PowerEntity entity = (PowerEntity)((Object)blockEntity);
            return new RebornEnergyStorage(entity, PlatformAccess.config());
        }
        return null;
    }

    RebornEnergyStorage(PowerEntity powerEntity, QuarryConfig config) {
        this.powerEntity = powerEntity;
        this.conversionRate = (long)(1.0E9 * config.rebornEnergyConversionCoefficient());
    }

    protected Long createSnapshot() {
        return this.powerEntity.getEnergy();
    }

    protected void readSnapshot(Long snapshot) {
        this.powerEntity.setEnergy(snapshot, false);
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long insertSimulate = Math.min(maxAmount, this.getCapacity() - this.getAmount());
        if (insertSimulate <= 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        long accepted = this.powerEntity.addEnergy(maxAmount * this.conversionRate, false);
        return accepted / this.conversionRate;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long getAmount() {
        return this.powerEntity.getEnergy() / this.conversionRate;
    }

    public long getCapacity() {
        return this.powerEntity.getMaxEnergy() / this.conversionRate;
    }
}

