/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.fabric;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.InCreativeTabs;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.config.ConfigHolder;
import com.yogpc.qp.config.EnableMap;
import com.yogpc.qp.config.QuarryConfig;
import com.yogpc.qp.fabric.ExtendedGeneralScreenHandler;
import com.yogpc.qp.fabric.MiningFabric;
import com.yogpc.qp.fabric.TransferFabric;
import com.yogpc.qp.fabric.machine.advquarry.AdvQuarryBlockFabric;
import com.yogpc.qp.fabric.machine.advquarry.AdvQuarryEntityFabric;
import com.yogpc.qp.fabric.machine.misc.CheckerItemFabric;
import com.yogpc.qp.fabric.machine.misc.YSetterItemFabric;
import com.yogpc.qp.fabric.machine.quarry.QuarryBlockFabric;
import com.yogpc.qp.fabric.machine.quarry.QuarryEntityFabric;
import com.yogpc.qp.fabric.machine.quarry.QuarryMenuFabric;
import com.yogpc.qp.fabric.packet.PacketHandler;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineLootFunction;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpItem;
import com.yogpc.qp.machine.advquarry.AdvQuarryBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.exp.ExpModuleItem;
import com.yogpc.qp.machine.marker.ChunkMarkerBlock;
import com.yogpc.qp.machine.marker.ChunkMarkerEntity;
import com.yogpc.qp.machine.marker.FlexibleMarkerBlock;
import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.machine.marker.MarkerContainer;
import com.yogpc.qp.machine.marker.NormalMarkerBlock;
import com.yogpc.qp.machine.marker.NormalMarkerEntity;
import com.yogpc.qp.machine.misc.FrameBlock;
import com.yogpc.qp.machine.misc.GeneratorBlock;
import com.yogpc.qp.machine.misc.GeneratorEntity;
import com.yogpc.qp.machine.misc.SoftBlock;
import com.yogpc.qp.machine.misc.YSetterContainer;
import com.yogpc.qp.machine.module.BedrockModuleItem;
import com.yogpc.qp.machine.module.FilterModuleContainer;
import com.yogpc.qp.machine.module.FilterModuleItem;
import com.yogpc.qp.machine.module.ModuleContainer;
import com.yogpc.qp.machine.module.PumpModuleItem;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.machine.mover.MoverBlock;
import com.yogpc.qp.machine.mover.MoverContainer;
import com.yogpc.qp.machine.mover.MoverEntity;
import com.yogpc.qp.machine.placer.PlacerBlock;
import com.yogpc.qp.machine.placer.PlacerContainer;
import com.yogpc.qp.machine.placer.PlacerEntity;
import com.yogpc.qp.machine.placer.RemotePlacerBlock;
import com.yogpc.qp.machine.placer.RemotePlacerEntity;
import com.yogpc.qp.machine.quarry.QuarryBlock;
import com.yogpc.qp.machine.storage.DebugStorageBlock;
import com.yogpc.qp.machine.storage.DebugStorageContainer;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import com.yogpc.qp.recipe.FilterModuleExpandRecipe;
import com.yogpc.qp.recipe.InstallBedrockModuleRecipe;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_5339;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Lazy;

public final class PlatformAccessFabric
implements PlatformAccess,
ServerLifecycleEvents.ServerStopped {
    private final Lazy<PlatformAccess.RegisterObjects> itemsLazy = Lazy.lazy(RegisterObjectsFabric::new);
    private final Lazy<PacketHandler> packetHandlerLazy = Lazy.lazy(PacketHandler::new);
    private final Lazy<TransferFabric> transferLazy = Lazy.lazy(TransferFabric::new);
    private final ConfigHolder configLazy = new ConfigHolder(this::modified);
    private final Lazy<PlatformAccess.Mining> miningLazy = Lazy.lazy(MiningFabric::new);

    @Override
    public String platformName() {
        return "Fabric";
    }

    @Override
    public PlatformAccess.RegisterObjects registerObjects() {
        return (PlatformAccess.RegisterObjects)this.itemsLazy.get();
    }

    @Override
    public PlatformAccess.Packet packetHandler() {
        return (PlatformAccess.Packet)this.packetHandlerLazy.get();
    }

    @Override
    public Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("%s.toml".formatted("quarryplus"));
    }

    @Override
    public boolean isInDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public Supplier<? extends QuarryConfig> getConfig() {
        return this.configLazy;
    }

    @Override
    public PlatformAccess.Transfer transfer() {
        return (PlatformAccess.Transfer)this.transferLazy.get();
    }

    @Override
    public FluidStackLike getFluidInItem(class_1799 stack) {
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        if (storage == null) {
            return FluidStackLike.EMPTY;
        }
        ResourceAmount extracted = StorageUtil.findExtractableContent((Storage)storage, null);
        if (extracted == null) {
            return FluidStackLike.EMPTY;
        }
        return new FluidStackLike(((FluidVariant)extracted.resource()).getFluid(), extracted.amount(), ((FluidVariant)extracted.resource()).getComponents());
    }

    @Override
    public class_2561 getFluidName(FluidStackLike stack) {
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)stack.fluid(), (class_9326)stack.patch()));
    }

    @Override
    public <T extends class_1703> void openGui(class_3222 player, GeneralScreenHandler<T> handler) {
        player.method_17355(new ExtendedGeneralScreenHandler<T>(handler));
    }

    @Override
    public PlatformAccess.Mining mining() {
        return (PlatformAccess.Mining)this.miningLazy.get();
    }

    public void onServerStopped(MinecraftServer server) {
        this.configLazy.reset();
    }

    private QuarryConfig modified() {
        return QuarryConfig.load(this.configPath(), this::isInDevelopmentEnvironment);
    }

    public static final class RegisterObjectsFabric
    implements PlatformAccess.RegisterObjects {
        public static final QuarryBlockFabric QUARRY_BLOCK = new QuarryBlockFabric();
        public static final class_2591<QuarryEntityFabric> QUARRY_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(QuarryEntityFabric::new, (class_2248[])new class_2248[]{QUARRY_BLOCK}).build();
        public static final class_3917<QuarryMenuFabric> QUARRY_MENU = new ExtendedScreenHandlerType(QuarryMenuFabric::new, class_2338.field_48404);
        public static final AdvQuarryBlockFabric ADV_QUARRY_BLOCK = new AdvQuarryBlockFabric();
        public static final class_2591<AdvQuarryEntityFabric> ADV_QUARRY_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(AdvQuarryEntityFabric::new, (class_2248[])new class_2248[]{ADV_QUARRY_BLOCK}).build();
        public static final class_3917<AdvQuarryContainer> ADV_QUARRY_MENU = new ExtendedScreenHandlerType(AdvQuarryContainer::new, class_2338.field_48404);
        public static final FrameBlock FRAME_BLOCK = new FrameBlock();
        public static final SoftBlock SOFT_BLOCK = new SoftBlock();
        public static final GeneratorBlock GENERATOR_BLOCK = new GeneratorBlock();
        public static final class_2591<GeneratorEntity> GENERATOR_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(GeneratorEntity::new, (class_2248[])new class_2248[]{GENERATOR_BLOCK}).build();
        public static final CheckerItemFabric CHECKER_ITEM = new CheckerItemFabric();
        public static final NormalMarkerBlock MARKER_BLOCK = new NormalMarkerBlock();
        public static final class_2591<NormalMarkerEntity> MARKER_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(NormalMarkerEntity::new, (class_2248[])new class_2248[]{MARKER_BLOCK}).build();
        public static final YSetterItemFabric Y_SET_ITEM = new YSetterItemFabric();
        public static final class_3917<YSetterContainer> Y_SET_MENU = new ExtendedScreenHandlerType(YSetterContainer::new, class_2338.field_48404);
        public static final MoverBlock MOVER_BLOCK = new MoverBlock();
        public static final class_2591<MoverEntity> MOVER_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(MoverEntity::new, (class_2248[])new class_2248[]{MOVER_BLOCK}).build();
        public static final class_3917<MoverContainer> MOVER_MENU = new ExtendedScreenHandlerType(MoverContainer::new, class_2338.field_48404);
        public static final PumpModuleItem PUMP_MODULE_ITEM = new PumpModuleItem();
        public static final class_3917<ModuleContainer> MODULE_MENU = new ExtendedScreenHandlerType(ModuleContainer::new, class_2338.field_48404);
        public static final BedrockModuleItem BEDROCK_MODULE_ITEM = new BedrockModuleItem();
        public static final ExpModuleItem EXP_MODULE_ITEM = new ExpModuleItem();
        public static final FlexibleMarkerBlock FLEXIBLE_MARKER_BLOCK = new FlexibleMarkerBlock();
        public static final class_2591<FlexibleMarkerEntity> FLEXIBLE_MARKER_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(FlexibleMarkerEntity::new, (class_2248[])new class_2248[]{FLEXIBLE_MARKER_BLOCK}).build();
        public static final ChunkMarkerBlock CHUNK_MARKER_BLOCK = new ChunkMarkerBlock();
        public static final class_2591<ChunkMarkerEntity> CHUNK_MARKER_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(ChunkMarkerEntity::new, (class_2248[])new class_2248[]{CHUNK_MARKER_BLOCK}).build();
        public static final class_3917<MarkerContainer> FLEXIBLE_MARKER_MENU = new ExtendedScreenHandlerType(MarkerContainer::createFlexibleMarkerContainer, class_2338.field_48404);
        public static final class_3917<MarkerContainer> CHUNK_MARKER_MENU = new ExtendedScreenHandlerType(MarkerContainer::createChunkMarkerContainer, class_2338.field_48404);
        public static final RepeatTickModuleItem REPEAT_TICK_MODULE_ITEM = new RepeatTickModuleItem();
        public static final DebugStorageBlock DEBUG_STORAGE_BLOCK = new DebugStorageBlock();
        public static final class_2591<DebugStorageEntity> DEBUG_STORAGE_TYPE = FabricBlockEntityTypeBuilder.create(DebugStorageEntity::new, (class_2248[])new class_2248[]{DEBUG_STORAGE_BLOCK}).build();
        public static final class_3917<DebugStorageContainer> DEBUG_STORAGE_MENU = new ExtendedScreenHandlerType(DebugStorageContainer::new, class_2338.field_48404);
        public static final FilterModuleItem FILTER_MODULE_ITEM = new FilterModuleItem();
        public static final class_3917<FilterModuleContainer> FILTER_MODULE_MENU = new ExtendedScreenHandlerType((i, inventory, pos) -> new FilterModuleContainer(i, inventory, inventory.method_7391()), class_2338.field_48404);
        public static final PlacerBlock PLACER_BLOCK = new PlacerBlock();
        public static final class_2591<PlacerEntity> PLACER_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(PlacerEntity::new, (class_2248[])new class_2248[]{PLACER_BLOCK}).build();
        public static final class_3917<PlacerContainer> PLACER_MENU_TYPE = new ExtendedScreenHandlerType(PlacerContainer::createPlacerContainer, class_2338.field_48404);
        public static final RemotePlacerBlock REMOTE_PLACER_BLOCK = new RemotePlacerBlock();
        public static final class_2591<RemotePlacerEntity> REMOTE_PLACER_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(RemotePlacerEntity::new, (class_2248[])new class_2248[]{REMOTE_PLACER_BLOCK}).build();
        public static final class_3917<PlacerContainer> REMOTE_PLACER_MENU_TYPE = new ExtendedScreenHandlerType(PlacerContainer::createRemotePlacerContainer, class_2338.field_48404);
        public static final class_5339<MachineLootFunction> MACHINE_LOOT_FUNCTION = new class_5339(MachineLootFunction.SERIALIZER);
        private static final Map<class_2960, InCreativeTabs> TAB_ITEMS = new HashMap<class_2960, InCreativeTabs>();
        public static final class_1761 TAB = QuarryPlus.buildCreativeModeTab(FabricItemGroup.builder()).method_47324();
        private static final Map<Class<? extends QpBlock>, class_2591<?>> BLOCK_ENTITY_TYPES = new HashMap();
        private static final Map<String, EnableMap.EnableOrNot> ENABLE_MAP = new HashMap<String, EnableMap.EnableOrNot>();

        static void registerAll() {
            RegisterObjectsFabric.registerEntityBlock(QUARRY_BLOCK, QUARRY_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_ON);
            RegisterObjectsFabric.registerEntityBlock(ADV_QUARRY_BLOCK, ADV_QUARRY_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_ON);
            RegisterObjectsFabric.registerEntityBlock(GENERATOR_BLOCK, GENERATOR_ENTITY_TYPE, EnableMap.EnableOrNot.ALWAYS_ON);
            RegisterObjectsFabric.registerEntityBlock(MOVER_BLOCK, MOVER_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_ON);
            RegisterObjectsFabric.registerEntityBlock(PLACER_BLOCK, PLACER_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_ON);
            RegisterObjectsFabric.registerEntityBlock(REMOTE_PLACER_BLOCK, REMOTE_PLACER_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_OFF);
            RegisterObjectsFabric.registerEntityBlock(MARKER_BLOCK, MARKER_ENTITY_TYPE, EnableMap.EnableOrNot.ALWAYS_ON);
            RegisterObjectsFabric.registerEntityBlock(FLEXIBLE_MARKER_BLOCK, FLEXIBLE_MARKER_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_ON);
            RegisterObjectsFabric.registerEntityBlock(CHUNK_MARKER_BLOCK, CHUNK_MARKER_ENTITY_TYPE, EnableMap.EnableOrNot.CONFIG_ON);
            RegisterObjectsFabric.registerItem(PUMP_MODULE_ITEM, EnableMap.EnableOrNot.ALWAYS_OFF);
            RegisterObjectsFabric.registerItem(BEDROCK_MODULE_ITEM, EnableMap.EnableOrNot.CONFIG_OFF);
            RegisterObjectsFabric.registerItem(EXP_MODULE_ITEM, EnableMap.EnableOrNot.ALWAYS_OFF);
            RegisterObjectsFabric.registerItem(REPEAT_TICK_MODULE_ITEM, EnableMap.EnableOrNot.ALWAYS_OFF);
            RegisterObjectsFabric.registerItem(FILTER_MODULE_ITEM, EnableMap.EnableOrNot.ALWAYS_OFF);
            RegisterObjectsFabric.registerItem(CHECKER_ITEM, EnableMap.EnableOrNot.ALWAYS_ON);
            RegisterObjectsFabric.registerItem(Y_SET_ITEM, EnableMap.EnableOrNot.ALWAYS_ON);
            RegisterObjectsFabric.registerBlockItem(FRAME_BLOCK);
            RegisterObjectsFabric.registerBlockItem(SOFT_BLOCK, class_2960.method_60655((String)"quarryplus", (String)"soft_block"), softBlock -> softBlock.blockItem);
            RegisterObjectsFabric.registerEntityBlock(DEBUG_STORAGE_BLOCK, DEBUG_STORAGE_TYPE, EnableMap.EnableOrNot.ALWAYS_ON);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_quarry", QUARRY_MENU);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_y_setter", Y_SET_MENU);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_mover", MOVER_MENU);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_quarry_module", MODULE_MENU);
            class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)"quarryplus", (String)"gui_flexible_marker"), FLEXIBLE_MARKER_MENU);
            class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)"quarryplus", (String)"gui_chunk_marker"), CHUNK_MARKER_MENU);
            class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)"quarryplus", (String)"gui_debug_storage"), DEBUG_STORAGE_MENU);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_adv_quarry", ADV_QUARRY_MENU);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_filter_module", FILTER_MODULE_MENU);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_placer_plus", PLACER_MENU_TYPE);
            class_2378.method_10226((class_2378)class_7923.field_41187, (String)"quarryplus:gui_remote_placer", REMOTE_PLACER_MENU_TYPE);
            class_2378.method_10230((class_2378)class_7923.field_41134, (class_2960)class_2960.method_60655((String)"quarryplus", (String)"machine_loot_function"), MACHINE_LOOT_FUNCTION);
            class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)class_2960.method_60655((String)"quarryplus", (String)"quarryplus"), (Object)TAB);
            for (Map.Entry<class_2960, class_9331<?>> entry : QuarryDataComponents.ALL.entrySet()) {
                class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)entry.getKey(), entry.getValue());
            }
            class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)class_2960.method_60655((String)"quarryplus", (String)"install_bedrock_module_recipe"), InstallBedrockModuleRecipe.SERIALIZER);
            class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)FilterModuleExpandRecipe.LOCATION, FilterModuleExpandRecipe.SERIALIZER);
        }

        private static void registerEntityBlock(QpBlock block, class_2591<?> entityType, EnableMap.EnableOrNot enable) {
            if (!entityType.method_20526(block.method_9564())) {
                throw new IllegalArgumentException("Invalid block entity type (%s) for %s".formatted(entityType, block.getClass().getSimpleName()));
            }
            RegisterObjectsFabric.registerBlockItem(block);
            class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)block.name, entityType);
            BLOCK_ENTITY_TYPES.put(block.getClass(), entityType);
            ENABLE_MAP.put(block.name.method_12832(), enable);
        }

        private static void registerBlockItem(QpBlock block) {
            RegisterObjectsFabric.registerBlockItem(block, block.name, b -> b.blockItem);
        }

        private static <T extends class_2248> void registerBlockItem(T block, class_2960 name, Function<T, ? extends class_1747> itemGetter) {
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)name, block);
            RegisterObjectsFabric.registerItem((class_1792)itemGetter.apply(block), name);
            TAB_ITEMS.put(name, (InCreativeTabs)block);
        }

        private static void registerItem(QpItem item, EnableMap.EnableOrNot enable) {
            RegisterObjectsFabric.registerItem((class_1792)item, item.name);
            ENABLE_MAP.put(item.name.method_12832(), enable);
        }

        private static void registerItem(class_1792 item, class_2960 name) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)name, (Object)item);
            if (item instanceof InCreativeTabs) {
                InCreativeTabs c = (InCreativeTabs)item;
                TAB_ITEMS.put(name, c);
            }
            if (item instanceof class_1747) {
                class_1747 blockItem = (class_1747)item;
                blockItem.method_7713(class_1792.field_8003, (class_1792)blockItem);
            }
        }

        @Override
        public Supplier<? extends QuarryBlock> quarryBlock() {
            return Lazy.value((Object)QUARRY_BLOCK);
        }

        @Override
        public Supplier<? extends FrameBlock> frameBlock() {
            return Lazy.value((Object)FRAME_BLOCK);
        }

        @Override
        public Supplier<? extends GeneratorBlock> generatorBlock() {
            return Lazy.value((Object)GENERATOR_BLOCK);
        }

        @Override
        public Supplier<? extends NormalMarkerBlock> markerBlock() {
            return Lazy.value((Object)MARKER_BLOCK);
        }

        @Override
        public Supplier<? extends MoverBlock> moverBlock() {
            return Lazy.value((Object)MOVER_BLOCK);
        }

        @Override
        public Supplier<? extends FlexibleMarkerBlock> flexibleMarkerBlock() {
            return Lazy.value((Object)FLEXIBLE_MARKER_BLOCK);
        }

        @Override
        public Supplier<? extends ChunkMarkerBlock> chunkMarkerBlock() {
            return Lazy.value((Object)CHUNK_MARKER_BLOCK);
        }

        @Override
        public Supplier<? extends DebugStorageBlock> debugStorageBlock() {
            return Lazy.value((Object)DEBUG_STORAGE_BLOCK);
        }

        @Override
        public Supplier<? extends AdvQuarryBlock> advQuarryBlock() {
            return Lazy.value((Object)ADV_QUARRY_BLOCK);
        }

        @Override
        public Supplier<? extends SoftBlock> softBlock() {
            return Lazy.value((Object)SOFT_BLOCK);
        }

        @Override
        public Supplier<? extends PlacerBlock> placerBlock() {
            return Lazy.value((Object)PLACER_BLOCK);
        }

        @Override
        public Supplier<? extends RemotePlacerBlock> remotePlacerBlock() {
            return Lazy.value((Object)REMOTE_PLACER_BLOCK);
        }

        @Override
        public Optional<class_2591<?>> getBlockEntityType(QpBlock block) {
            class_2591<?> t = BLOCK_ENTITY_TYPES.get(block.getClass());
            if (t == null) {
                QuarryPlus.LOGGER.warn("Unknown block type: {}", (Object)block.name);
                return Optional.empty();
            }
            return Optional.of(t);
        }

        @Override
        public Map<String, EnableMap.EnableOrNot> defaultEnableSetting() {
            return ENABLE_MAP;
        }

        @Override
        public Supplier<? extends BedrockModuleItem> bedrockModuleItem() {
            return Lazy.value((Object)BEDROCK_MODULE_ITEM);
        }

        @Override
        public Supplier<? extends FilterModuleItem> filterModuleItem() {
            return Lazy.value((Object)FILTER_MODULE_ITEM);
        }

        @Override
        public Stream<Map.Entry<class_2960, Supplier<? extends InCreativeTabs>>> allItems() {
            return TAB_ITEMS.entrySet().stream().map(t -> Pair.of((Object)((class_2960)t.getKey()), t::getValue));
        }

        @Override
        public Supplier<class_3917<? extends YSetterContainer>> ySetterContainer() {
            return Lazy.value(Y_SET_MENU);
        }

        @Override
        public Supplier<class_3917<? extends MoverContainer>> moverContainer() {
            return Lazy.value(MOVER_MENU);
        }

        @Override
        public Supplier<class_3917<? extends ModuleContainer>> moduleContainer() {
            return Lazy.value(MODULE_MENU);
        }

        @Override
        public Supplier<class_3917<? extends MarkerContainer>> flexibleMarkerContainer() {
            return Lazy.value(FLEXIBLE_MARKER_MENU);
        }

        @Override
        public Supplier<class_3917<? extends MarkerContainer>> chunkMarkerContainer() {
            return Lazy.value(CHUNK_MARKER_MENU);
        }

        @Override
        public Supplier<class_3917<? extends DebugStorageContainer>> debugStorageContainer() {
            return Lazy.value(DEBUG_STORAGE_MENU);
        }

        @Override
        public Supplier<class_3917<? extends AdvQuarryContainer>> advQuarryContainer() {
            return Lazy.value(ADV_QUARRY_MENU);
        }

        @Override
        public Supplier<class_3917<? extends FilterModuleContainer>> filterModuleContainer() {
            return Lazy.value(FILTER_MODULE_MENU);
        }

        @Override
        public Supplier<class_3917<? extends PlacerContainer>> placerContainer() {
            return Lazy.value(PLACER_MENU_TYPE);
        }

        @Override
        public Supplier<class_3917<? extends PlacerContainer>> remotePlacerContainer() {
            return Lazy.value(REMOTE_PLACER_MENU_TYPE);
        }

        @Override
        public Supplier<class_5339<? extends MachineLootFunction>> machineLootFunction() {
            return Lazy.value(MACHINE_LOOT_FUNCTION);
        }
    }
}

