/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.client.renderer.blockentity.state.CraftingTableRenderState;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import fuzs.visualworkbench.world.level.block.entity.WorkbenchVisualsProvider;
import java.util.ArrayList;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1263;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CraftingTableBlockEntityRenderer<T extends class_2586 & WorkbenchVisualsProvider>
implements class_827<T, CraftingTableRenderState> {
    private final class_10442 itemModelResolver;

    public CraftingTableBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemModelResolver = context.comp_4536();
    }

    public CraftingTableRenderState createRenderState() {
        return new CraftingTableRenderState();
    }

    public void extractRenderState(T blockEntity, CraftingTableRenderState renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74331(blockEntity, (class_11954)renderState, partialTick, cameraPosition, breakProgress);
        renderState.result.method_65605();
        int position = (int)blockEntity.method_11016().method_10063();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).resultRendering) {
            this.itemModelResolver.method_65598(renderState.result, ((WorkbenchVisualsProvider)blockEntity).getCraftingResult(), class_811.field_4318, blockEntity.method_10997(), null, position);
        }
        renderState.items = new ArrayList<class_10444>();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).ingredientRendering != ClientConfig.IngredientRendering.NONE) {
            for (int i = 0; i < ((class_1263)blockEntity).method_5439(); ++i) {
                class_10444 itemStackRenderState = new class_10444();
                this.itemModelResolver.method_65598(itemStackRenderState, ((class_1263)blockEntity).method_5438(i), class_811.field_4319, blockEntity.method_10997(), null, position + i);
                renderState.items.add(itemStackRenderState);
            }
        }
        CraftingTableAnimationController animationController = ((WorkbenchVisualsProvider)blockEntity).getAnimationController();
        renderState.time = (float)animationController.getTime() + partialTick;
        renderState.angle = class_3532.method_16439((float)partialTick, (float)animationController.getCurrentAngle(), (float)animationController.getNextAngle());
        renderState.itemLightCoords = blockEntity.method_10997() != null ? class_761.method_23794((class_1920)blockEntity.method_10997(), (class_2338)blockEntity.method_11016().method_10084()) : 0xF000F0;
    }

    public void submit(CraftingTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        block4: for (int i = 0; i < renderState.items.size(); ++i) {
            switch (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).ingredientRendering) {
                case FLAT: {
                    this.submitFlatItemList(renderState, poseStack, nodeCollector, i);
                    continue block4;
                }
                case FLOATING: {
                    this.submitFloatingItemList(renderState, poseStack, nodeCollector, i);
                }
            }
        }
        this.submitFloatingItemStack(renderState, poseStack, nodeCollector);
    }

    private void submitFlatItemList(CraftingTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, int index) {
        class_10444 itemStackRenderState = renderState.items.get(index);
        if (!itemStackRenderState.method_65606()) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.0, 0.5);
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(renderState.angle));
            poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState) ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            float scale = CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState) ? 0.25f : 0.175f;
            poseStack.method_22905(scale, scale, scale);
            itemStackRenderState.method_65604(poseStack, nodeCollector, renderState.itemLightCoords, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
    }

    private void submitFloatingItemList(CraftingTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, int index) {
        class_10444 itemStackRenderState = renderState.items.get(index);
        if (!itemStackRenderState.method_65606()) {
            poseStack.method_22903();
            float shift = (float)Math.abs(((double)renderState.time * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
            poseStack.method_22904(0.5, (double)shift, 0.5);
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(renderState.angle));
            poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
            float scale = CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState) ? 0.24f : 0.18f;
            poseStack.method_22905(scale, scale, scale);
            itemStackRenderState.method_65604(poseStack, nodeCollector, renderState.itemLightCoords, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
    }

    private void submitFloatingItemStack(CraftingTableRenderState renderState, class_4587 poseStack, class_11659 nodeCollector) {
        class_10444 itemStackRenderState = renderState.result;
        if (!itemStackRenderState.method_65606()) {
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 1.15f, 0.5f);
            float hoverOffset = class_3532.method_15374((float)(renderState.time / 10.0f)) * 0.04f + 0.1f;
            class_238 aABB = itemStackRenderState.method_72173();
            float modelYScale = -((float)aABB.field_1322) + 0.0625f;
            poseStack.method_22904(0.0, (double)(hoverOffset + modelYScale), 0.0);
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(renderState.time / 20.0f));
            if (!CraftingTableBlockEntityRenderer.isGui3d(itemStackRenderState)) {
                poseStack.method_22905(0.75f, 0.75f, 0.75f);
            }
            itemStackRenderState.method_65604(poseStack, nodeCollector, renderState.itemLightCoords, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
    }

    private static boolean isGui3d(class_10444 renderState) {
        return renderState.method_72173().method_17941() > 0.0625;
    }
}

