/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_479;
import org.jetbrains.annotations.Nullable;

public final class ClientCraftingTableAnimationController
implements CraftingTableAnimationController {
    private final class_243 position;
    private int sector;
    private boolean animating;
    private float animationAngleStart;
    private float animationAngleEnd;
    private double startTicks;
    private double playerAngle;
    private int time;
    private float currentAngle;
    private float nextAngle;

    public ClientCraftingTableAnimationController(class_2338 blockPos) {
        this.position = blockPos.method_46558();
    }

    @Override
    public void tick(class_1937 level) {
        ++this.time;
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).ingredientRendering != ClientConfig.IngredientRendering.NONE) {
            this.setPlayerAngle(level);
            this.setCurrentSector();
            this.updateAnimationAngles();
        }
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public float getCurrentAngle() {
        return this.currentAngle;
    }

    @Override
    public float getNextAngle() {
        return this.nextAngle;
    }

    private void setPlayerAngle(class_1937 level) {
        class_1657 player = this.getPlayer(level);
        if (player != null) {
            double d0 = player.method_23317() - this.position.method_10216();
            double d1 = player.method_23321() - this.position.method_10215();
            this.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
    }

    @Nullable
    private class_1657 getPlayer(class_1937 level) {
        ClientConfig.RotateIngredients rotateIngredients = ((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).rotateIngredients;
        if (rotateIngredients != ClientConfig.RotateIngredients.NEVER) {
            return level.method_8604(this.position.method_10216(), this.position.method_10214(), this.position.method_10215(), 3.0, entity -> {
                if (!class_1301.field_6155.test(entity)) {
                    return false;
                }
                if (rotateIngredients == ClientConfig.RotateIngredients.CLOSEST_PLAYER) {
                    return true;
                }
                class_310 minecraft = class_310.method_1551();
                if (entity == minecraft.field_1724) {
                    return minecraft.field_1755 instanceof class_479;
                }
                return false;
            });
        }
        return null;
    }

    private void setCurrentSector() {
        int sector = (int)(this.playerAngle * 2.0 / Math.PI);
        if (this.sector != sector) {
            this.animating = true;
            this.animationAngleStart = this.currentAngle;
            float delta1 = (float)sector * 90.0f - this.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            this.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + this.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + this.currentAngle : delta1 + this.currentAngle);
            this.startTicks = this.time;
            this.sector = sector;
        }
    }

    private void updateAnimationAngles() {
        if (this.animating) {
            if ((double)this.time >= this.startTicks + 20.0) {
                this.animating = false;
                this.currentAngle = this.nextAngle = (this.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                this.currentAngle = (ClientCraftingTableAnimationController.calcEaseOutQuad((double)this.time - this.startTicks, this.animationAngleStart, this.animationAngleEnd - this.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                this.nextAngle = (ClientCraftingTableAnimationController.calcEaseOutQuad(Math.min((double)(this.time + 1) - this.startTicks, 20.0), this.animationAngleStart, this.animationAngleEnd - this.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (this.currentAngle != 0.0f || this.nextAngle != 0.0f) {
                    if (this.currentAngle == 0.0f && this.nextAngle >= 180.0f) {
                        this.currentAngle = 360.0f;
                    }
                    if (this.nextAngle == 0.0f && this.currentAngle >= 180.0f) {
                        this.nextAngle = 360.0f;
                    }
                }
            }
        }
    }

    private static float calcEaseOutQuad(double t, float b, float c, double d) {
        float z = (float)t / (float)d;
        return -c * z * (z - 2.0f) + b;
    }
}

