/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.processing;

import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import com.natamus.treeharvester_common_forge.data.Variables;
import com.natamus.treeharvester_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import oshi.util.tuples.Triplet;

public class TreeProcessing {
    public static int isTreeAndReturnLogAmount(Level level, BlockPos pos) {
        Variables.highestleaf.put(pos, 0);
        int leafcount = 8;
        int logCount = 0;
        int prevleafcount = -1;
        int prevlogCount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogCount != logCount); ++y) {
            prevleafcount = leafcount;
            prevlogCount = logCount;
            for (BlockPos npos : BlockPos.betweenClosed((int)(pos.getX() - 2), (int)(pos.getY() + (y - 1)), (int)(pos.getZ() - 2), (int)(pos.getX() + 2), (int)(pos.getY() + (y - 1)), (int)(pos.getZ() + 2))) {
                BlockState nblockState = level.getBlockState(npos);
                Block nblock = nblockState.getBlock();
                if (CompareBlockFunctions.isTreeLeaf((Block)nblock, (boolean)ConfigHandler.enableNetherTrees) || Util.isGiantMushroomLeafBlock(nblock)) {
                    if (ConfigHandler.ignorePlayerMadeTrees && nblockState.getOptionalValue((Property)LeavesBlock.PERSISTENT).orElse(false).booleanValue()) {
                        return -1;
                    }
                    --leafcount;
                    if (npos.getY() <= highesty) continue;
                    highesty = npos.getY();
                    continue;
                }
                if (!Util.isTreeLog(nblock)) continue;
                ++logCount;
            }
        }
        Variables.highestleaf.put(pos.immutable(), highesty);
        if (leafcount < 0) {
            return logCount;
        }
        return -1;
    }

    public static List<BlockPos> getAllLogsToBreak(Level level, BlockPos pos, int logCount, Block logType) {
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        if (ConfigHandler.replaceSaplingOnTreeHarvest) {
            Block blockbelow = level.getBlockState(pos.below()).getBlock();
            if (CompareBlockFunctions.isDirtBlock((Block)blockbelow) || blockbelow instanceof MyceliumBlock) {
                Iterator it = BlockPos.betweenClosedStream((int)(pos.getX() - 1), (int)pos.getY(), (int)(pos.getZ() - 1), (int)(pos.getX() + 1), (int)pos.getY(), (int)(pos.getZ() + 1)).iterator();
                while (it.hasNext()) {
                    BlockPos npos = (BlockPos)it.next();
                    Block block = level.getBlockState(npos).getBlock();
                    if (!block.equals(logType) && !Util.areEqualLogTypes(logType, block)) continue;
                    bottomlogs.add(npos.immutable());
                }
            }
            Variables.saplingPositions.add((Triplet<Date, BlockPos, CopyOnWriteArrayList<BlockPos>>)new Triplet((Object)new Date(), (Object)pos.immutable(), bottomlogs));
        }
        return TreeProcessing.getLogsToBreak(level, pos, new ArrayList<BlockPos>(), logCount, logType);
    }

    private static List<BlockPos> getLogsToBreak(Level level, BlockPos pos, List<BlockPos> logsToBreak, int logCount, Block logType) {
        ArrayList<BlockPos> checkAround = new ArrayList<BlockPos>();
        boolean isMangrove = Util.isMangroveRootOrLog(logType);
        int downY = pos.getY() - 1;
        ArrayList<BlockPos> aroundLogs = new ArrayList<BlockPos>();
        for (BlockPos aL : BlockPos.betweenClosed((int)(pos.getX() - 1), (int)(pos.getY() - 1), (int)(pos.getZ() - 1), (int)(pos.getX() + 1), (int)(pos.getY() + 1), (int)(pos.getZ() + 1))) {
            aroundLogs.add(aL.immutable());
        }
        for (BlockPos aroundLogPos : aroundLogs) {
            BlockState logstate;
            Block logblock;
            if (logsToBreak.contains(aroundLogPos) || !(logblock = (logstate = level.getBlockState(aroundLogPos)).getBlock()).equals(logType) && !Util.areEqualLogTypes(logType, logblock)) continue;
            if (!isMangrove || aroundLogPos.getY() != downY) {
                checkAround.add(aroundLogPos);
            }
            logsToBreak.add(aroundLogPos);
        }
        if (checkAround.size() == 0) {
            return logsToBreak;
        }
        for (BlockPos capos : checkAround) {
            for (BlockPos logpos : TreeProcessing.getLogsToBreak(level, capos, logsToBreak, logCount, logType)) {
                if (logsToBreak.contains(logpos)) continue;
                logsToBreak.add(logpos.immutable());
            }
        }
        BlockPos up = pos.above(2);
        return TreeProcessing.getLogsToBreak(level, up.immutable(), logsToBreak, logCount, logType);
    }
}

