/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import com.natamus.treeharvester_common_forge.data.Variables;
import com.natamus.treeharvester_common_forge.util.Util;
import java.util.EnumSet;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LeafEvents {
    public static void onWorldTick(ServerLevel level) {
        int sizeLeft = ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(Variables.processBreakLeaves, (Object)level, k -> new CopyOnWriteArrayList())).size() + ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(Variables.processTickLeaves, (Object)level, k -> new CopyOnWriteArrayList())).size();
        int leavesLeft = ConfigHandler.amountOfLeavesBrokenPerTick;
        if (sizeLeft > 2000) {
            leavesLeft *= 4;
        } else if (sizeLeft > 1000) {
            leavesLeft *= 3;
        }
        for (BlockPos leafPos : Variables.processBreakLeaves.get(level)) {
            Variables.processBreakLeaves.get(level).remove(leafPos);
            if (!Util.isTreeLeaf(level.getBlockState(leafPos).getBlock())) continue;
            BlockFunctions.dropBlock((Level)level, (BlockPos)leafPos);
            if (--leavesLeft >= 0) continue;
            break;
        }
        if (leavesLeft > 0) {
            for (BlockPos leafPos : Variables.processTickLeaves.get(level)) {
                Variables.processTickLeaves.get(level).remove(leafPos);
                BlockState state = level.getBlockState(leafPos);
                if (!Util.isTreeLeaf(state.getBlock())) continue;
                try {
                    state.tick(level, leafPos, level.random);
                    state.randomTick(level, leafPos, level.random);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (--leavesLeft >= 0) continue;
                break;
            }
        }
    }

    public static void onNeighbourNotify(Level level, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        if (level.isClientSide()) {
            return;
        }
        if (!state.getBlock().equals(Blocks.AIR)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (Direction direction : notifiedSides) {
            BlockState oState;
            Block oBlock;
            BlockPos oPos = pos.relative(direction);
            if (!level.isLoaded(oPos) || !CompareBlockFunctions.isTreeLeaf((Block)(oBlock = (oState = level.getBlockState(oPos)).getBlock()), (boolean)ConfigHandler.enableNetherTrees) && !Util.isGiantMushroomLeafBlock(oBlock)) continue;
            BlockPos addPos = oPos.immutable();
            if (((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(Variables.processTickLeaves, (Object)level, k -> new CopyOnWriteArrayList())).contains(addPos)) continue;
            Variables.processTickLeaves.get(level).add(addPos);
        }
    }
}

