/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.util;

import hantonik.fbp.renderer.state.FBPParticleRenderState;
import hantonik.fbp.util.FBPConstants;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_9848;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class FBPRenderHelper {
    public static void renderCubeShaded(FBPParticleRenderState renderState, class_3940.class_11941 layer, float x, float y, float z, float width, float height, Vector3f rotationRad, float u0, float u1, float v0, float v1, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        class_310.method_1551().field_1773.method_22974().method_3316();
        Quaternionf rotation = new Quaternionf().rotateXYZ(rotationRad.x, rotationRad.y, rotationRad.z);
        Quaternionf rotationX = new Quaternionf().rotateX(rotationRad.x);
        Quaternionf rotationY = new Quaternionf().rotateY(rotationRad.y);
        Quaternionf rotationZ = new Quaternionf().rotateZ(rotationRad.z);
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            Vector3f normal = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)rotation, new Vector3f());
            Vector3f face = new Vector3f((Vector3fc)normal).mul(width, height, width).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotationY.mul((Quaternionfc)faceRotation, faceRotation);
            } else if (i < 4) {
                rotationZ.mul((Quaternionfc)faceRotation, faceRotation);
            } else {
                rotationX.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float shade = FBPRenderHelper.getShade(normal.x, normal.y, normal.z, true);
            if (cartoon) {
                renderState.add(layer, face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, width, i < 2 ? width : height, u1, u1, v1, v1, class_9848.method_61318((float)alpha, (float)(red * shade), (float)(green * shade), (float)(blue * shade)), light);
                continue;
            }
            renderState.add(layer, face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, width, i < 2 ? width : height, u0, u1, v0, v1, class_9848.method_61318((float)alpha, (float)(red * shade), (float)(green * shade), (float)(blue * shade)), light);
        }
    }

    public static void renderCubeShadedLegacy(class_4588 buffer, float x, float y, float z, float scale, Vector3f rotationRad, float u0, float u1, float v0, float v1, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        class_310.method_1551().field_1773.method_22974().method_3316();
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3f vec1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f vec2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f vec3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f vec4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f normal = FBPRenderHelper.rotate(FBPConstants.CUBE_NORMALS[i / 4], rotationRad.x, rotationRad.y, rotationRad.z);
            float shade = FBPRenderHelper.getShade(normal.x, normal.y, normal.z, true);
            if (cartoon) {
                FBPRenderHelper.addVertex(buffer, vec1, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, vec2, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, vec3, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, vec4, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                continue;
            }
            FBPRenderHelper.addVertex(buffer, vec1, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, vec2, u1, v0, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, vec3, u0, v0, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, vec4, u0, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
        }
    }

    public static Vector3f rotate(Vector3f vector, float angleX, float angleY, float angleZ) {
        Vector3f sin = new Vector3f(class_3532.method_15374((float)angleX), class_3532.method_15374((float)angleY), class_3532.method_15374((float)angleZ));
        Vector3f cos = new Vector3f(class_3532.method_15362((float)angleX), class_3532.method_15362((float)angleY), class_3532.method_15362((float)angleZ));
        vector = new Vector3f(vector.x, vector.y * cos.x - vector.z * sin.x, vector.y * sin.x + vector.z * cos.x);
        vector = new Vector3f(vector.x * cos.z - vector.y * sin.z, vector.x * sin.z + vector.y * cos.z, vector.z);
        vector = new Vector3f(vector.x * cos.y + vector.z * sin.y, vector.y, vector.x * sin.y - vector.z * cos.y);
        return vector;
    }

    public static float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        boolean constantAmbientLight = class_310.method_1551().field_1687.method_28103().method_29993();
        if (shade) {
            return Math.min(normalX * normalX * 0.6f + normalY * normalY * (constantAmbientLight ? 0.9f : (3.0f + normalY) / 4.0f) + normalZ * normalZ * 0.8f, 1.0f);
        }
        return constantAmbientLight ? 0.9f : 1.0f;
    }

    public static void addVertex(class_4588 buffer, Vector3f pos, float u, float v, int light, float red, float green, float blue, float alpha, Vector3f normal) {
        buffer.method_22912(pos.x, pos.y, pos.z).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914(normal.x, normal.y, normal.z);
    }

    @Generated
    private FBPRenderHelper() {
    }
}

