/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.renderer.state;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_3940;
import net.minecraft.class_4588;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FBPParticleRenderState
implements class_11659.class_11947,
class_11942 {
    private final Map<class_3940.class_11941, Storage> particles = Maps.newHashMap();
    private int particleCount;

    public void add(class_3940.class_11941 layer, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float rotW, float widthScale, float heightScale, float u0, float u1, float v0, float v1, int color, int light) {
        this.particles.computeIfAbsent(layer, l -> new Storage()).add(posX, posY, posZ, rotX, rotY, rotZ, rotW, widthScale, heightScale, u0, u1, v0, v1, color, light);
        ++this.particleCount;
    }

    public void method_74316() {
        this.particles.values().forEach(Storage::clear);
        this.particleCount = 0;
    }

    @Nullable
    public class_11944.class_12041 method_74755(class_11977.class_12051 cache) {
        int verticesCount = this.particleCount * 4;
        try (class_9799 builder = class_9799.method_72201((int)(verticesCount * class_290.field_1584.getVertexSize()));){
            class_287 buffer = new class_287(builder, VertexFormat.class_5596.field_27382, class_290.field_1584);
            HashMap<class_3940.class_11941, class_11944.class_12042> prepared = new HashMap<class_3940.class_11941, class_11944.class_12042>();
            int vertexOffset = 0;
            for (Map.Entry<class_3940.class_11941, Storage> entry : this.particles.entrySet()) {
                entry.getValue().forEachParticle((posX, posY, posZ, rotX, rotY, rotZ, rotW, widthScale, heightScale, u0, u1, v0, v1, color, light) -> this.renderRotatedQuad((class_4588)buffer, posX, posY, posZ, rotX, rotY, rotZ, rotW, widthScale, heightScale, u0, u1, v0, v1, color, light));
                if (entry.getValue().count() > 0) {
                    prepared.put(entry.getKey(), new class_11944.class_12042(vertexOffset, entry.getValue().count() * 6));
                }
                vertexOffset += entry.getValue().count() * 4;
            }
            class_9801 data = buffer.method_60794();
            if (data != null) {
                cache.method_74835(data.method_60818());
                RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(data.method_60822().comp_751());
                class_11944.class_12041 class_120412 = new class_11944.class_12041(data.method_60822().comp_751(), RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth()), prepared);
                return class_120412;
            }
        }
        return null;
    }

    public void method_74324(class_11944.class_12041 buffers, class_11977.class_12051 cache, RenderPass pass, class_1060 manager, boolean translucent) {
        RenderSystem.class_5590 sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        pass.setVertexBuffer(0, cache.method_74834());
        pass.setIndexBuffer(sequentialBuffer.method_68274(buffers.comp_4897()), sequentialBuffer.method_31924());
        pass.setUniform("DynamicTransforms", buffers.comp_4898());
        for (Map.Entry entry : buffers.comp_4899().entrySet()) {
            if (translucent != ((class_3940.class_11941)entry.getKey()).comp_4894()) continue;
            pass.setPipeline(((class_3940.class_11941)entry.getKey()).comp_4896());
            pass.bindSampler("Sampler0", manager.method_4619(((class_3940.class_11941)entry.getKey()).comp_4895()).method_71659());
            pass.drawIndexed(((class_11944.class_12042)entry.getValue()).comp_4900(), 0, ((class_11944.class_12042)entry.getValue()).comp_4901(), 1);
        }
    }

    private void renderRotatedQuad(class_4588 consumer, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float rotW, float widthScale, float heightScale, float u0, float u1, float v0, float v1, int color, int light) {
        Quaternionf rotation = new Quaternionf(rotX, rotY, rotZ, rotW);
        this.renderVertex(consumer, rotation, posX, posY, posZ, 1.0f, -1.0f, widthScale, heightScale, u1, v1, color, light);
        this.renderVertex(consumer, rotation, posX, posY, posZ, 1.0f, 1.0f, widthScale, heightScale, u1, v0, color, light);
        this.renderVertex(consumer, rotation, posX, posY, posZ, -1.0f, 1.0f, widthScale, heightScale, u0, v0, color, light);
        this.renderVertex(consumer, rotation, posX, posY, posZ, -1.0f, -1.0f, widthScale, heightScale, u0, v1, color, light);
    }

    private void renderVertex(class_4588 consumer, Quaternionf rotation, float posX, float posY, float posZ, float x, float y, float widthScale, float heightScale, float u, float v, int color, int light) {
        Vector3f vertexPos = new Vector3f(x, y, 0.0f).rotate((Quaternionfc)rotation).mul(widthScale, heightScale, widthScale).add(posX, posY, posZ);
        consumer.method_22912(vertexPos.x(), vertexPos.y(), vertexPos.z()).method_22913(u, v).method_39415(color).method_60803(light);
    }

    public void submit(class_11659 nodeCollector, class_12075 state) {
        if (this.particleCount > 0) {
            nodeCollector.method_74315((class_11659.class_11947)this);
        }
    }

    static class Storage {
        private int capacity = 1024;
        private int currentParticleIndex;
        private float[] floatValues = new float[this.capacity * 13];
        private int[] intValues = new int[this.capacity * 2];

        Storage() {
        }

        public void add(float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float rotW, float widthScale, float heightScale, float u0, float u1, float v0, float v1, int color, int light) {
            if (this.currentParticleIndex >= this.capacity) {
                this.grow();
            }
            int index = this.currentParticleIndex * 13;
            this.floatValues[index++] = posX;
            this.floatValues[index++] = posY;
            this.floatValues[index++] = posZ;
            this.floatValues[index++] = rotX;
            this.floatValues[index++] = rotY;
            this.floatValues[index++] = rotZ;
            this.floatValues[index++] = rotW;
            this.floatValues[index++] = widthScale;
            this.floatValues[index++] = heightScale;
            this.floatValues[index++] = u0;
            this.floatValues[index++] = u1;
            this.floatValues[index++] = v0;
            this.floatValues[index] = v1;
            index = this.currentParticleIndex * 2;
            this.intValues[index++] = color;
            this.intValues[index] = light;
            ++this.currentParticleIndex;
        }

        public void forEachParticle(ParticleConsumer consumer) {
            for (int i = 0; i < this.currentParticleIndex; ++i) {
                int floatIndex = i * 13;
                int intIndex = i * 2;
                consumer.consume(this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex], this.intValues[intIndex++], this.intValues[intIndex]);
            }
        }

        public void clear() {
            this.currentParticleIndex = 0;
        }

        private void grow() {
            this.capacity *= 2;
            this.floatValues = Arrays.copyOf(this.floatValues, this.capacity * 13);
            this.intValues = Arrays.copyOf(this.intValues, this.capacity * 2);
        }

        public int count() {
            return this.currentParticleIndex;
        }
    }

    @FunctionalInterface
    public static interface ParticleConsumer {
        public void consume(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, int var14, int var15);
    }
}

