/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import java.util.List;
import net.minecraft.class_11944;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2527;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_5544;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_687;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPFlameParticle
extends class_687
implements IKillableParticle {
    private final Vector3d startPos;
    private final Vector3f[] rotatedNormal;
    private final Quaternionf rotation;
    private final boolean isSoulFire;
    private final float multiplier;
    private boolean hasChild;
    private float startSize;
    private float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean killToggle;

    public FBPFlameParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, boolean isSoulFire, boolean hasChild) {
        super(level, x, y, z, xd, yd, zd, FBPConstants.FBP_PARTICLE_SPRITE.get());
        this.field_3869 = -8.5E-4;
        this.field_3844 = -0.05f;
        this.isSoulFire = isSoulFire;
        this.field_62633 = 1.0f;
        this.field_62634 = 1.0f;
        this.field_62635 = 0.0f;
        if (this.isSoulFire) {
            this.field_62633 = 0.2f;
            this.field_62635 = 0.9f;
        }
        this.field_62636 = 1.0f;
        this.field_17867 = FancyBlockParticles.CONFIG.flame.getSizeMultiplier() * (FancyBlockParticles.CONFIG.flame.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.6f, 1.0f) : 1.0f) * 2.5f;
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.flame.getMinLifetime(), FancyBlockParticles.CONFIG.flame.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.flame.getMinLifetime(), FancyBlockParticles.CONFIG.flame.getMaxLifetime()) + 0.5f);
        this.startPos = new Vector3d(x, y, z);
        this.rotatedNormal = new Vector3f[FBPConstants.CUBE_NORMALS.length];
        this.rotation = new Quaternionf().rotateY(this.field_3840.method_43057());
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            this.rotatedNormal[i] = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)this.rotation, new Vector3f());
        }
        this.hasChild = hasChild;
        this.multiplier = FancyBlockParticles.CONFIG.flame.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.9875f, 1.0f) : 1.0f;
        this.scale(1.0f);
    }

    public FBPFlameParticle scale(float scale) {
        super.method_3087(scale);
        this.startSize = this.field_17867;
        this.scaleAlpha = this.field_17867 * 0.35f;
        float size = this.field_17867 / 80.0f;
        this.method_3067(new class_238(this.field_3874 - (double)size, this.field_3854 - (double)size, this.field_3871 - (double)size, this.field_3874 + (double)size, this.field_3854 + (double)size, this.field_3871 + (double)size));
        return this;
    }

    public float method_18132(float scale) {
        float factor = ((float)this.field_3866 + scale) / (float)this.field_3847;
        return this.field_17867 * (1.0f - factor * factor * 0.5f);
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.lastAlpha = this.field_62636;
        this.lastSize = this.field_17867;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.flame.isEnabled()) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.flame.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.field_3866;
                }
                if (this.field_3866 >= this.field_3847) {
                    this.field_17867 *= this.multiplier * 0.95f;
                    if ((double)this.field_62636 >= 0.01 && this.field_17867 <= this.scaleAlpha) {
                        this.field_62636 *= this.multiplier * 0.95f;
                    }
                    class_2680 state = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871));
                    if ((double)this.field_62636 < 0.01) {
                        this.method_3085();
                    } else if ((double)this.field_62636 <= 0.325 && this.hasChild && (state.method_26204() instanceof class_2527 || state.method_26204() instanceof class_5544)) {
                        this.hasChild = false;
                        class_310.method_1551().field_1713.method_3058((class_703)new FBPFlameParticle(this.field_3851, this.startPos.x, this.startPos.y, this.startPos.z, 0.0, 0.0, 0.0, this.isSoulFire, false));
                    }
                }
                this.field_3869 -= 0.02 * (double)this.field_3844;
                this.method_3069(0.0, this.field_3869, 0.0);
                this.field_3869 *= 0.95;
                if (this.field_3845) {
                    this.field_3852 *= 0.9;
                    this.field_3850 *= 0.9;
                }
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void method_3069(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < class_3532.method_33723((double)100.0)) {
            class_243 vec = class_1297.method_20736(null, (class_243)new class_243(x, y, z), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
            x = vec.field_1352;
            y = vec.field_1351;
            z = vec.field_1350;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.method_3067(this.method_3064().method_989(x, y, z));
            this.method_3072();
        }
        boolean bl = this.field_3845 = y != yo && yo < 0.0;
        if (x != xo) {
            this.field_3852 = 0.0;
        }
        if (z != zo) {
            this.field_3850 = 0.0;
        }
    }

    protected void method_3072() {
        super.method_3072();
        class_238 box = this.method_3064();
        this.field_3854 = (box.field_1322 + box.field_1325) / 2.0;
    }

    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62639;
    }

    public int method_3068(float partialTick) {
        float factor = class_3532.method_15363((float)(((float)this.field_3866 + partialTick) / (float)this.field_3847), (float)0.0f, (float)1.0f);
        int i = super.method_3068(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        j = Math.min((int)(factor * 15.0f * 16.0f) + j, 240);
        i = j | k << 16;
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.field_3851.method_8477(pos)) {
            j = this.field_3851.method_22336().method_22363(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void method_3074(class_11944 renderState, class_4184 info, float partialTick) {
        float u = this.field_62632.method_4580(0.275f);
        float v = this.field_62632.method_4570(0.275f);
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350;
        float scale = class_3532.method_16439((float)partialTick, (float)this.lastSize, (float)this.field_17867);
        float alpha = class_3532.method_16439((float)partialTick, (float)this.lastAlpha, (float)this.field_62636);
        int light = this.method_3068(partialTick);
        if (this.field_3866 >= this.field_3847) {
            float f = this.field_62634 = this.isSoulFire ? Math.min(1.0f, scale / this.startSize * 1.2f) : scale / this.startSize;
            if (this.isSoulFire) {
                this.field_62635 = Math.min(1.0f, scale / this.startSize * 1.2f);
            }
        }
        class_310.method_1551().field_1773.method_22974().method_3316();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale / 80.0f, this.rotatedNormal, this.rotation, u, v, light, this.field_62633, this.field_62634, this.field_62635, alpha);
    }

    private void putCube(class_11944 renderState, float x, float y, float z, float scale, Vector3f[] rotatedNormal, Quaternionf rotation, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        for (int i = 0; i < rotatedNormal.length; ++i) {
            Vector3f normal = rotatedNormal[i];
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotation.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.95f;
            renderState.method_74323(this.method_74255(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    @Nullable
    private static FBPFlameParticle create(class_638 level, double x, double y, double z, double xd, double zd, float scale, boolean isSoulFire) {
        if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.flame.isSpawnWhileFrozen()) {
            return null;
        }
        class_2680 state = level.method_8320(class_2338.method_49637((double)x, (double)y, (double)z));
        if (state.method_26204() instanceof class_2527 || state.method_26204() instanceof class_5544) {
            y += 0.04;
        }
        return new FBPFlameParticle(level, x, y - 0.06, z, xd, FBPConstants.RANDOM.nextDouble() * 0.025, zd, isSoulFire, !(state.method_26204() instanceof class_2527) && !(state.method_26204() instanceof class_5544)).scale(scale);
    }

    public record SmallFlameProvider() implements class_707<class_2400>
    {
        @Nullable
        public class_703 createParticle(class_2400 type, class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return FBPFlameParticle.create(level, x, y, z, xd, zd, 0.5f, false);
        }
    }

    public record Provider(boolean isSoulFire) implements class_707<class_2400>
    {
        @Nullable
        public class_703 createParticle(class_2400 type, class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return FBPFlameParticle.create(level, x, y, z, xd, zd, 1.0f, this.isSoulFire);
        }
    }
}

