/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.container.ItemFluidInfo;
import techreborn.component.TRDataComponentTypes;
import techreborn.init.TRContent;
import techreborn.init.TRItemSettings;

public class DynamicCellItem
extends class_1792
implements ItemFluidInfo {
    public DynamicCellItem(String name) {
        super(TRItemSettings.item(name).method_7889(16).method_57349(TRDataComponentTypes.FLUID, (Object)class_3612.field_15906.method_40178()));
    }

    private void playEmptyingSound(@Nullable class_1657 playerEntity, class_1936 world, class_2338 blockPos, class_3611 fluid) {
        class_3414 soundEvent = fluid.method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        world.method_8396((class_1297)playerEntity, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
    }

    public static class_1799 getCellWithFluid(class_3611 fluid, int stackSize) {
        Validate.notNull((Object)fluid, (String)"Can't get cell with NULL fluid", (Object[])new Object[0]);
        class_1799 stack = new class_1799((class_1935)TRContent.CELL, stackSize);
        stack.method_57379(TRDataComponentTypes.FLUID, (Object)fluid.method_40178());
        stack.method_7939(stackSize);
        return stack;
    }

    public static class_1799 getCellWithFluid(class_3611 fluid) {
        return DynamicCellItem.getCellWithFluid(fluid, 1);
    }

    public static class_1799 getEmptyCell(int amount) {
        return new class_1799((class_1935)TRContent.CELL, amount);
    }

    private void insertOrDropStack(class_1657 playerEntity, class_3218 world, class_1799 stack) {
        if (!playerEntity.method_31548().method_7394(stack)) {
            playerEntity.method_5775(world, stack);
        }
    }

    public boolean placeFluid(@Nullable class_1657 player, class_1937 world, class_2338 pos, @Nullable class_3965 hitResult, class_1799 filledCell) {
        class_3611 fluid = this.getFluid(filledCell);
        if (fluid == class_3612.field_15906) {
            return false;
        }
        class_2680 blockState = world.method_8320(pos);
        boolean canPlace = blockState.method_26188(fluid);
        if (!(blockState.method_26215() || canPlace || blockState.method_26204() instanceof class_2402 && ((class_2402)blockState.method_26204()).method_10310((class_1309)player, (class_1922)world, pos, blockState, fluid))) {
            return hitResult != null && this.placeFluid(player, world, hitResult.method_17777().method_10093(hitResult.method_17780()), null, filledCell);
        }
        if (world.method_8597().comp_644() && fluid.method_15791(class_3486.field_15517)) {
            int i = pos.method_10263();
            int j = pos.method_10264();
            int k = pos.method_10260();
            world.method_8396((class_1297)player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.method_8406((class_2394)class_2398.field_11237, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
        } else if (blockState.method_26204() instanceof class_2402 && fluid == class_3612.field_15910) {
            if (((class_2402)blockState.method_26204()).method_10311((class_1936)world, pos, blockState, ((class_3609)fluid).method_15729(false))) {
                this.playEmptyingSound(player, (class_1936)world, pos, fluid);
            }
        } else {
            if (!world.method_8608() && canPlace && !blockState.method_51176()) {
                world.method_22352(pos, true);
            }
            this.playEmptyingSound(player, (class_1936)world, pos, fluid);
            world.method_8652(pos, fluid.method_15785().method_15759(), 11);
        }
        return true;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        class_3611 fluid = this.getFluid(itemStack);
        if (fluid != class_3612.field_15906) {
            return class_2561.method_43470((String)class_2561.method_43471((String)"item.techreborn.cell.fluid").getString().replace("$fluid$", FluidUtils.getFluidName((class_3611)fluid)));
        }
        return super.method_7864(itemStack);
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_3611 containedFluid = this.getFluid(stack);
        class_3965 hitResult = DynamicCellItem.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)(containedFluid == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348));
        if (hitResult.method_17783() == class_239.class_240.field_1333 || !(containedFluid instanceof class_3609) && class_3612.field_15906 != containedFluid) {
            return class_1269.field_5811;
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = hitResult.method_17777();
        if (!world.method_8505((class_1297)player, hitPos)) {
            return class_1269.field_5814;
        }
        class_2350 side = hitResult.method_17780();
        class_2338 placePos = hitPos.method_10093(side);
        if (!player.method_7343(placePos, side, stack)) {
            return class_1269.field_5814;
        }
        class_2680 hitState = world.method_8320(hitPos);
        if (containedFluid == class_3612.field_15906) {
            class_2248 class_22482 = hitState.method_26204();
            if (!(class_22482 instanceof class_2263)) {
                return class_1269.field_5814;
            }
            class_2263 fluidDrainable = (class_2263)class_22482;
            class_1799 itemStack = fluidDrainable.method_9700((class_1309)player, (class_1936)world, hitPos, hitState);
            if (!itemStack.method_7960() && itemStack.method_7909() instanceof ItemFluidInfo) {
                class_3611 drainFluid = ((ItemFluidInfo)itemStack.method_7909()).getFluid(itemStack);
                fluidDrainable.method_32351().ifPresent(sound -> player.method_5783(sound, 1.0f, 1.0f));
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28167, hitPos);
                itemStack = DynamicCellItem.getCellWithFluid(drainFluid, 1);
                class_1799 resultStack = class_5328.method_30270((class_1799)stack, (class_1657)player, (class_1799)itemStack, (boolean)false);
                if (resultStack == stack) {
                    return class_1269.field_5812;
                }
                return class_1269.field_5812.method_61393(resultStack);
            }
        } else {
            class_2338 class_23382 = placePos = hitState.method_26204() instanceof class_2402 ? hitPos : placePos;
            if (this.placeFluid(player, world, placePos, hitResult, stack)) {
                if (player.method_31549().field_7477) {
                    return class_1269.field_5812;
                }
                if (stack.method_7947() == 1) {
                    return class_1269.field_5812.method_61393(this.getEmpty());
                }
                stack.method_7934(1);
                if (!world.method_8608()) {
                    this.insertOrDropStack(player, (class_3218)world, this.getEmpty());
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public class_1799 getEmpty() {
        return new class_1799((class_1935)this);
    }

    public class_1799 getFull(class_3611 fluid) {
        return DynamicCellItem.getCellWithFluid(fluid);
    }

    public class_3611 getFluid(class_1799 itemStack) {
        class_6880 fluidEntry = (class_6880)itemStack.method_58695(TRDataComponentTypes.FLUID, (Object)class_3612.field_15906.method_40178());
        return (class_3611)fluidEntry.comp_349();
    }

    public void registerFluidApi() {
        FluidStorage.ITEM.registerForItems((stack, ctx) -> new CellStorage((ContainerItemContext)ctx), new class_1935[]{this});
    }

    public class CellStorage
    extends SingleVariantItemStorage<FluidVariant> {
        public CellStorage(ContainerItemContext context) {
            super(context);
        }

        protected FluidVariant getBlankResource() {
            return FluidVariant.blank();
        }

        protected FluidVariant getResource(ItemVariant currentVariant) {
            Optional registryEntry = currentVariant.getComponents().method_57845(TRDataComponentTypes.FLUID);
            if (registryEntry != null && registryEntry.isPresent()) {
                return FluidVariant.of((class_3611)((class_3611)((class_6880)registryEntry.get()).comp_349()));
            }
            return FluidVariant.of((class_3611)class_3612.field_15906);
        }

        protected long getAmount(ItemVariant currentVariant) {
            return this.getResource(currentVariant).isBlank() ? 0L : 81000L;
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
            if (newAmount != 0L && newAmount != 81000L) {
                throw new IllegalArgumentException("Only amounts of 0 and 1 bucket are supported! This is a bug!");
            }
            if (newResource.isBlank() || newAmount == 0L) {
                return ItemVariant.of((class_1935)DynamicCellItem.this);
            }
            return ItemVariant.of((class_1799)DynamicCellItem.getCellWithFluid(newResource.getFluid()));
        }

        public long insert(FluidVariant insertedResource, long maxAmount, TransactionContext transaction) {
            if (this.isResourceBlank() && maxAmount >= 81000L) {
                return super.insert((TransferVariant)insertedResource, 81000L, transaction);
            }
            return 0L;
        }

        public long extract(FluidVariant extractedResource, long maxAmount, TransactionContext transaction) {
            if (!this.isResourceBlank() && maxAmount >= 81000L) {
                return super.extract((TransferVariant)extractedResource, 81000L, transaction);
            }
            return 0L;
        }
    }
}

