/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import reborncore.common.crafting.RebornFluidRecipe;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.recipe.recipes.BlastFurnaceRecipe;

public class MachineRecipeDisplay<R extends RebornRecipe>
implements Display {
    public static final DisplaySerializer<MachineRecipeDisplay<?>> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("category").forGetter(d -> d.category.getIdentifier().toString()), (App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(MachineRecipeDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(MachineRecipeDisplay::getOutputEntries), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(MachineRecipeDisplay::getDisplayLocation), (App)Codec.INT.fieldOf("energy").forGetter(MachineRecipeDisplay::getEnergy), (App)Codec.INT.fieldOf("heat").forGetter(MachineRecipeDisplay::getHeat), (App)Codec.INT.fieldOf("time").forGetter(MachineRecipeDisplay::getTime), (App)FluidInstance.CODEC.optionalFieldOf("fluidInstance").forGetter(d -> Optional.ofNullable(d.fluidInstance))).apply((Applicative)instance, MachineRecipeDisplay::new)), (class_9139)class_9139.method_65036((class_9139)class_9135.field_48554, d -> d.category.getIdentifier().toString(), (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), MachineRecipeDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), MachineRecipeDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), MachineRecipeDisplay::getDisplayLocation, (class_9139)class_9135.field_49675, MachineRecipeDisplay::getEnergy, (class_9139)class_9135.field_49675, MachineRecipeDisplay::getHeat, (class_9139)class_9135.field_49675, MachineRecipeDisplay::getTime, (class_9139)class_9135.method_56382((class_9139)FluidInstance.PACKET_CODEC), d -> Optional.ofNullable(d.fluidInstance), MachineRecipeDisplay::new));
    private final CategoryIdentifier<?> category;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final Optional<class_2960> location;
    private final int energy;
    private int heat = 0;
    private final int time;
    private FluidInstance fluidInstance = null;

    public MachineRecipeDisplay(String category, List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, int energy, int heat, int time, Optional<FluidInstance> fluidInstance) {
        this.category = CategoryIdentifier.of((String)category);
        this.inputs = inputs;
        this.outputs = outputs;
        this.location = location;
        this.energy = energy;
        this.heat = heat;
        this.time = time;
        this.fluidInstance = fluidInstance.orElse(null);
    }

    public MachineRecipeDisplay(class_8786<R> entry) {
        RebornRecipe recipe = (RebornRecipe)entry.comp_1933();
        this.category = CategoryIdentifier.of((class_2960)Objects.requireNonNull(class_7923.field_41188.method_10221((Object)recipe.method_17716())));
        this.inputs = CollectionUtils.map((Collection)recipe.ingredients(), ing -> EntryIngredients.ofItemStacks((Collection)ing.getPreviewStacks()));
        this.outputs = recipe.outputs().stream().map(EntryIngredients::of).collect(Collectors.toList());
        this.location = Optional.of(entry.comp_1932().method_29177());
        this.time = recipe.time();
        this.energy = recipe.power();
        if (recipe instanceof BlastFurnaceRecipe) {
            this.heat = ((BlastFurnaceRecipe)recipe).getHeat();
        }
        if (recipe instanceof RebornFluidRecipe) {
            this.fluidInstance = ((RebornFluidRecipe)recipe).fluid();
            this.inputs.add(EntryIngredients.of((class_3611)this.fluidInstance.fluid(), (long)this.fluidInstance.getAmount().getRawValue()));
        }
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getTime() {
        return this.time;
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.category;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

