/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import techreborn.recipe.recipes.FluidGeneratorRecipe;

public class FluidGeneratorRecipeDisplay
implements Display {
    public static final DisplaySerializer<FluidGeneratorRecipeDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(FluidGeneratorRecipeDisplay::getInputEntries), (App)Codec.STRING.fieldOf("category").forGetter(d -> d.category.getIdentifier().toString()), (App)Codec.INT.fieldOf("totalEnergy").forGetter(FluidGeneratorRecipeDisplay::getTotalEnergy)).apply((Applicative)instance, FluidGeneratorRecipeDisplay::new)), (class_9139)class_9139.method_56436((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), FluidGeneratorRecipeDisplay::getInputEntries, (class_9139)class_9135.field_48554, d -> d.category.getIdentifier().toString(), (class_9139)class_9135.field_49675, FluidGeneratorRecipeDisplay::getTotalEnergy, FluidGeneratorRecipeDisplay::new));
    private final List<EntryIngredient> inputs;
    private final CategoryIdentifier<?> category;
    private final int totalEnergy;

    public FluidGeneratorRecipeDisplay(List<EntryIngredient> inputs, String category, int totalEnergy) {
        this.inputs = inputs;
        this.category = CategoryIdentifier.of((String)category);
        this.totalEnergy = totalEnergy;
    }

    public FluidGeneratorRecipeDisplay(FluidGeneratorRecipe recipe, class_2960 category) {
        this.category = CategoryIdentifier.of((class_2960)category);
        this.inputs = Lists.newArrayList();
        this.totalEnergy = recipe.power() * 1000;
        this.inputs.add(EntryIngredients.of((class_3611)recipe.getFluid(), (long)1000L));
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return Lists.newArrayList();
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.category;
    }

    public Optional<class_2960> getDisplayLocation() {
        return Optional.empty();
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }
}

