/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.render.entitys;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import techreborn.blockentity.generator.basic.WindMillBlockEntity;

@Environment(value=EnvType.CLIENT)
public class TurbineRenderer
implements class_827<WindMillBlockEntity, TurbineRenderState> {
    private static final Set<class_2350> ALL_DIRECTIONS = EnumSet.allOf(class_2350.class);
    private static final TurbineModel MODEL = TurbineModel.create();
    public static final class_2960 TEXTURE = class_2960.method_60654((String)"techreborn:textures/block/machines/generators/wind_mill_turbine.png");

    public TurbineRenderer(class_5614.class_5615 ctx) {
    }

    @NotNull
    public TurbineRenderState createRenderState() {
        return new TurbineRenderState();
    }

    public void extractRenderState(WindMillBlockEntity blockEntity, TurbineRenderState state, float tickDelta, class_243 vec3, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399((class_2586)blockEntity, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        class_2350 facing = blockEntity.getFacing();
        state.layer = class_1921.method_23572((class_2960)TEXTURE);
        state.rotate = -facing.method_10160().method_10144() + 90.0f;
        state.spin = blockEntity.bladeAngle + tickDelta * blockEntity.spinSpeed;
        state.light = class_761.method_23794((class_1920)blockEntity.method_10997(), (class_2338)blockEntity.method_11016().method_10093(facing));
    }

    public void submit(TurbineRenderState state, class_4587 matrixStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.0, 0.5);
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(state.rotate));
        matrixStack.method_22904(0.0, -1.0, -0.56);
        submitNodeCollector.method_73489((class_3879)MODEL, (Object)Float.valueOf(state.spin), matrixStack, state.layer, state.light, class_4608.field_21444, 0, state.field_62677);
        matrixStack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static class TurbineRenderState
    extends class_11954 {
        public class_1921 layer;
        public float rotate;
        public float spin;
        public int light;
    }

    @Environment(value=EnvType.CLIENT)
    private static class TurbineModel
    extends class_3879<Float> {
        private static TurbineModel create() {
            class_630.class_628[] baseCuboids = new class_630.class_628[]{new class_630.class_628(0, 0, -2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS), new class_630.class_628(0, 6, -1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
            class_630 base = new class_630(Arrays.asList(baseCuboids), (Map)new HashMap<String, class_630>(){
                {
                    class_630.class_628[] blade1Cuboids = new class_630.class_628[]{new class_630.class_628(0, 9, -24.0f, -1.0f, -0.5f, 24.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
                    class_630 blade1 = new class_630(Arrays.asList(blade1Cuboids), Collections.emptyMap());
                    blade1.method_2851(0.0f, 0.0f, 0.0f);
                    TurbineModel.setRotation(blade1, -0.5236f, 0.0f, 0.0f);
                    this.put("blade1", blade1);
                    class_630.class_628[] blade2Cuboids = new class_630.class_628[]{new class_630.class_628(0, 9, -24.0f, -1.0f, -0.5f, 24.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
                    class_630 blade2 = new class_630(Arrays.asList(blade2Cuboids), Collections.emptyMap());
                    blade2.method_2851(0.0f, 0.0f, 0.0f);
                    TurbineModel.setRotation(blade2, -0.5236f, 0.0f, 2.0944f);
                    this.put("blade2", blade2);
                    class_630.class_628[] blade3Cuboids = new class_630.class_628[]{new class_630.class_628(0, 9, -24.0f, -2.0f, -1.075f, 24.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
                    class_630 blade3 = new class_630(Arrays.asList(blade3Cuboids), Collections.emptyMap());
                    blade3.method_2851(0.0f, 0.0f, 0.0f);
                    TurbineModel.setRotation(blade3, -0.5236f, 0.0f, -2.0944f);
                    this.put("blade3", blade3);
                }
            });
            base.method_2851(0.0f, 24.0f, 0.0f);
            return new TurbineModel(base, class_1921::method_23578);
        }

        private static void setRotation(class_630 model, float x, float y, float z) {
            model.field_3654 = x;
            model.field_3675 = y;
            model.field_3674 = z;
        }

        public TurbineModel(class_630 root, Function<class_2960, class_1921> layerFactory) {
            super(root, layerFactory);
        }

        public void setupAnim(Float spin) {
            this.field_54014.field_3674 = spin.floatValue();
        }

        public void method_62100(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
            this.field_54014.method_22698(matrices, vertices, light, overlay);
        }
    }
}

