/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.render;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_10809;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4945;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_796;
import net.minecraft.class_811;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import reborncore.common.fluid.container.ItemFluidInfo;

@Environment(value=EnvType.CLIENT)
public class ItemCellModel
implements class_10439 {
    public static final class_2960 ID = class_2960.method_60655((String)"techreborn", (String)"model/cell");
    public static final class_2960 CELL = class_2960.method_60655((String)"techreborn", (String)"item/cell");
    public static final class_2960 CELL_BASE = CELL.method_48331("_base");
    public static final class_2960 CELL_BACKGROUND = CELL.method_48331("_background");
    public static final class_2960 CELL_GLASS = CELL.method_48331("_glass");
    private final class_1921 layer;
    private final class_10809 settings;
    private final Function<class_3611, Triple<List<class_777>, Supplier<Vector3f[]>, Integer>> bake;
    private final HashMap<class_3611, Triple<List<class_777>, Supplier<Vector3f[]>, Integer>> CACHE_BAKED = new HashMap();

    ItemCellModel(class_10809 modelSettings, Function<class_3611, Triple<List<class_777>, Supplier<Vector3f[]>, Integer>> bakeModel) {
        this.layer = class_4722.method_29382();
        this.settings = modelSettings;
        this.bake = bakeModel;
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 user, int seed) {
        class_3611 class_36112;
        state.method_70946((Object)this);
        class_10444.class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(this.layer);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemFluidInfo) {
            ItemFluidInfo fluidInfo = (ItemFluidInfo)class_17922;
            class_36112 = fluidInfo.getFluid(stack);
        } else {
            class_36112 = class_3612.field_15906;
        }
        class_3611 fluid = class_36112;
        state.method_70946((Object)fluid);
        Triple<List<class_777>, Supplier<Vector3f[]>, Integer> baked = this.CACHE_BAKED.computeIfAbsent(fluid, this.bake);
        layerRenderState.method_67997().addAll((Collection)baked.getLeft());
        layerRenderState.method_67995((Supplier)baked.getMiddle());
        layerRenderState.method_65613((int)1)[0] = (Integer)baked.getRight();
        this.settings.method_68000(layerRenderState, displayContext);
    }

    @Environment(value=EnvType.CLIENT)
    public record Unbaked() implements class_10439.class_10441
    {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(CELL_BASE);
            resolver.markDependency(CELL_BACKGROUND);
            resolver.markDependency(CELL_GLASS);
        }

        @NotNull
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 baseModel = baker.method_45872(CELL_BASE);
            class_10819 backgroundModel = baker.method_45872(CELL_BACKGROUND);
            class_10819 glassModel = baker.method_45872(CELL_GLASS);
            List backgroundQuads = backgroundModel.method_68034(backgroundModel.method_68045(), baker, (class_3665)class_1086.field_5350).method_68048();
            class_10419 modelTextures = baseModel.method_68045();
            class_10809 modelSettings = class_10809.method_68001((class_7775)baker, (class_10819)baseModel, (class_10419)modelTextures);
            List baseQuads = baseModel.method_68034(modelTextures, baker, (class_3665)class_1086.field_5350).method_68048();
            List glassQuads = glassModel.method_68034(glassModel.method_68045(), baker, (class_3665)class_1086.field_5350).method_68048();
            return new ItemCellModel(modelSettings, fluid -> {
                ArrayList<class_777> list = new ArrayList<class_777>(backgroundQuads);
                Pair<class_1058, Integer> pair = Unbaked.parseFluid(fluid);
                if (pair != null) {
                    list.addAll(Unbaked.bakeFluidQuads(baker, backgroundModel, (class_1058)pair.getLeft()));
                    list.addAll(Unbaked.replaceTint(baseQuads, -1));
                    list.addAll(glassQuads);
                    return Triple.of(list, Unbaked.bakeVector(list), (Object)((Integer)pair.getRight()));
                }
                list.addAll(baseQuads);
                list.addAll(glassQuads);
                return Triple.of(list, Unbaked.bakeVector(list), (Object)-1);
            });
        }

        @Nullable
        public static Pair<class_1058, Integer> parseFluid(class_3611 fluid) {
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
            if (handler == null) {
                return null;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                return null;
            }
            class_3610 state = fluid.method_15785();
            int tint = handler.getFluidColor((class_1920)client.field_1687, client.field_1724.method_24515(), state) | 0xFF000000;
            class_1058 sprite = handler.getFluidSprites((class_1920)client.field_1687, class_2338.field_10980, state)[0];
            return Pair.of((Object)sprite, (Object)tint);
        }

        public static List<class_777> bakeFluidQuads(class_7775 baker, class_10819 model, class_1058 sprite) {
            class_4730 texture = new class_4730(sprite.method_45852(), sprite.method_45851().method_45816());
            class_10419.class_10420 textures = new class_10419.class_10420.class_10421().method_65548(class_4945.field_23011.method_25912(), texture).method_65547();
            class_10419 sprites = new class_10419.class_10423().method_65550(textures).method_65551(null);
            class_10817 baked = model.method_68044().bake(sprites, baker, (class_3665)class_1086.field_5350, (class_10813)model);
            return Unbaked.replaceTint(baked.method_68048(), 0);
        }

        public static Supplier<Vector3f[]> bakeVector(List<class_777> quads) {
            HashSet set = new HashSet();
            for (class_777 bakedQuad : quads) {
                class_796.method_67923((int[])bakedQuad.comp_3721(), set::add);
            }
            Vector3f[] vector = (Vector3f[])set.toArray(Vector3f[]::new);
            return () -> vector;
        }

        public static List<class_777> replaceTint(List<class_777> quads, int index) {
            ArrayList<class_777> list = new ArrayList<class_777>(quads.size());
            for (class_777 quad : quads) {
                list.add(new class_777(quad.comp_3721(), index, quad.comp_3723(), quad.comp_3724(), quad.comp_3725(), quad.comp_3726()));
            }
            return list;
        }

        @NotNull
        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }
    }
}

