/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.fluid;

import java.util.List;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9135;
import net.minecraft.class_9334;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.Syncable;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.TechReborn;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class TankUnitBaseBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
IListInfoProvider,
BuiltScreenHandlerProvider {
    protected Tank tank;
    private long serverMaxCapacity = -1L;
    protected final RebornInventory<TankUnitBaseBlockEntity> inventory = new RebornInventory(2, "TankInventory", 64, (MachineBaseBlockEntity)this);
    private TRContent.TankUnit type;

    public TankUnitBaseBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.TANK_UNIT, pos, state);
    }

    public TankUnitBaseBlockEntity(class_2338 pos, class_2680 state, TRContent.TankUnit type) {
        super(TRBlockEntities.TANK_UNIT, pos, state);
        this.configureEntity(type);
    }

    private void configureEntity(TRContent.TankUnit type) {
        this.type = type;
        this.tank = new Tank("TankStorage", this.serverMaxCapacity == -1L ? type.capacity : FluidValue.fromRaw((long)this.serverMaxCapacity));
    }

    protected boolean canDrainTransfer() {
        if (this.inventory == null || this.inventory.method_5439() < 2) {
            return false;
        }
        class_1799 firstStack = this.inventory.method_5438(0);
        if (firstStack.method_7960()) {
            return false;
        }
        class_1799 secondStack = this.inventory.method_5438(1);
        return secondStack.method_7947() < secondStack.method_7914();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        if (this.canDrainTransfer() && FluidUtils.isContainer((class_1799)this.inventory.method_5438(0))) {
            boolean didSomething = FluidUtils.drainContainers((Tank)this.tank, this.inventory, (int)0, (int)1);
            if (!didSomething && FluidUtils.fillContainers((Tank)this.tank, this.inventory, (int)0, (int)1)) {
                didSomething = true;
            }
            if (didSomething) {
                if (this.inventory.method_5438(1).method_7960() && !this.inventory.method_5438(0).method_7960() && this.inventory.method_5438(0).method_7947() == 1) {
                    this.inventory.method_5447(1, this.inventory.method_5438(0));
                    this.inventory.method_5447(0, class_1799.field_8037);
                }
                this.syncWithAll();
            }
        }
        if (this.type == TRContent.TankUnit.CREATIVE && !this.tank.isEmpty() && !this.tank.getFluidAmount().equals((Object)this.tank.getFluidValueCapacity().fraction(2L))) {
            this.tank.setFluidAmount(this.tank.getFluidValueCapacity().fraction(2L));
        }
        if (this.type == TRContent.TankUnit.CREATIVE && this.tank.isFull()) {
            FluidUtils.drainContainers((Tank)this.tank, this.inventory, (int)0, (int)1, (boolean)true);
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        view.method_71441("unitType").ifPresent(name -> {
            this.type = TRContent.TankUnit.valueOf(name);
            this.configureEntity(this.type);
            this.tank.read(view);
        });
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71469("unitType", this.type.name());
        this.tank.write(view);
    }

    public FluidValue fluidTransferAmount() {
        return this.type.capacity.fraction(1200L);
    }

    public RebornInventory<TankUnitBaseBlockEntity> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 playerEntity) {
        class_1799 dropStack = new class_1799((class_1935)this.getBlockType(), 1);
        if (this.field_11863 != null) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), TechReborn.LOGGER);){
                class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.field_11863.method_30349());
                this.method_11007((class_11372)view);
                dropStack.method_57379(class_9334.field_49611, (Object)class_11580.method_72535((Object)this.method_11017(), (class_2487)view.method_71475()));
            }
        }
        return dropStack;
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (isReal || hasData) {
            if (!this.tank.getFluidInstance().isEmpty()) {
                info.add((class_2561)class_2561.method_43470((String)String.valueOf(this.tank.getFluidAmount())).method_10852((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.divider")).method_27693(WordUtils.capitalize((String)FluidUtils.getFluidName((class_3611)this.tank.getFluid()))));
            } else {
                info.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.empty"));
            }
        }
        info.add((class_2561)class_2561.method_43471((String)"techreborn.tooltip.unit.capacity").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.tank.getFluidValueCapacity())).method_27692(class_124.field_1065)));
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("tank").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fluidSlot(0, 100, 53).outputSlot(1, 140, 53).sync((Syncable)this.tank).sync(class_9135.field_48551, this::getMaxCapacity, this::setMaxCapacity).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public long getMaxCapacity() {
        return this.tank.getFluidValueCapacity().getRawValue();
    }

    public void setMaxCapacity(long maxCapacity) {
        FluidInstance instance = this.tank.getFluidInstance();
        this.tank = new Tank("TankStorage", FluidValue.fromRaw((long)maxCapacity));
        this.tank.setFluidInstance(instance);
        this.serverMaxCapacity = maxCapacity;
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

