/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier2;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_9135;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.Syncable;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class PumpBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public static final FluidValue TANK_CAPACITY = FluidValue.BUCKET.multiply(16L);
    public static final int DEFAULT_RANGE = 10;
    public static final int DEFAULT_DEPTH = 10;
    public static final int MIN_RANGE = 0;
    public static final int MIN_DEPTH = 1;
    public static final int MAX_RANGE = 50;
    public static final int MAX_DEPTH = 50;
    private Iterator<class_2338> finder;
    @Nullable
    private Tank tank;
    private boolean exhausted;
    private class_2338 pumpedTargetBlockPos;
    private long timeToPump;
    private int range;
    private int depth;

    public PumpBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.PUMP, pos, state, "Pump", TechRebornConfig.pumpMaxInput, TechRebornConfig.pumpMaxEnergy, TRContent.Machine.PUMP.block, 0);
        this.inventory = new RebornInventory(1, "PumpBlockEntity", 64, (MachineBaseBlockEntity)this);
        this.exhausted = false;
        this.range = 10;
        this.depth = 10;
    }

    public boolean getExhausted() {
        return this.exhausted;
    }

    public void setExhausted(boolean exhausted) {
        this.exhausted = exhausted;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int newRange) {
        if (newRange < 0) {
            newRange = 0;
        }
        if (newRange > 50) {
            newRange = 50;
        }
        if (newRange != this.range) {
            this.range = newRange;
            this.reset();
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int newDepth) {
        if (newDepth < 1) {
            newDepth = 1;
        }
        if (newDepth > 50) {
            newDepth = 50;
        }
        if (newDepth != this.depth) {
            this.depth = newDepth;
            this.reset();
        }
    }

    private void reset() {
        this.finder = null;
        this.exhausted = false;
        this.pumpedTargetBlockPos = null;
        this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    private void setupFinder() {
        this.finder = new BlockPosIterable(this.field_11867, this.range, this.depth).iterator();
    }

    @NotNull
    public Tank getTank() {
        if (this.tank == null) {
            this.tank = this.createTank();
        }
        return this.tank;
    }

    private Tank createTank() {
        return new Tank("PumpBlockEntity", TANK_CAPACITY);
    }

    @Override
    public class_1799 getToolDrop(class_1657 p0) {
        return TRContent.Machine.PUMP.getStack();
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.getTank().read(view);
        this.range = view.method_71424("range", 0);
        this.depth = view.method_71424("depth", 0);
        this.finder = null;
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        this.getTank().write(view);
        view.method_71465("range", this.range);
        view.method_71465("depth", this.depth);
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("pump").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).energySlot(0, 8, 72).sync((Syncable)this.getTank()).syncEnergyValue().sync(class_9135.field_49675, this::getDepth, this::setDepth).sync(class_9135.field_49675, this::getRange, this::setRange).sync(class_9135.field_48547, this::getExhausted, this::setExhausted).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        if (this.exhausted) {
            return;
        }
        if (this.pumpedTargetBlockPos != null) {
            if (world.method_8510() >= this.timeToPump) {
                class_5321 worldRegistryKey;
                if (this.getEnergy() < (long)((double)TechRebornConfig.pumpEnergyToCollect * this.getPowerMultiplier())) {
                    this.timeToPump = world.method_8510() + (long)((double)TechRebornConfig.pumpTicksToComplete * (1.0 - this.getSpeedMultiplier()));
                    return;
                }
                class_2680 blockState = world.method_8320(this.pumpedTargetBlockPos);
                class_3611 fluid = this.getFluid(blockState);
                if (fluid == class_3612.field_15906) {
                    if (!this.isMuffled()) {
                        world.method_8396(null, this.field_11867, class_3417.field_14701, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    this.pumpedTargetBlockPos = null;
                    world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
                    return;
                }
                if (!this.getTank().canFit(fluid, FluidValue.BUCKET)) {
                    this.timeToPump = world.method_8510() + (long)((double)TechRebornConfig.pumpTicksToComplete * (1.0 - this.getSpeedMultiplier()));
                    return;
                }
                if (this.getTank().getFluidInstance().isEmpty()) {
                    this.getTank().setFluidInstance(new FluidInstance(fluid, FluidValue.BUCKET));
                } else {
                    this.getTank().modifyFluid(fluidInstance -> fluidInstance.addAmount(FluidValue.BUCKET));
                }
                if (!this.isMuffled()) {
                    world.method_8396(null, this.field_11867, this.getTank().getFluid().method_32359().orElse(class_3417.field_15126), class_3419.field_15245, 1.0f, 1.0f);
                }
                this.useEnergy((long)((double)TechRebornConfig.pumpEnergyToCollect * this.getPowerMultiplier()));
                class_2371<class_1799> drops = this.getDrops(blockState);
                if (!drops.isEmpty()) {
                    class_1264.method_17349((class_1937)world, (class_2338)this.pumpedTargetBlockPos, drops);
                }
                class_2248 replacementBlock = (worldRegistryKey = world.method_27983()) == class_1937.field_25180 ? class_2246.field_23869 : (worldRegistryKey == class_1937.field_25181 ? class_2246.field_10471 : class_2246.field_10445);
                world.method_8501(this.pumpedTargetBlockPos, replacementBlock.method_9564());
                this.pumpedTargetBlockPos = null;
            }
        } else if (!this.getTank().isFull()) {
            this.findNextToPump(world);
            if (this.pumpedTargetBlockPos != null) {
                this.timeToPump = world.method_8510() + (long)((double)TechRebornConfig.pumpTicksToComplete * (1.0 - this.getSpeedMultiplier()));
            } else {
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
                this.exhausted = true;
            }
        }
    }

    private void findNextToPump(class_1937 world) {
        if (this.finder == null) {
            this.setupFinder();
        }
        while (this.finder.hasNext()) {
            class_2338 blockPos = this.finder.next();
            class_2680 blockState = world.method_8320(blockPos);
            class_3611 fluid = this.getFluid(blockState);
            if (fluid == class_3612.field_15906 || fluid != this.getTank().getFluid() && this.getTank().getFluid() != class_3612.field_15906) continue;
            world.method_8501(this.field_11867, (class_2680)world.method_8320(this.field_11867).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            this.pumpedTargetBlockPos = blockPos;
            return;
        }
    }

    @NotNull
    private class_3611 getFluid(class_2680 blockState) {
        class_3610 fluidState = blockState.method_26227();
        class_3611 fluid = fluidState.method_15772();
        if (fluidState.method_15761() == 8) {
            return fluid;
        }
        return class_3612.field_15906;
    }

    @NotNull
    private class_2371<class_1799> getDrops(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        class_1792 item = block.method_8389();
        if (item == class_1802.field_8162) {
            return class_2371.method_37434((int)0);
        }
        class_1799 itemStack = item.method_7854();
        return class_2371.method_10213((int)1, (Object)itemStack);
    }

    public void handleDepthGuiInputFromClient(int buttonAmount) {
        this.setDepth(this.depth + buttonAmount);
    }

    public void handleRangeGuiInputFromClient(int buttonAmount) {
        this.setRange(this.range + buttonAmount);
    }

    static class BlockPosIterable
    implements Iterable<class_2338> {
        int index = 0;
        final int layerSize;
        final int m;
        final ArrayList<MeasuredPos> layer;

        public BlockPosIterable(class_2338 centerTop, int range, int depth) {
            this.layerSize = (range * 2 + 1) * (range * 2 + 1);
            this.m = this.layerSize * depth;
            this.layer = new ArrayList(this.layerSize);
            for (int i = centerTop.method_10263() - range; i <= centerTop.method_10263() + range; ++i) {
                for (int j = centerTop.method_10260() - range; j <= centerTop.method_10260() + range; ++j) {
                    this.layer.add(new MeasuredPos(i, centerTop.method_10264(), j, centerTop.method_40081((double)i, (double)centerTop.method_10264(), (double)j)));
                }
            }
            this.layer.sort((o1, o2) -> (int)(o1.weight - o2.weight));
        }

        @Override
        @NotNull
        public Iterator<class_2338> iterator() {
            return new Iterator<class_2338>(){

                @Override
                public boolean hasNext() {
                    return index < m;
                }

                @Override
                public class_2338 next() {
                    class_2338 pos = TechRebornConfig.pumpIterateOutwards ? layer.get(index % layerSize).method_10087(1 + index / layerSize) : layer.get((m - index - 1) % layerSize).method_10087(1 + (m - index - 1) / layerSize);
                    ++index;
                    return pos;
                }
            };
        }

        static class MeasuredPos
        extends class_2338 {
            private final double weight;

            public MeasuredPos(int x, int y, int z, double weight) {
                super(x, y, z);
                this.weight = weight;
            }
        }
    }
}

