/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.WorldUtils;
import techreborn.blocks.machine.tier1.ResinBasinBlock;
import techreborn.blocks.misc.BlockRubberLog;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class ResinBasinBlockEntity
extends MachineBaseBlockEntity {
    private class_2350 direction = class_2350.field_11043;
    private boolean isPouring = false;
    private boolean isFull = false;
    private int pouringTimer = 0;

    public ResinBasinBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.RESIN_BASIN, pos, state);
        this.isFull = (Boolean)state.method_11654((class_2769)ResinBasinBlock.FULL);
        if (((Boolean)state.method_11654((class_2769)ResinBasinBlock.POURING)).booleanValue()) {
            this.isPouring = true;
            this.pouringTimer = TechRebornConfig.sapTimeTicks;
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        class_2338 targetRubber;
        boolean readyToHarvest;
        Storage<ItemVariant> invBelow;
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        boolean shouldUpdateState = false;
        if (this.isPouring) {
            --this.pouringTimer;
            if (world.method_8510() % 20L == 0L) {
                world.method_8396(null, pos, ModSounds.SAP_EXTRACT, class_3419.field_15245, 1.0f, 1.0f);
            }
            if (this.pouringTimer <= 0) {
                this.isPouring = false;
                this.isFull = true;
                shouldUpdateState = true;
            }
        }
        if (this.isFull && (invBelow = this.getInventoryBelow()) != null) {
            try (Transaction tx = Transaction.openOuter();){
                int sentAmount = this.getSapAmount();
                if (invBelow.insert((Object)ItemVariant.of((class_1935)TRContent.Parts.SAP), (long)sentAmount, (TransactionContext)tx) > 0L) {
                    tx.commit();
                    this.isFull = false;
                    shouldUpdateState = true;
                }
            }
        }
        boolean bl = readyToHarvest = !this.isFull && !this.isPouring;
        if ((readyToHarvest || world.method_8510() % 20L == 0L) && !this.validPlacement()) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
            WorldUtils.dropItem((class_1792)TRContent.Machine.RESIN_BASIN.method_8389(), (class_1937)world, (class_2338)pos);
            return;
        }
        if (readyToHarvest && world.method_8510() % (long)TechRebornConfig.checkForSapTime == 0L && (targetRubber = this.getLogWithSap()) != null) {
            world.method_8501(targetRubber, (class_2680)((class_2680)world.method_8320(targetRubber).method_11657((class_2769)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(false))).method_11657(BlockRubberLog.SAP_SIDE, (Comparable)class_2350.method_10139((int)0)));
            this.isPouring = true;
            this.pouringTimer = TechRebornConfig.sapTimeTicks;
            shouldUpdateState = true;
        }
        if (shouldUpdateState) {
            this.setPouringState(this.isPouring);
            this.setFullState(this.isFull);
        }
    }

    public int getSapAmount() {
        if (!this.isFull) {
            return 0;
        }
        return Math.random() <= 0.5 ? 1 : 2;
    }

    public class_1799 empty() {
        if (this.isFull) {
            int sapAmount = this.getSapAmount();
            this.isPouring = false;
            this.isFull = false;
            this.setFullState(false);
            this.setPouringState(false);
            return new class_1799((class_1935)TRContent.Parts.SAP, sapAmount);
        }
        return new class_1799((class_1935)TRContent.Parts.SAP, 0);
    }

    public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState) {
        super.onBreak(world, playerEntity, blockPos, blockState);
        if (this.isFull) {
            class_1799 out = new class_1799((class_1935)TRContent.Parts.SAP, this.getSapAmount());
            WorldUtils.dropItem((class_1799)out, (class_1937)world, (class_2338)this.field_11867);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.direction = ((class_2350)this.field_11863.method_8320(this.field_11867).method_11654(ResinBasinBlock.FACING)).method_10153();
    }

    private Storage<ItemVariant> getInventoryBelow() {
        return (Storage)ItemStorage.SIDED.find(this.method_10997(), this.field_11867.method_10093(class_2350.field_11033), (Object)class_2350.field_11036);
    }

    private boolean validPlacement() {
        return this.field_11863.method_8320(this.field_11867.method_10093(this.direction)).method_26204() == TRContent.RUBBER_LOG;
    }

    private class_2338 getLogWithSap() {
        class_2680 state;
        class_2338 originPos = this.field_11867.method_10093(this.direction);
        class_2680 originState = this.field_11863.method_8320(originPos);
        if (((Boolean)originState.method_11654((class_2769)BlockRubberLog.HAS_SAP)).booleanValue()) {
            return originPos;
        }
        boolean shouldExit = false;
        class_2338 current = originPos;
        while (!shouldExit) {
            state = this.field_11863.method_8320(current = current.method_10093(class_2350.field_11036));
            if (state.method_26204() == TRContent.RUBBER_LOG) {
                if (!((Boolean)state.method_11654((class_2769)BlockRubberLog.HAS_SAP)).booleanValue()) continue;
                return current;
            }
            shouldExit = true;
        }
        current = originPos;
        shouldExit = false;
        while (!shouldExit) {
            state = this.field_11863.method_8320(current = current.method_10093(class_2350.field_11033));
            if (state.method_26204() == TRContent.RUBBER_LOG) {
                if (!((Boolean)state.method_11654((class_2769)BlockRubberLog.HAS_SAP)).booleanValue()) continue;
                return current;
            }
            shouldExit = true;
        }
        return null;
    }

    private void setPouringState(boolean value) {
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)ResinBasinBlock.POURING, (Comparable)Boolean.valueOf(value)));
        }
    }

    private void setFullState(boolean value) {
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)ResinBasinBlock.FULL, (Comparable)Boolean.valueOf(value)));
        }
    }

    public boolean hasSlotConfig() {
        return false;
    }

    public boolean canBeUpgraded() {
        return false;
    }
}

