/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_9135;
import net.minecraft.class_9902;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.WorldUtils;
import techreborn.blocks.machine.tier1.PlayerDetectorBlock;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class PlayerDetectorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
BuiltScreenHandlerProvider {
    public String ownerUdid = "";
    boolean redstone = false;
    int radius = 16;

    public PlayerDetectorBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.PLAYER_DETECTOR, pos, state);
    }

    public boolean isProvidingPower() {
        return this.redstone;
    }

    public void handleGuiInputFromClient(int amount) {
        this.radius += amount;
        if (this.radius > TechRebornConfig.playerDetectorMaxRadius) {
            this.radius = TechRebornConfig.playerDetectorMaxRadius;
        }
        if (this.radius <= 1) {
            this.radius = 1;
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        if (world.method_8510() % 20L != 0L) {
            return;
        }
        boolean lastRedstone = this.redstone;
        this.redstone = false;
        if (this.getStored() > (long)TechRebornConfig.playerDetectorEuPerTick) {
            for (class_1657 player : world.method_18456()) {
                if (player.method_7325() || !(class_3532.method_15355((float)((float)player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)))) <= (float)this.radius)) continue;
                PlayerDetectorBlock.PlayerDetectorType type = (PlayerDetectorBlock.PlayerDetectorType)((Object)world.method_8320(pos).method_11654(PlayerDetectorBlock.TYPE));
                if (type == PlayerDetectorBlock.PlayerDetectorType.ALL) {
                    this.redstone = true;
                    continue;
                }
                if (type == PlayerDetectorBlock.PlayerDetectorType.OTHERS) {
                    if (this.ownerUdid.isEmpty() || this.ownerUdid.equals(player.method_5667().toString())) continue;
                    this.redstone = true;
                    continue;
                }
                if (this.ownerUdid.isEmpty() || !this.ownerUdid.equals(player.method_5667().toString())) continue;
                this.redstone = true;
            }
            this.useEnergy(TechRebornConfig.playerDetectorEuPerTick);
        }
        if (lastRedstone != this.redstone) {
            WorldUtils.updateBlock((class_1937)world, (class_2338)pos);
            world.method_8452(pos, world.method_8320(pos).method_26204(), class_9902.method_61826((class_1937)world, null, null));
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.playerDetectorMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.playerDetectorMaxInput;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.ownerUdid = view.method_71428("ownerID", "");
        this.radius = view.method_71424("radius", 0);
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71469("ownerID", this.ownerUdid);
        view.method_71465("radius", this.radius);
    }

    public boolean hasSlotConfig() {
        return false;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return TRContent.Machine.PLAYER_DETECTOR.getStack();
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("player_detector").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).syncEnergyValue().sync(class_9135.field_49675, this::getCurrentRadius, this::setCurrentRadius).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getCurrentRadius() {
        return this.radius;
    }

    public void setCurrentRadius(int radius) {
        this.radius = radius;
    }
}

