/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class ElevatorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
BuiltScreenHandlerProvider {
    public ElevatorBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.ELEVATOR, pos, state);
    }

    public boolean isRunning(class_2338 targetPos) {
        class_2586 entity = this.method_10997().method_8321(targetPos);
        if (!(entity instanceof ElevatorBlockEntity)) {
            return false;
        }
        return ((ElevatorBlockEntity)entity).getStored() > 0L;
    }

    public boolean isAirOrElevator(class_2338 targetPos) {
        return this.method_10997().method_22347(targetPos) || this.method_10997().method_8321(targetPos) instanceof ElevatorBlockEntity;
    }

    public boolean isFree(class_2338 targetPos) {
        return this.method_10997().method_8320(targetPos.method_10084()).method_26215() && this.method_10997().method_8320(targetPos.method_10084().method_10084()).method_26215();
    }

    public boolean isValidTarget(class_2338 targetPos) {
        return this.isRunning(targetPos) && this.isFree(targetPos);
    }

    public Optional<class_2338> nextUpElevator() {
        class_2338 upPos = this.method_11016().method_10084().method_10084();
        if (!(TechRebornConfig.allowElevatingThroughBlocks || this.isAirOrElevator(this.method_11016().method_10084()) && this.isAirOrElevator(this.method_11016().method_10084().method_10084()))) {
            return Optional.empty();
        }
        do {
            upPos = upPos.method_10084();
            if (TechRebornConfig.allowElevatingThroughBlocks || this.isAirOrElevator(upPos)) continue;
            return Optional.empty();
        } while (upPos.method_10264() <= this.method_10997().method_31600() && !this.isValidTarget(upPos));
        if (upPos.method_10264() < this.method_10997().method_31600() || this.isValidTarget(upPos)) {
            return Optional.of(upPos);
        }
        return Optional.empty();
    }

    public Optional<class_2338> nextDownElevator() {
        class_2338 downPos = this.method_11016().method_10074().method_10074();
        if (!(TechRebornConfig.allowElevatingThroughBlocks || this.isAirOrElevator(this.method_11016().method_10074()) && this.isAirOrElevator(this.method_11016().method_10074().method_10074()))) {
            return Optional.empty();
        }
        do {
            downPos = downPos.method_10074();
            if (TechRebornConfig.allowElevatingThroughBlocks || this.isAirOrElevator(downPos)) continue;
            return Optional.empty();
        } while (downPos.method_10264() >= this.method_10997().method_31607() && !this.isValidTarget(downPos));
        if (downPos.method_10264() > this.method_10997().method_31607() || this.isValidTarget(downPos)) {
            return Optional.of(downPos);
        }
        return Optional.empty();
    }

    public int energyCost(class_2338 targetPos) {
        return Math.max(Math.abs(targetPos.method_10264() - this.method_11016().method_10264()) * TechRebornConfig.elevatorEnergyPerBlock, 0);
    }

    protected boolean teleport(class_1657 player, class_2338 targetPos) {
        if (!(this.method_10997() instanceof class_3218)) {
            return false;
        }
        int energy = this.energyCost(targetPos);
        if (this.getStored() < (long)energy) {
            return false;
        }
        this.playTeleportSoundAt(this.method_11016());
        player.method_5731(new class_5454((class_3218)this.method_10997(), class_243.method_24955((class_2382)new class_2382(targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260())), class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245));
        this.useEnergy(energy);
        this.playTeleportSoundAt(targetPos);
        return true;
    }

    protected void playTeleportSoundAt(class_2338 targetPos) {
        this.method_10997().method_8396(null, targetPos, class_3417.field_14879, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void teleportUp(class_1657 player) {
        if (!this.field_11867.method_19769((class_2374)player.method_73189(), 5.0) && player.method_73183() == this.field_11863) {
            return;
        }
        Optional<class_2338> upTarget = this.nextUpElevator();
        if (upTarget.isEmpty()) {
            return;
        }
        if (this.teleport(player, upTarget.get().method_10084())) {
            player.method_6100(false);
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (!(world instanceof class_3218) || this.getStored() <= 0L || !this.isActive(RedstoneConfiguration.Element.POWER_IO)) {
            return;
        }
        Optional<class_2338> downTarget = null;
        List players = world.method_18467(class_1657.class, new class_238(0.0, 1.0, 0.0, 1.0, 2.0, 1.0).method_996(pos));
        if (players.size() == 0) {
            return;
        }
        for (class_1657 player : players) {
            if (!player.method_5715()) continue;
            if (downTarget == null) {
                downTarget = this.nextDownElevator();
            }
            if (downTarget.isEmpty() || !this.teleport(player, downTarget.get().method_10084())) continue;
            player.method_5660(false);
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.elevatorMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.elevatorMaxInput;
    }

    public boolean hasSlotConfig() {
        return false;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public class_1799 getToolDrop(class_1657 p0) {
        return TRContent.Machine.ELEVATOR.getStack();
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("elevator").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).syncEnergyValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

