/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9323;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class AutoCraftingTableBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public static final int CRAFTING_HEIGHT = 3;
    public static final int CRAFTING_WIDTH = 3;
    public static final int CRAFTING_AREA = 9;
    public static final int RECIPE_TIME = 120;
    public static final int EU_TICK = 10;
    public final RebornInventory<AutoCraftingTableBlockEntity> inventory;
    private final BalanceTable balanceTable = new BalanceTable();
    private final int OUTPUT_SLOT = 9;
    private final int EXTRA_OUTPUT_SLOT = 10;
    public int progress = 0;
    public int maxProgress = 120;
    public long euTick = 10L;
    public long lastSoundTime = 0L;
    class_1715 inventoryCrafting;
    class_3955 lastRecipe = null;
    class_1799 outputPreview = class_1799.field_8037;
    public boolean locked = false;

    public AutoCraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.AUTO_CRAFTING_TABLE, pos, state);
        this.inventoryCrafting = new class_1715(new class_1703(this, null, -1){

            public class_1799 method_7601(class_1657 player, int index) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 playerIn) {
                return false;
            }
        }, 3, 3);
        this.inventory = new RebornInventory<AutoCraftingTableBlockEntity>(11, "AutoCraftingTableBlockEntity", 64, this){

            private void syncStack(int slot, class_1799 stack) {
                if (slot < 9) {
                    AutoCraftingTableBlockEntity.this.inventoryCrafting.method_5447(slot, stack);
                }
            }

            public void readData(class_11368 view) {
                super.readData(view);
                for (int i = 0; i < 9; ++i) {
                    AutoCraftingTableBlockEntity.this.inventoryCrafting.method_5447(i, AutoCraftingTableBlockEntity.this.inventory.method_5438(i));
                }
            }

            public void method_5447(int slot, @NotNull class_1799 stack) {
                super.method_5447(slot, stack);
                this.syncStack(slot, stack);
            }

            public class_1799 method_5441(int i) {
                this.syncStack(i, class_1799.field_8037);
                return super.method_5441(i);
            }

            public class_1799 method_5434(int i, int i1) {
                class_1799 stack = super.method_5434(i, i1);
                if (this.method_5438(i).method_7960()) {
                    this.syncStack(i, class_1799.field_8037);
                }
                return stack;
            }

            public class_1799 shrinkSlot(int slot, int count) {
                class_1799 stack = super.shrinkSlot(slot, count);
                if (this.method_5438(slot).method_7960()) {
                    this.syncStack(slot, class_1799.field_8037);
                }
                return stack;
            }
        };
    }

    public boolean updateCurrentRecipe(class_3218 world, class_9694 input) {
        if (this.lastRecipe != null && this.lastRecipe.method_8115((class_9695)input, (class_1937)world)) {
            if (this.outputPreview == class_1799.field_8037) {
                this.balanceTable.updateLayout(input);
                this.outputPreview = this.lastRecipe.method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
            } else if (this.lastRecipe instanceof class_1852 && this.balanceTable.updateLayout(input)) {
                this.outputPreview = this.lastRecipe.method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
            }
            return true;
        }
        if (this.balanceTable.updateLayout(input)) {
            Optional<class_3955> testRecipe = world.method_64577().method_8132(class_3956.field_17545, (class_9695)input, (class_1937)world).map(class_8786::comp_1933);
            if (testRecipe.isPresent()) {
                this.lastRecipe = testRecipe.get();
                this.outputPreview = this.lastRecipe.method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
                return true;
            }
            this.outputPreview = class_1799.field_8037;
        }
        return false;
    }

    @Nullable
    private class_1799 getRecipeReminder(class_9694 input) {
        class_2371 remainingStacks = this.lastRecipe.method_17704(input);
        class_1799 recipeReminder = class_1799.field_8037;
        int size = remainingStacks.size();
        for (int slot = 0; slot < size; ++slot) {
            class_1799 reminderStack = (class_1799)remainingStacks.get(slot);
            if (reminderStack.method_7960()) continue;
            recipeReminder = reminderStack.method_7972();
            ++slot;
            while (slot < size) {
                reminderStack = (class_1799)remainingStacks.get(slot);
                if (!reminderStack.method_7960()) {
                    if (class_1799.method_31577((class_1799)recipeReminder, (class_1799)reminderStack)) {
                        recipeReminder.method_7933(reminderStack.method_7947());
                    } else {
                        return null;
                    }
                }
                ++slot;
            }
            break;
        }
        return recipeReminder;
    }

    private void make(class_9694.class_9765 positioned, class_1799 resultStack, class_1799 remainderStack) {
        class_9694 input = positioned.comp_2795();
        int width = input.method_59991();
        int max = (positioned.comp_2797() + input.method_59992()) * 3;
        int space = 3 - width;
        for (int slot = positioned.comp_2797() * 3 + positioned.comp_2796(); slot < max; slot += space) {
            int end = slot + width;
            while (slot < end) {
                if (!this.inventory.method_5438(slot).method_7960()) {
                    this.inventory.shrinkSlot(slot, 1);
                }
                ++slot;
            }
        }
        this.moveOutput(resultStack, 9);
        if (!remainderStack.method_7960()) {
            this.moveOutput(remainderStack, 10);
        }
        this.inventory.resetHasChanged();
    }

    private boolean hasOutputSpace(class_1799 output, int slot) {
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)stack, (class_1799)output, (boolean)true, (boolean)true)) {
            return stack.method_7914() >= stack.method_7947() + output.method_7947();
        }
        return false;
    }

    private void moveOutput(class_1799 stack, int slot) {
        class_1799 currentOutput = this.inventory.method_5438(slot);
        if (currentOutput.method_7960()) {
            this.inventory.method_5447(slot, stack.method_7972());
        } else {
            currentOutput.method_7933(stack.method_7947());
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        class_1799 recipeReminder;
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608() || this.getStored() < this.euTick) {
            return;
        }
        if (this.inventoryCrafting.method_5442()) {
            this.progress = 0;
            this.outputPreview = class_1799.field_8037;
            return;
        }
        class_9694.class_9765 positioned = this.inventoryCrafting.method_60501();
        class_9694 input = positioned.comp_2795();
        if (!this.updateCurrentRecipe((class_3218)world, input)) {
            this.progress = 0;
            return;
        }
        if (!this.hasOutputSpace(this.outputPreview, 9)) {
            return;
        }
        this.balanceTable.balance(this.inventory, input);
        if (this.locked) {
            for (class_1799 stack : input.method_59989()) {
                if (stack.method_7947() != 1) continue;
                return;
            }
        }
        if ((recipeReminder = this.getRecipeReminder(input)) == null || !this.hasOutputSpace(recipeReminder, 10)) {
            return;
        }
        if (this.progress >= this.maxProgress) {
            this.progress = 0;
            this.make(positioned, this.outputPreview, recipeReminder);
            if (this.inventoryCrafting.method_5442()) {
                this.outputPreview = class_1799.field_8037;
            }
        } else {
            long time;
            if (this.progress == 0) {
                this.maxProgress = Math.max((int)(120.0 * (1.0 - this.getSpeedMultiplier())), 1);
                this.euTick = this.getEuPerTick(10L);
                if (this.getStored() < this.euTick) {
                    return;
                }
            }
            ++this.progress;
            if (!this.isMuffled() && (time = world.method_8510()) - this.lastSoundTime > 120L) {
                this.lastSoundTime = time;
                world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ModSounds.AUTO_CRAFTING, class_3419.field_15245, 0.3f, 0.8f);
            }
            this.useEnergy(this.euTick);
        }
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.autoCraftingTableMaxEnergy;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.autoCraftingTableMaxInput;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public void method_11007(class_11372 view) {
        view.method_71472("locked", this.locked);
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        this.locked = view.method_71433("locked", false);
        super.method_11014(view);
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.AUTO_CRAFTING_TABLE.getStack();
    }

    public RebornInventory<AutoCraftingTableBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("autocraftingtable").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).outputSlot(10, 145, 70).syncEnergyValue().sync(class_9135.field_49675, this::getProgress, this::setProgress).sync(class_9135.field_49675, this::getMaxProgress, this::setMaxProgress).sync(class_9135.field_49675, this::getLockedInt, this::setLockedInt).sync(class_1799.field_49268, this::getOutputPreview, this::setOutputPreview).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public class_1799 getOutputPreview() {
        return this.outputPreview;
    }

    public void setOutputPreview(class_1799 stack) {
        this.outputPreview = stack;
    }

    static class BalanceTable {
        private class_1792[] layout = new class_1792[0];
        private BalanceEntry entry = new BalanceEntry();
        private final Map<BalanceEntry, ArrayList<Integer>> ingredients = new HashMap<BalanceEntry, ArrayList<Integer>>();
        private Iterator<BalanceEntry> iterator = null;
        private boolean empty = true;
        private boolean needsMatch = false;

        BalanceTable() {
        }

        public boolean updateLayout(class_9694 input) {
            int i;
            int size = input.method_59983();
            class_1799[] stacks = new class_1799[size];
            class_1792[] items = new class_1792[size];
            boolean same = size == this.layout.length;
            for (i = 0; i < size; ++i) {
                stacks[i] = input.method_59984(i);
                items[i] = stacks[i].method_7909();
                if (!same || this.layout[i] == items[i]) continue;
                same = false;
            }
            if (same) {
                return false;
            }
            this.layout = items;
            this.ingredients.clear();
            this.entry.resetMatch();
            for (i = 0; i < size; ++i) {
                if (items[i] == class_1802.field_8162) continue;
                this.entry.setItem(items[i]);
                this.entry.setComponents(stacks[i].method_57353());
                this.ingredients.computeIfAbsent(this.entry, this::createSlots).add(i);
            }
            this.ingredients.values().removeIf(this::checkInvalid);
            this.empty = this.ingredients.isEmpty();
            if (!this.empty) {
                this.iterator = this.ingredients.keySet().stream().toList().iterator();
                this.entry = this.iterator.next();
                this.needsMatch = true;
            }
            return true;
        }

        private ArrayList<Integer> createSlots(BalanceEntry _entry) {
            this.entry = new BalanceEntry();
            return new ArrayList<Integer>(this.layout.length);
        }

        private boolean checkInvalid(ArrayList<Integer> list) {
            return list.size() == 1;
        }

        public void balance(RebornInventory<AutoCraftingTableBlockEntity> inventory, class_9694 input) {
            if (this.empty) {
                return;
            }
            if (!this.needsMatch) {
                if (!inventory.hasChanged()) {
                    return;
                }
                inventory.resetHasChanged();
                this.needsMatch = true;
            }
            List list = this.ingredients.get(this.entry);
            int min = Integer.MAX_VALUE;
            int max = 0;
            class_1799 minStack = null;
            class_1799 maxStack = null;
            for (Integer slot : list) {
                class_1799 itemStack = input.method_59984(slot.intValue());
                int count = itemStack.method_7947();
                if (min > count) {
                    min = count;
                    minStack = itemStack;
                }
                if (max >= count) continue;
                max = count;
                maxStack = itemStack;
            }
            if (max > min + 1) {
                assert (minStack != null && maxStack != null);
                maxStack.method_7934(1);
                minStack.method_7933(1);
                inventory.resetHasChanged();
                inventory.method_5431();
            } else {
                this.entry.stopMatch();
            }
            this.checkState(this.entryNext());
        }

        private boolean entryNext() {
            if (!this.iterator.hasNext()) {
                this.iterator = this.ingredients.keySet().stream().toList().iterator();
            }
            this.entry = this.iterator.next();
            return this.entry.needsMatch;
        }

        private void checkState(boolean needsMatch) {
            if (!needsMatch) {
                for (int i = this.ingredients.size() - 1; i > 0; --i) {
                    if (!this.entryNext()) continue;
                    return;
                }
                this.needsMatch = false;
                this.ingredients.keySet().forEach(BalanceEntry::resetMatch);
            }
        }
    }

    static class BalanceEntry {
        public class_1792 item = null;
        public class_9323 components = null;
        public boolean needsMatch = true;

        BalanceEntry() {
        }

        public void setItem(class_1792 item) {
            this.item = item;
        }

        public void setComponents(class_9323 components) {
            this.components = components;
        }

        public void stopMatch() {
            this.needsMatch = false;
        }

        public void resetMatch() {
            this.needsMatch = true;
        }

        public boolean equals(Object o) {
            if (o instanceof BalanceEntry) {
                BalanceEntry entry = (BalanceEntry)o;
                return this.item == entry.item && Objects.equals(this.components, entry.components);
            }
            if (o instanceof class_1799) {
                class_1799 stack = (class_1799)o;
                return this.item == stack.method_7909() && Objects.equals(this.components, stack.method_57353());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.item, this.components);
        }
    }
}

