/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.multiblock;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.Syncable;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.IInventoryAccess;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class FluidReplicatorBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public static final FluidValue TANK_CAPACITY = FluidValue.BUCKET.multiply(16L);
    public final Tank tank;
    int ticksSinceLastChange;

    public FluidReplicatorBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.FLUID_REPLICATOR, pos, state, "FluidReplicator", TechRebornConfig.fluidReplicatorMaxInput, TechRebornConfig.fluidReplicatorMaxEnergy, TRContent.Machine.FLUID_REPLICATOR.block, 3);
        this.inventory = new RebornInventory(4, "FluidReplicatorBlockEntity", 64, (MachineBaseBlockEntity)this, FluidReplicatorBlockEntity.getInventoryAccess());
        this.crafter = new RecipeCrafter(ModRecipes.FLUID_REPLICATOR, (class_2586)this, 1, 0, this.inventory, new int[]{0}, null);
        this.tank = new Tank("FluidReplicatorBlockEntity", TANK_CAPACITY);
    }

    public boolean hasMultiblock() {
        return true;
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2248 block = TRContent.MachineBlocks.ADVANCED.getCasing();
        writer.translate(1, 0, -1).ring(class_2350.class_2351.field_11052, 3, 0, 3, (v, p) -> v.method_8320(p).method_27852(block), block.method_9564(), null, null);
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange >= 10) {
            if (!this.inventory.method_5438(1).method_7960()) {
                FluidUtils.fillContainers((Tank)this.tank, (class_1263)this.inventory, (int)1, (int)2);
                if (this.tank.isEmpty()) {
                    this.tank.setFluid(class_3612.field_15906);
                }
            }
            this.ticksSinceLastChange = 0;
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.tank.read(view);
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        this.tank.write(view);
    }

    private static IInventoryAccess<FluidReplicatorBlockEntity> getInventoryAccess() {
        return (slotID, stack, face, direction, blockEntity) -> {
            if (slotID == 0) {
                return stack.method_31574(TRContent.Parts.UU_MATTER.getStack().method_7909());
            }
            return true;
        };
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("fluidreplicator").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fluidSlot(1, 124, 35).filterSlot(0, 55, 45, stack -> stack.method_31574(TRContent.Parts.UU_MATTER.getStack().method_7909())).outputSlot(2, 124, 55).energySlot(3, 8, 72).sync((Syncable)this.tank).syncEnergyValue().syncCrafterValue().syncShapeValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

