/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.iron;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.iron.AbstractIronMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class IronFurnaceBlockEntity
extends AbstractIronMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int FUEL_SLOT = 2;
    public float experience;
    private boolean previousValid = false;
    private class_1799 previousStack = class_1799.field_8037;
    private class_8786<class_3861> lastRecipe = null;
    private int recipeCookingTime = 200;

    public IronFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.IRON_FURNACE, pos, state, 2, TRContent.Machine.IRON_FURNACE.block);
        this.inventory = new RebornInventory(3, "IronFurnaceBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public void handleGuiInputFromClient(class_1657 playerIn) {
        if (playerIn instanceof class_3222) {
            int expToDrop;
            class_3222 player = (class_3222)playerIn;
            for (int totalExperience = (int)this.experience; totalExperience > 0; totalExperience -= expToDrop) {
                expToDrop = class_1303.method_5918((int)totalExperience);
                player.method_51469().method_8649((class_1297)new class_1303((class_1937)player.method_51469(), player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, expToDrop));
            }
        }
        this.experience = 0.0f;
    }

    @Nullable
    private class_8786<class_3861> refreshRecipe(class_1799 stack) {
        if (this.field_11863 == null) {
            return this.lastRecipe;
        }
        if (this.lastRecipe != null && ((class_3861)this.lastRecipe.comp_1933()).method_64719(new class_9696(stack), this.field_11863)) {
            return this.lastRecipe;
        }
        MinecraftServer server = this.field_11863.method_8503();
        if (server == null) {
            return this.lastRecipe;
        }
        this.progress = 0;
        class_8786 matchingRecipe = server.method_3772().method_8132(class_3956.field_17546, (class_9695)new class_9696(stack), this.field_11863).orElse(null);
        if (matchingRecipe != null) {
            this.lastRecipe = matchingRecipe;
            this.recipeCookingTime = ((class_3861)matchingRecipe.comp_1933()).method_8167();
        } else {
            this.recipeCookingTime = 200;
        }
        return this.lastRecipe;
    }

    private class_1799 getResultFor(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.previousStack.method_31574(stack.method_7909()) && !this.previousValid) {
            return class_1799.field_8037;
        }
        class_8786<class_3861> matchingRecipe = this.refreshRecipe(stack);
        if (matchingRecipe != null) {
            return ((class_3861)matchingRecipe.comp_1933()).method_59998(new class_9696(stack), (class_7225.class_7874)this.method_10997().method_30349()).method_7972();
        }
        return class_1799.field_8037;
    }

    private float getExperienceFor() {
        if (this.field_11863 == null) {
            return 0.0f;
        }
        MinecraftServer server = this.field_11863.method_8503();
        if (server == null) {
            return 0.0f;
        }
        Optional<class_3861> recipe = server.method_3772().method_8132(class_3956.field_17546, (class_9695)new class_9696(this.inventory.method_5438(0)), this.field_11863).map(class_8786::comp_1933);
        return recipe.map(class_1874::method_8171).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    protected void smelt() {
        if (!this.canSmelt()) {
            return;
        }
        class_1799 inputStack = this.inventory.method_5438(0);
        class_1799 resultStack = this.getResultFor(inputStack);
        if (this.inventory.method_5438(1).method_7960()) {
            this.inventory.method_5447(1, resultStack.method_7972());
        } else if (this.inventory.method_5438(1).method_31574(resultStack.method_7909())) {
            this.inventory.method_5438(1).method_7933(resultStack.method_7947());
        }
        this.experience += this.getExperienceFor();
        if (inputStack.method_7947() > 1) {
            this.inventory.shrinkSlot(0, 1);
        } else {
            this.inventory.method_5447(0, class_1799.field_8037);
        }
    }

    @Override
    protected boolean canSmelt() {
        class_1799 outputStack;
        class_1799 inputStack = this.inventory.method_5438(0);
        if (inputStack.method_7960()) {
            return false;
        }
        if (this.previousStack != inputStack) {
            this.previousStack = inputStack;
            this.previousValid = true;
        }
        if ((outputStack = this.getResultFor(inputStack)).method_7960()) {
            this.previousValid = false;
            return false;
        }
        this.previousValid = true;
        class_1799 outputSlotStack = this.inventory.method_5438(1);
        if (outputSlotStack.method_7960()) {
            return true;
        }
        if (!outputSlotStack.method_31574(outputStack.method_7909())) {
            return false;
        }
        int result = outputSlotStack.method_7947() + outputStack.method_7947();
        return result <= this.inventory.getStackLimit() && result <= outputStack.method_7914();
    }

    @Override
    protected int cookingTime() {
        return (int)((double)this.recipeCookingTime / TechRebornConfig.cookingScale);
    }

    public boolean isStackValid(int slotID, class_1799 stack) {
        return !this.getResultFor(stack).method_7960();
    }

    @Override
    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.experience = view.method_71423("Experience", 0.0f);
    }

    @Override
    public void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71464("Experience", this.experience);
    }

    public float getExperience() {
        return this.experience;
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public int[] getInputSlots() {
        return new int[]{0};
    }

    public int getRecipeCookingTime() {
        return this.recipeCookingTime;
    }

    public void setRecipeCookingTime(int recipeCookingTime) {
        this.recipeCookingTime = recipeCookingTime;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("ironfurnace").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fuelSlot(2, 56, 53).slot(0, 56, 17).outputSlot(1, 116, 35).sync(class_9135.field_49675, this::getBurnTime, this::setBurnTime).sync(class_9135.field_49675, this::getProgress, this::setProgress).sync(class_9135.field_49675, this::getTotalBurnTime, this::setTotalBurnTime).sync(class_9135.field_48552, this::getExperience, this::setExperience).sync(class_9135.field_49675, this::getRecipeCookingTime, this::setRecipeCookingTime).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

