/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.generator;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.fluid.FluidValue;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.recipe.recipes.FluidGeneratorRecipe;

public abstract class BaseFluidGeneratorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider {
    private final int euTick;
    private final class_3956<FluidGeneratorRecipe> recipeType;
    private int ticksSinceLastChange;
    public final Tank tank;
    public final RebornInventory<?> inventory;
    protected long lastOutput = 0L;
    private FluidGeneratorRecipe currentRecipe = null;
    double pendingWithdraw = 0.0;

    public BaseFluidGeneratorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state, class_3956<FluidGeneratorRecipe> type, String blockEntityName, FluidValue tankCapacity, int euTick) {
        super(blockEntityType, pos, state);
        this.tank = new Tank(blockEntityName, tankCapacity);
        this.inventory = new RebornInventory(3, blockEntityName, 64, (MachineBaseBlockEntity)this);
        this.euTick = euTick;
        this.recipeType = type;
        this.ticksSinceLastChange = 0;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.method_8608()) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange >= 10) {
            class_1799 inputStack = this.inventory.method_5438(0);
            if (!inputStack.method_7960()) {
                if (FluidUtils.containsMatchingFluid((class_1799)inputStack, f -> this.getRecipeForFluid((class_3611)f) != null)) {
                    FluidUtils.drainContainers((Tank)this.tank, this.inventory, (int)0, (int)1);
                } else {
                    FluidUtils.fillContainers((Tank)this.tank, this.inventory, (int)0, (int)1);
                }
            }
            this.ticksSinceLastChange = 0;
        }
        if (!this.tank.getFluidAmount().isEmpty()) {
            if (this.currentRecipe == null || !FluidUtils.fluidEquals((class_3611)this.currentRecipe.getFluid(), (class_3611)this.tank.getFluid())) {
                this.currentRecipe = this.getRecipeForFluid(this.tank.getFluid());
            }
            if (this.currentRecipe != null) {
                int euPerBucket = this.currentRecipe.power() * 1000;
                float fluidPerTick = (float)this.euTick / ((float)euPerBucket / (float)FluidValue.BUCKET.getRawValue());
                if (this.tryAddingEnergy(this.euTick)) {
                    this.pendingWithdraw += (double)fluidPerTick;
                    int currentWithdraw = (int)this.pendingWithdraw;
                    this.pendingWithdraw -= (double)currentWithdraw;
                    this.tank.modifyFluid(fluidInstance -> fluidInstance.subtractAmount(FluidValue.fromRaw((long)currentWithdraw)));
                    this.lastOutput = world.method_8510();
                }
            }
        }
        if (world.method_8510() - this.lastOutput < 30L && !this.isActive()) {
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
        } else if (world.method_8510() - this.lastOutput > 30L && this.isActive()) {
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public int getProgressScaled(int scale) {
        if (this.isActive()) {
            return this.ticksSinceLastChange * scale;
        }
        return 0;
    }

    protected boolean tryAddingEnergy(int amount) {
        if (this.getFreeSpace() > 0L) {
            this.addEnergy(amount);
            return true;
        }
        return false;
    }

    public List<FluidGeneratorRecipe> getRecipes() {
        return RecipeUtils.getRecipes((class_1937)this.field_11863, this.recipeType);
    }

    @Nullable
    public FluidGeneratorRecipe getRecipeForFluid(class_3611 fluid) {
        for (FluidGeneratorRecipe recipe : this.getRecipes()) {
            if (recipe.getFluid() != fluid) continue;
            return recipe;
        }
        return null;
    }

    public long getBaseMaxOutput() {
        return this.euTick;
    }

    public long getBaseMaxInput() {
        return 0L;
    }

    public boolean canAcceptEnergy(@Nullable class_2350 side) {
        return false;
    }

    public RebornInventory<?> getInventory() {
        return this.inventory;
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.tank.read(view);
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        this.tank.write(view);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public int getTicksSinceLastChange() {
        return this.ticksSinceLastChange;
    }

    public void setTicksSinceLastChange(int ticksSinceLastChange) {
        this.ticksSinceLastChange = ticksSinceLastChange;
    }

    public FluidValue getTankAmount() {
        return this.tank.getFluidAmount();
    }

    public void setTankAmount(FluidValue amount) {
        this.tank.setFluidAmount(amount);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

