/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;

public abstract class ScrollPanel
extends class_362
implements class_4068,
class_6379 {
    private final class_310 client;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    private boolean scrolling;
    protected float scrollDistance;
    protected boolean captureMouse = true;
    protected final int border;
    private final int barWidth;
    private final int barLeft;
    private final int barBgColor;
    private final int barColor;
    private final int barBorderColor;

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border) {
        this(client, width, height, top, left, border, 6);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border, int barWidth) {
        this(client, width, height, top, left, border, barWidth, -16777216, -8355712, -4144960);
    }

    public ScrollPanel(class_310 client, int width, int height, int top, int left, int border, int barWidth, int barBgColor, int barColor, int barBorderColor) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - barWidth;
        this.border = border;
        this.barWidth = barWidth;
        this.barBgColor = barBgColor;
        this.barColor = barColor;
        this.barBorderColor = barBorderColor;
    }

    protected abstract int getContentHeight();

    protected boolean clickPanel(double mouseX, double mouseY, class_11909 event) {
        return false;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    private void applyScrollLimits() {
        int max = this.getMaxScroll();
        if (max < 0) {
            max /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    public boolean method_25401(double p_94686_, double p_94687_, double p_94688_, double p_294830_) {
        if (p_294830_ != 0.0) {
            this.scrollDistance += (float)(-p_294830_ * (double)this.getScrollAmount());
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected int getScrollAmount() {
        return 20;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX < (double)this.right && mouseY >= (double)this.top && mouseY < (double)this.bottom;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (super.method_25402(event, doubleClick)) {
            return true;
        }
        boolean bl = this.scrolling = event.method_74245() == 0 && event.comp_4798() >= (double)this.barLeft && event.comp_4798() < (double)this.right && event.comp_4799() >= (double)this.top && event.comp_4799() < (double)this.bottom;
        if (this.scrolling) {
            return true;
        }
        int mouseListY = (int)event.comp_4799() - this.top - this.getContentHeight() + (int)this.scrollDistance - this.border;
        if (event.comp_4798() >= (double)this.left && event.comp_4798() < (double)this.right && mouseListY < 0) {
            return this.clickPanel(event.comp_4798() - (double)this.left, event.comp_4799() - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, event);
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (super.method_25406(event)) {
            return true;
        }
        boolean ret = this.scrolling;
        this.scrolling = false;
        return ret;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - this.border * 2) {
            barHeight = this.height - this.border * 2;
        }
        return barHeight;
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_44379(this.left, this.top, this.right, this.bottom);
        int extraHeight = this.getContentHeight() + this.border - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            guiGraphics.method_25294(this.barLeft, this.top, this.barLeft + this.barWidth, this.bottom, this.barBgColor);
            guiGraphics.method_25294(this.barLeft, barTop, this.barLeft + this.barWidth, barTop + barHeight, this.barColor);
            guiGraphics.method_25294(this.barLeft, barTop, this.barLeft + this.barWidth - 1, barTop + barHeight - 1, this.barBorderColor);
        }
        guiGraphics.method_44380();
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

