/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_7417;

@Environment(value=EnvType.CLIENT)
public class ClientBackpackTooltipComponent
implements class_5684 {
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public boolean show() {
        return KeyHelper.isCtrlPressed() || this.component.isHoveredWithItem();
    }

    public int method_32661(class_327 p_365134_) {
        int height = 0;
        if (this.show()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.upgrades.isEmpty()) {
                height += 10;
                height += 18;
            }
            if (!this.component.storage.isEmpty()) {
                height += 10;
                height += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                height += 10;
                height += 18;
            }
        }
        return height;
    }

    public int method_32664(class_327 font) {
        int width = 0;
        int textWidth = 0;
        if (this.show()) {
            if (!this.component.storage.isEmpty()) {
                width += Math.min(this.component.storage.size(), 9) * 18 + Math.min(this.component.storage.size(), 9) * 2;
            }
            if (!this.component.leftFluidStack.isEmpty()) {
                textWidth = font.method_27525((class_5348)this.getFluidTankTooltip(this.component.leftFluidStack));
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                textWidth = Math.max(font.method_27525((class_5348)this.getFluidTankTooltip(this.component.rightFluidStack)), textWidth);
            }
            if (textWidth > width) {
                width = textWidth;
            }
        }
        return width;
    }

    public void method_32665(class_332 guiGraphics, class_327 pFont, int pMouseX, int pMouseY) {
        if (this.show()) {
            int yOffset = 0;
            if (!this.component.leftFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.leftFluidStack, guiGraphics, pFont, pMouseX, pMouseY);
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.rightFluidStack, guiGraphics, pFont, pMouseX, pMouseY + yOffset);
                yOffset += 10;
            }
            if (!this.component.upgrades.isEmpty()) {
                guiGraphics.method_27535(pFont, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.upgrades").method_27692(class_124.field_1054), pMouseX, pMouseY + yOffset, -1);
                yOffset += 10;
                yOffset += 18;
            }
            if (!this.component.storage.isEmpty()) {
                guiGraphics.method_27535(pFont, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.inventory").method_27692(class_124.field_1054), pMouseX, pMouseY + yOffset, -1);
                yOffset += 10;
                yOffset += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                guiGraphics.method_27535(pFont, (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.tools").method_27692(class_124.field_1054), pMouseX, pMouseY + yOffset, -1);
                yOffset += 10;
                yOffset += 18;
            }
        }
    }

    public void method_32666(class_327 pFont, int pX, int pY, int k, int k1, class_332 pGuiGraphics) {
        int yOffset = 0;
        if (this.show()) {
            int i;
            if (!this.component.leftFluidStack.isEmpty()) {
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                yOffset += 10;
            }
            boolean flag = false;
            if (!this.component.upgrades.isEmpty()) {
                yOffset += 10;
                flag = true;
                for (i = 0; i < this.component.upgrades.size(); ++i) {
                    this.renderItem(this.component.upgrades.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
            if (!this.component.storage.isEmpty()) {
                yOffset += 10;
                int j = 0;
                if (flag) {
                    yOffset += 18;
                }
                flag = true;
                boolean nextRow = false;
                for (int i2 = 0; i2 < this.component.storage.size(); ++i2) {
                    if (nextRow) {
                        yOffset += 18;
                        nextRow = false;
                    }
                    this.renderItem(this.component.storage.get(i2), pX + j * 2 + j * 18, pY + yOffset, pFont, pGuiGraphics);
                    if (j < 8) {
                        ++j;
                        continue;
                    }
                    j = 0;
                    nextRow = true;
                }
            }
            if (!this.component.tools.isEmpty()) {
                yOffset += 10;
                if (flag) {
                    yOffset += 18;
                }
                for (i = 0; i < this.component.tools.size(); ++i) {
                    this.renderItem(this.component.tools.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
        }
    }

    private void renderItem(class_1799 stack, int pX, int pY, class_327 pFont, class_332 guiGraphics) {
        guiGraphics.method_51445(stack, pX, pY);
        guiGraphics.method_51431(pFont, stack, pX, pY);
    }

    public class_2561 getFluidTankTooltip(FluidVariantWrapper fluidStack) {
        class_2561 c = CommonFluid.getFluidName(fluidStack);
        class_5250 c1 = class_2561.method_43470((String)": ");
        class_5250 c2 = class_2561.method_43470((String)(fluidStack.getAmount() + "mB")).method_27692(class_124.field_1078);
        return class_5250.method_43477((class_7417)c.method_10851()).method_10852((class_2561)c1).method_10852((class_2561)c2);
    }

    public void renderFluidTankTooltip(FluidVariantWrapper fluidStack, class_332 guiGraphics, class_327 font, int mouseX, int mouseY) {
        guiGraphics.method_27535(font, this.getFluidTankTooltip(fluidStack), mouseX, mouseY, -1);
    }
}

