/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.LimitedModConfigServer;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.packet.ConfigResponseC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigSyncS2CPacket;

public class HandshakeClient<P extends ConfigResponseC2SPacket> {
    private final BiFunction<Integer, Boolean, P> responseConstructor;
    private final Consumer<LimitedModConfigServer> updateCallback;
    private LimitedModConfigServer serverConfig = null;
    private ModConfigServer fullServerConfig = null;
    private boolean hasConnected = false;

    public HandshakeClient(BiFunction<Integer, Boolean, P> responseConstructor, Consumer<LimitedModConfigServer> updateCallback) {
        this.responseConstructor = responseConstructor;
        this.updateCallback = updateCallback;
    }

    public Optional<LimitedModConfigServer> getConfig() {
        return Optional.ofNullable(this.serverConfig);
    }

    public Optional<ModConfigServer> getFullConfig() {
        return Optional.ofNullable(this.fullServerConfig);
    }

    public boolean hasConnected() {
        return this.hasConnected;
    }

    public P handleConfigSync(ConfigSyncS2CPacket packet) {
        this.serverConfig = null;
        this.fullServerConfig = null;
        int protocolVersion = packet.protocolVersion();
        if (protocolVersion < 4) {
            DoABarrelRoll.LOGGER.error("Received config with old protocol version: {}, this version is no longer supported!", (Object)protocolVersion);
            return (P)((ConfigResponseC2SPacket)this.responseConstructor.apply(protocolVersion, false));
        }
        if (protocolVersion > 4) {
            DoABarrelRoll.LOGGER.warn("Received config with unknown protocol version: {}, will attempt to load anyway", (Object)protocolVersion);
        }
        this.serverConfig = packet.applicableConfig();
        if (!packet.isLimited()) {
            this.fullServerConfig = packet.fullConfig();
        }
        this.updateCallback.accept(this.serverConfig);
        this.hasConnected = true;
        DoABarrelRoll.LOGGER.info("Received config from server");
        return (P)((ConfigResponseC2SPacket)this.responseConstructor.apply(protocolVersion, true));
    }

    public void reset() {
        this.serverConfig = null;
        this.hasConnected = false;
    }
}

