/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.requirement;

import java.util.Objects;
import net.blay09.mods.waystones.client.requirement.RequirementRenderer;
import net.blay09.mods.waystones.requirement.CooldownRequirement;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class CooldownRequirementRenderer
implements RequirementRenderer<CooldownRequirement> {
    @Override
    public void renderWidget(class_1657 player, CooldownRequirement requirement, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, int x, int y) {
        String timeLeftStr = CooldownRequirementRenderer.formatTimeLeft(player, requirement);
        if (timeLeftStr == null) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        guiGraphics.method_25303(font, timeLeftStr, x + 1, y + 9 / 2, -21846);
    }

    @Override
    public int getWidth(class_1657 player, CooldownRequirement requirement) {
        String timeLeftStr = CooldownRequirementRenderer.formatTimeLeft(player, requirement);
        if (timeLeftStr == null) {
            return 0;
        }
        class_327 font = class_310.method_1551().field_1772;
        return font.method_1727(timeLeftStr) + 1;
    }

    @Nullable
    private static String formatTimeLeft(class_1657 player, CooldownRequirement requirement) {
        long millisLeft = requirement.getCooldownMillisLeft(player);
        if (millisLeft <= 0L) {
            return null;
        }
        long secondsLeft = millisLeft / 1000L;
        long minutesLeft = secondsLeft / 60L;
        return String.format("%02d:%02d", minutesLeft, secondsLeft %= 60L);
    }
}

